/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.SwapExchangeType;
import kd.tmc.tm.common.enums.SwapTypeEnum;

public class SettleInfoHelper {
    public static void initBuySettleInfo(DynamicObject tradebBill) {
        String entityType;
        DynamicObject productType = tradebBill.getDynamicObject("protecttype");
        switch (entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity()) {
            case "tm_rateswap": {
                SettleInfoHelper.initBuySettleInfo_RateSwap(tradebBill);
                break;
            }
            case "tm_forex_options": {
                SettleInfoHelper.initBuySettleInfo_Default(tradebBill, tradebBill.getDynamicObject("premiumcurrency"));
                break;
            }
            case "tm_structdeposit": {
                SettleInfoHelper.initBuySettleInfo_Default(tradebBill, tradebBill.getDynamicObject("currency"));
            }
        }
    }

    protected static void initBuySettleInfo_Default(DynamicObject tradebBill, DynamicObject currency) {
        DynamicObject config;
        DynamicObject org = tradebBill.getDynamicObject("org");
        DynamicObject cp = tradebBill.getDynamicObject("counterparty");
        if (EmptyUtil.isEmpty((Object)tradebBill.get("paysettletype")) && EmptyUtil.isEmpty((Object)tradebBill.get("paybankacct")) && EmptyUtil.isNoEmpty((DynamicObject)(config = SettleInfoHelper.getSettleConfig(org, cp, currency)))) {
            tradebBill.set("paysettletype", config.get("settletype"));
            tradebBill.set("paybankacct", config.get("bankaccount"));
            tradebBill.set("paybank", config.getDynamicObject("bankaccount").get("bank"));
        }
    }

    protected static void initBuySettleInfo_RateSwap(DynamicObject tradebBill) {
        if (SwapTypeEnum.currency.getValue().equals(tradebBill.getString("rateswaptype")) && SwapExchangeType.Actual.getValue().equals(tradebBill.getString("initpriextype"))) {
            DynamicObject config;
            DynamicObject org = tradebBill.getDynamicObject("org");
            DynamicObject cp = tradebBill.getDynamicObject("counterparty");
            DynamicObject payCurrency = tradebBill.getDynamicObject("currency");
            DynamicObject recCurrency = tradebBill.getDynamicObject("reccurrency");
            BigDecimal recinitexamount = tradebBill.getBigDecimal("recinitexamount");
            tradebBill.set("buysettleamt", (Object)recinitexamount.abs());
            if (EmptyUtil.isEmpty((Object)tradebBill.get("paysettletype")) && EmptyUtil.isEmpty((Object)tradebBill.get("paybankacct")) && EmptyUtil.isNoEmpty((DynamicObject)(config = SettleInfoHelper.getSettleConfig(org, cp, payCurrency)))) {
                tradebBill.set("paysettletype", config.get("settletype"));
                tradebBill.set("paybankacct", config.get("bankaccount"));
                tradebBill.set("paybank", config.getDynamicObject("bankaccount").get("bank"));
            }
            if (EmptyUtil.isEmpty((Object)tradebBill.get("recsettletype")) && EmptyUtil.isEmpty((Object)tradebBill.get("recbankacct")) && EmptyUtil.isNoEmpty((DynamicObject)(config = SettleInfoHelper.getSettleConfig(org, cp, recCurrency)))) {
                tradebBill.set("recsettletype", config.get("settletype"));
                tradebBill.set("recbankacct", config.get("bankaccount"));
                tradebBill.set("recbank", config.getDynamicObject("bankaccount").get("bank"));
            }
        }
    }

    public static DynamicObject getSettleConfig(DynamicObject org, DynamicObject cp, DynamicObject currency) {
        QFilter filter = new QFilter("org.id", "=", (Object)org.getLong("id"));
        filter.and(new QFilter("counterparty.id", "=", (Object)cp.getLong("id")));
        filter.and(new QFilter("currencycol.fbasedataid", "=", (Object)currency.getLong("id")));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject info = TmcDataServiceHelper.loadSingle((String)"tbd_settleconfig", (String)"settletype,bankaccount,bankaccount.bank", (QFilter[])new QFilter[]{filter});
        return info;
    }
}

