/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.CompareSymbolEnum;
import kd.tmc.fbp.common.enums.MarkPriceEnum;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.DisplayFormEnum;
import kd.tmc.tm.common.enums.HookTypeEnum;
import kd.tmc.tm.common.enums.ObsFrequeEnum;
import kd.tmc.tm.common.errorcode.TeErrorCode;
import kd.tmc.tm.common.resource.TeBizResource;

public class StructDepositHelper {
    private static final long ONE_HOUR_MILLSECONDS = 3600000L;
    private static final Log logger = LogFactory.getLog(StructDepositHelper.class);

    public static void initFirstObsDate(IDataModel model, IFormView view, boolean isInitVal) throws KDException {
        Date intDate = (Date)model.getValue("intdate");
        Date settleDate = (Date)model.getValue("settledate");
        String structType = (String)model.getValue("structtype");
        String obsreq = (String)model.getValue("obsfreq");
        if ("break".equals(structType) && ObsFrequeEnum.one.getValue().equals(obsreq)) {
            Integer settleDelay = (Integer)model.getValue("settledelay");
            DynamicObjectCollection markCalender = (DynamicObjectCollection)model.getValue("markcalender");
            if (EmptyUtil.isNoEmpty((Object)settleDate)) {
                settleDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)markCalender, (Date)settleDate, (int)(-settleDelay.intValue()));
            }
            model.setValue("firstobsdate", (Object)settleDate);
        } else if (isInitVal) {
            model.setValue("firstobsdate", (Object)intDate);
        }
        ((DateTimeEdit)view.getControl("firstobsdate")).setMinDate(intDate);
        ((DateTimeEdit)view.getControl("firstobsdate")).setMaxDate(settleDate);
    }

    public static void initLastObsDate(IDataModel model, IFormView view, boolean isInitVal) throws KDException {
        Date firstObsDate = (Date)model.getValue("firstobsdate");
        Date settleDate = (Date)model.getValue("settledate");
        ((DateTimeEdit)view.getControl("lastobsdate")).setMaxDate(settleDate);
        ((DateTimeEdit)view.getControl("lastobsdate")).setMinDate(firstObsDate);
        String obsFreq = (String)model.getValue("obsfreq");
        if (EmptyUtil.isNoEmpty((String)obsFreq) && ObsFrequeEnum.one.getValue().equals(obsFreq)) {
            TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)false, (String[])new String[]{"lastobsdate"});
        } else {
            String structType = (String)model.getValue("structtype");
            Integer settleDelay = (Integer)model.getValue("settledelay");
            DateEdit lastObsDateEdit = (DateEdit)view.getControl("lastobsdate");
            DynamicObjectCollection markCalender = (DynamicObjectCollection)model.getValue("markcalender");
            if (EmptyUtil.isNoEmpty((Object)settleDate)) {
                settleDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)markCalender, (Date)settleDate, (int)(-settleDelay.intValue()));
            }
            model.setValue("lastobsdate", (Object)settleDate);
            if ("total".equals(structType)) {
                view.setEnable(Boolean.FALSE, new String[]{"lastobsdate"});
            } else {
                lastObsDateEdit.setMaxDate(settleDate);
                view.setEnable(Boolean.TRUE, new String[]{"lastobsdate"});
            }
            TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)true, (String[])new String[]{"lastobsdate"});
        }
        if (isInitVal && settleDate != null) {
            model.setValue("lastobsdate", (Object)settleDate);
        }
    }

    public static boolean isObsTotalPredictRate(ModelAgent bill) throws KDException {
        String dayType = (String)bill.getValue("daytype");
        Date obsDate = TcDateUtils.getCurrentDate();
        DynamicObjectCollection workCalendars = (DynamicObjectCollection)bill.getValue("workcalendar");
        boolean isobs = "work".equals(dayType) ? WorkCalendarHelper.isWorkDay((DynamicObjectCollection)workCalendars, (Date)obsDate) : true;
        logger.info("\u5224\u65ad\u91ca\u653e\u5de5\u4f5c\u65e5 " + isobs);
        if (isobs) {
            BigDecimal markPrice = StructDepositHelper.getMarketMarkPrice(bill, true, false, null);
            return StructDepositHelper.isObsTotalPredictRate(bill, markPrice);
        }
        return false;
    }

    private static boolean isObsTotalPredictRate(ModelAgent bill, BigDecimal markPrice) {
        boolean result = false;
        if (markPrice == null) {
            return result;
        }
        DynamicObjectCollection zones = (DynamicObjectCollection)bill.getValue("zone");
        for (DynamicObject zone : zones) {
            BigDecimal x = zone.getBigDecimal("pricex");
            BigDecimal y = zone.getBigDecimal("pricey");
            if (!EmptyUtil.isNoEmpty((BigDecimal)x) || !EmptyUtil.isNoEmpty((BigDecimal)y) || markPrice.compareTo(x) < 0 || markPrice.compareTo(y) > 0) continue;
            result = true;
            break;
        }
        logger.info("\u5224\u65ad\u6807\u7684\u4ef7\u683c\u662f\u5426\u5728\u533a\u95f4\u5185 " + result);
        return result;
    }

    public static BigDecimal callTotalPredictResult(ModelAgent bill) throws KDException {
        BigDecimal rate = StructDepositHelper.callTotalPredictRate(bill);
        String displayForm = (String)bill.getValue("displayform");
        if (DisplayFormEnum.intest.getValue().equals(displayForm) && EmptyUtil.isNoEmpty((BigDecimal)rate)) {
            BigDecimal days = new BigDecimal(StructDepositHelper.getPeriodDays(bill));
            rate = StructDepositHelper.callPredictIntest(bill, rate, days);
        }
        return rate;
    }

    public static BigDecimal callTotalPredictRate(ModelAgent bill) throws KDException {
        BigDecimal innerRate = Constants.ZERO;
        BigDecimal outerRate = Constants.ZERO;
        BigDecimal M = (BigDecimal)bill.getValue("predictmark");
        int D = StructDepositHelper.getD(bill);
        DynamicObjectCollection zones = (DynamicObjectCollection)bill.getValue("zone");
        for (DynamicObject zone : zones) {
            BigDecimal x = zone.getBigDecimal("pricex");
            BigDecimal y = zone.getBigDecimal("pricey");
            BigDecimal rate = zone.getBigDecimal("rate");
            if (EmptyUtil.isNoEmpty((BigDecimal)x) && EmptyUtil.isNoEmpty((BigDecimal)y)) {
                innerRate = rate;
                continue;
            }
            outerRate = rate;
        }
        if (D == 0) {
            return Constants.ZERO;
        }
        BigDecimal rate = innerRate.multiply(M).divide(new BigDecimal(D), 6, 4).add(outerRate.multiply(Constants.ONE.subtract(M.divide(new BigDecimal(D), 6, 4))));
        return rate;
    }

    public static int getD(ModelAgent bill) {
        DynamicObjectCollection wc = (DynamicObjectCollection)bill.getValue("workcalendar");
        Date intDate = (Date)bill.getValue("intdate");
        Date settleDate = (Date)bill.getValue("settledate");
        String dayType = (String)bill.getValue("daytype");
        return "work".equals(dayType) ? TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)wc, (Date)intDate, (Date)settleDate) : TcDateUtils.getDiffDays((Date)intDate, (Date)settleDate);
    }

    public static BigDecimal[] callBreakPredictResult(ModelAgent model, boolean isQuerySysNewest) throws KDException {
        BigDecimal markPrice = StructDepositHelper.getMarketMarkPrice(model, true, isQuerySysNewest, null);
        BigDecimal predictRate = StructDepositHelper.callBreakPredictRate(model, markPrice);
        predictRate = StructDepositHelper.callBreakPredictIntest(model, predictRate);
        return new BigDecimal[]{markPrice, predictRate};
    }

    public static BigDecimal callBreakPredictRate(ModelAgent bill, boolean isQuerySysNewest) {
        BigDecimal markPrice = StructDepositHelper.getMarketMarkPrice(bill, true, isQuerySysNewest, null);
        logger.info("------markPrice=" + markPrice + "------");
        return StructDepositHelper.callBreakPredictRate(bill, markPrice);
    }

    public static BigDecimal callBreakPredictRate(ModelAgent model, BigDecimal markPrice) {
        BigDecimal rate = Constants.ZERO;
        if (EmptyUtil.isNoEmpty((BigDecimal)markPrice)) {
            Map<String, Object> price;
            List<Map<String, Object>> priceZone = StructDepositHelper.transBreakMarkPriceZone(model);
            logger.info("------priceZone=" + priceZone + "------");
            Iterator<Map<String, Object>> iterator = priceZone.iterator();
            while (iterator.hasNext() && !EmptyUtil.isNoEmpty((BigDecimal)(rate = StructDepositHelper.compareBreakMarkPrice(price = iterator.next(), markPrice)))) {
            }
        }
        logger.info("------rate=" + rate + "------");
        return rate;
    }

    public static boolean isBreakRateObstacle(ModelAgent model, BigDecimal markPrice) {
        DynamicObjectCollection zones = (DynamicObjectCollection)model.getValue("zone");
        for (DynamicObject zone : zones) {
            BigDecimal x = zone.getBigDecimal("pricex");
            BigDecimal y = zone.getBigDecimal("pricey");
            x = StructDepositHelper.callMarkPrice(model, x);
            y = StructDepositHelper.callMarkPrice(model, y);
            boolean isObsTacle = zone.getBoolean("obstacle");
            if (isObsTacle && EmptyUtil.isEmpty((BigDecimal)x) && EmptyUtil.isNoEmpty((BigDecimal)y) && y.compareTo(markPrice) > 0) {
                return true;
            }
            if (!isObsTacle || !EmptyUtil.isEmpty((BigDecimal)y) || !EmptyUtil.isNoEmpty((BigDecimal)x) || x.compareTo(markPrice) >= 0) continue;
            return true;
        }
        return false;
    }

    public static List<Map<String, Object>> transBreakMarkPriceZone(ModelAgent model) {
        DynamicObjectCollection zones = (DynamicObjectCollection)model.getValue("zone");
        LinkedList<Map<String, Object>> priceZone = new LinkedList<Map<String, Object>>();
        for (DynamicObject zone : zones) {
            HashMap<String, BigDecimal> zoneMap = new HashMap<String, BigDecimal>();
            BigDecimal x = zone.getBigDecimal("pricex");
            BigDecimal y = zone.getBigDecimal("pricey");
            BigDecimal rate = zone.getBigDecimal("rate");
            DynamicObject symbol = zone.getDynamicObject("bwsymbol");
            zoneMap.put("x", StructDepositHelper.callMarkPrice(model, x));
            zoneMap.put("y", StructDepositHelper.callMarkPrice(model, y));
            zoneMap.put("rate", rate);
            zoneMap.put("symbol", (BigDecimal)symbol);
            priceZone.add(zoneMap);
        }
        return priceZone;
    }

    protected static BigDecimal compareBreakMarkPrice(Map<String, Object> price, BigDecimal markPrice) {
        BigDecimal rate = null;
        BigDecimal x = (BigDecimal)price.get("x");
        BigDecimal y = (BigDecimal)price.get("y");
        BigDecimal mark = (BigDecimal)price.get("rate");
        DynamicObject symbol = (DynamicObject)price.get("symbol");
        if (EmptyUtil.isNoEmpty((BigDecimal)x) && EmptyUtil.isNoEmpty((BigDecimal)y)) {
            boolean inY;
            String begin = symbol.getString("begin");
            String end = symbol.getString("end");
            boolean inX = CompareSymbolEnum.equal.getValue().equals(begin) && markPrice.compareTo(x) >= 0 || CompareSymbolEnum.not_equal.getValue().equals(begin) && markPrice.compareTo(x) > 0;
            boolean bl = inY = CompareSymbolEnum.equal.getValue().equals(end) && markPrice.compareTo(y) <= 0 || CompareSymbolEnum.not_equal.getValue().equals(end) && markPrice.compareTo(y) < 0;
            if (inX && inY) {
                rate = mark;
            }
        } else if (EmptyUtil.isEmpty((BigDecimal)x)) {
            String end = symbol.getString("end");
            if (CompareSymbolEnum.equal.getValue().equals(end) && markPrice.compareTo(y) <= 0 || CompareSymbolEnum.not_equal.getValue().equals(end) && markPrice.compareTo(y) < 0) {
                rate = mark;
            }
        } else if (EmptyUtil.isEmpty((BigDecimal)y)) {
            String begin = symbol.getString("begin");
            if (CompareSymbolEnum.equal.getValue().equals(begin) && markPrice.compareTo(x) >= 0 || CompareSymbolEnum.not_equal.getValue().equals(begin) && markPrice.compareTo(x) > 0) {
                rate = mark;
            }
        }
        return rate;
    }

    public static BigDecimal callMarkPrice(ModelAgent model, BigDecimal price) {
        String priceMethod;
        if (EmptyUtil.isEmpty((BigDecimal)price)) {
            price = Constants.ZERO;
        }
        if ("precent".equals(priceMethod = (String)model.getValue("pricemethod"))) {
            price = price.divide(Constants.ONE_HUNDRED, 6, 4);
            BigDecimal initprice = (BigDecimal)model.getValue("initialprice");
            if (EmptyUtil.isNoEmpty((BigDecimal)initprice)) {
                price = price.multiply(initprice);
            }
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        price = new BigDecimal(nf.format(price));
        return price;
    }

    public static BigDecimal callBreakPredictIntest(ModelAgent bill, BigDecimal rate) {
        String displayForm = (String)bill.getValue("displayform");
        if (DisplayFormEnum.intest.getValue().equals(displayForm) && EmptyUtil.isNoEmpty((BigDecimal)rate)) {
            BigDecimal days = StructDepositHelper.getBreakPeriodDays(bill);
            rate = StructDepositHelper.callPredictIntest(bill, rate, days);
        }
        return rate;
    }

    public static BigDecimal callPredictIntest(ModelAgent bill, BigDecimal rate, BigDecimal days) {
        if (EmptyUtil.isNoEmpty((BigDecimal)rate)) {
            BigDecimal amount = (BigDecimal)bill.getValue("amount");
            BigDecimal yrbasis = new BigDecimal(StructDepositHelper.getyrbasis(bill));
            logger.info("rate = " + rate + " * " + amount + " * " + days + "/ 100 / " + yrbasis);
            rate = rate.multiply(amount).multiply(days).divide(Constants.ONE_HUNDRED).divide(yrbasis, 6, 4);
        }
        return rate;
    }

    public static int getyrbasis(ModelAgent bill) {
        BasisEnum basis = BasisEnum.valueOf((String)((String)bill.getValue("basis")));
        return TradeBusinessHelper.getBasis_YearDay((int)1, (BasisEnum)basis);
    }

    public static BigDecimal getBreakPeriodDays(ModelAgent bill) {
        Integer D = null;
        String redeemType = (String)bill.getValue("redeemtype");
        Date redeemDate = (Date)bill.getValue("redeemdate");
        if ("auto_redeem".equals(redeemType) && EmptyUtil.isNoEmpty((Object)redeemDate)) {
            Date intDate = (Date)bill.getValue("intdate");
            D = TcDateUtils.getDiffDays((Date)intDate, (Date)redeemDate);
        } else {
            D = StructDepositHelper.getPeriodDays(bill);
        }
        return new BigDecimal(D);
    }

    public static int getPeriodDays(ModelAgent bill) {
        BasisEnum basis = BasisEnum.valueOf((String)((String)bill.getValue("basis")));
        DynamicObjectCollection workCalendars = (DynamicObjectCollection)bill.getValue("workcalendar");
        int periodDays = TradeBusinessHelper.getBasis_BetweenDay((Date)((Date)bill.getValue("intdate")), (Date)((Date)bill.getValue("settledate")), (BasisEnum)basis, (DynamicObject[])((DynamicObject[])workCalendars.toArray((Object[])new DynamicObject[workCalendars.size()])));
        return periodDays;
    }

    public static BigDecimal getMarketMarkPrice(Object bill, boolean showErrorMsg, boolean isQuerySysNewest, Date date) {
        DynamicObjectCollection zones;
        DynamicObject markZone;
        Integer markTime;
        String priceType;
        String hookMark;
        String hook;
        if (bill instanceof ModelAgent) {
            hook = (String)((ModelAgent)bill).getValue("hooktype");
            hookMark = (String)((ModelAgent)bill).getValue("hookmark");
            priceType = (String)((ModelAgent)bill).getValue("markprice");
            markTime = (Integer)((ModelAgent)bill).getValue("marktime");
            markZone = (DynamicObject)((ModelAgent)bill).getValue("markzone");
        } else {
            hook = ((DynamicObject)bill).getString("hooktype");
            hookMark = ((DynamicObject)bill).getString("hookmark");
            priceType = ((DynamicObject)bill).getString("markprice");
            markTime = ((DynamicObject)bill).getInt("marktime");
            markZone = ((DynamicObject)bill).getDynamicObject("markzone");
        }
        if (MarkPriceEnum.ctu_price.getValue().equals(priceType) && (zones = bill instanceof ModelAgent ? (DynamicObjectCollection)((ModelAgent)bill).getValue("zone") : ((DynamicObject)bill).getDynamicObjectCollection("zone")).size() > 0) {
            boolean lastObs;
            boolean firstObs = ((DynamicObject)zones.get(0)).getBoolean("obstacle");
            if (firstObs) {
                priceType = MarkPriceEnum.min_price.getValue();
            }
            if (lastObs = ((DynamicObject)zones.get(zones.size() - 1)).getBoolean("obstacle")) {
                priceType = MarkPriceEnum.max_price.getValue();
            }
            if (!firstObs && !lastObs) {
                throw new TmcBizException(TeErrorCode.COMMON, new Object[]{new TeBizResource().checkStructDepositZoneObstacle()});
            }
        }
        HookTypeEnum hookType = HookTypeEnum.valueOf(hook);
        if (isQuerySysNewest) {
            return StructDepositHelper.getMarketMarkPrice_sysNewest(bill, hookMark, priceType, markTime, markZone, hookType);
        }
        return StructDepositHelper.getMarketMarkPrice_currentDate(bill, showErrorMsg, hookMark, priceType, markTime, markZone, hookType, date);
    }

    private static BigDecimal getMarketMarkPrice_sysNewest(Object bill, String hookMark, String priceType, Integer markTime, DynamicObject markZone, HookTypeEnum hookType) {
        BigDecimal v = null;
        Date markDate = TcDateUtils.getCurrentDate();
        if (MarkPriceEnum.spec_point.getValue().equals(priceType) && EmptyUtil.isNoEmpty((Integer)markTime) && EmptyUtil.isNoEmpty((DynamicObject)markZone)) {
            markDate = TcDateUtils.addSecond((Date)markDate, (int)markTime);
            TimeZone zone = TcDateUtils.getTimeZone((DynamicObject)markZone);
            TimeZone sysZone = KDDateUtils.getSysTimeZone();
            if (!zone.getID().equals(sysZone.getID())) {
                markDate = TcDateUtils.getZoneTime((Date)markDate, (TimeZone)zone);
            }
        }
        switch (hookType) {
            case referindex: {
                String markPriceKey = MarkPriceEnum.valueOf((String)priceType).getValue();
                QFilter filter = new QFilter("number", "=", (Object)hookMark).and(new QFilter("enable", "=", (Object)"1"));
                Object[] indexs = TmcDataServiceHelper.load((String)"md_dataindex", (String)markPriceKey, (QFilter[])new QFilter[]{filter}, (String)"bizdate desc", (int)1);
                if (!EmptyUtil.isNoEmpty((Object[])indexs)) break;
                v = indexs[0].getBigDecimal(markPriceKey);
                break;
            }
            case referrate: {
                v = MarketDataServiceHelper.referRate((String)hookMark, (Date)markDate);
                QFilter filter = new QFilter("referrate.number", "=", (Object)hookMark).and(new QFilter("enable", "=", (Object)"1"));
                Object[] referRates = TmcDataServiceHelper.load((String)"md_datarate", (String)"endprice", (QFilter[])new QFilter[]{filter}, (String)"bizdate desc", (int)1);
                if (!EmptyUtil.isNoEmpty((Object[])referRates)) break;
                v = referRates[0].getBigDecimal("endprice");
                break;
            }
            case exrate: {
                DynamicObject forexQuote;
                DynamicObject priceRule = bill instanceof ModelAgent ? (DynamicObject)((ModelAgent)bill).getValue("pricerule") : ((DynamicObject)bill).getDynamicObject("pricerule");
                if (!EmptyUtil.isNoEmpty((String)hookMark) || !EmptyUtil.isNoEmpty((DynamicObject)priceRule) || (forexQuote = priceRule.getDynamicObject("forexquote")) == null) break;
                forexQuote = TmcDataServiceHelper.loadSingle((Object)forexQuote.getPkValue(), (String)"md_forexquote", (String)"input_quotetype,term,midprice");
                DynamicObjectCollection quoteInput = forexQuote.getDynamicObjectCollection("quoteinput");
                v = StructDepositHelper.getSpotMiddlePrice(quoteInput, hookMark);
                break;
            }
            case goods: {
                String markPriceKey = StructDepositHelper.convertMarkPrice(priceType);
                QFilter filter = new QFilter("number", "=", (Object)hookMark).and(new QFilter("enable", "=", (Object)"1"));
                Object[] goods = TmcDataServiceHelper.load((String)"md_datagoods", (String)markPriceKey, (QFilter[])new QFilter[]{filter}, (String)"bizdate desc", (int)1);
                if (!EmptyUtil.isNoEmpty((Object[])goods)) break;
                v = goods[0].getBigDecimal(markPriceKey);
                break;
            }
        }
        return v;
    }

    private static BigDecimal getMarketMarkPrice_currentDate(Object bill, boolean showErrorMsg, String hookMark, String priceType, Integer markTime, DynamicObject markZone, HookTypeEnum hookType, Date date) {
        BigDecimal v = null;
        switch (hookType) {
            case referindex: {
                v = StructDepositHelper.queryReferIndex(hookMark, priceType, markTime, markZone, date);
                break;
            }
            case referrate: {
                v = StructDepositHelper.queryReferRate(hookMark, date);
                break;
            }
            case exrate: {
                DynamicObject priceRule;
                if (bill instanceof ModelAgent) {
                    priceRule = (DynamicObject)((ModelAgent)bill).getValue("pricerule");
                    if (EmptyUtil.isEmpty((DynamicObject)priceRule)) {
                        DynamicObject billObj = TmcDataServiceHelper.loadSingle((Object)((ModelAgent)bill).getValue("id"), (String)"tm_structdeposit");
                        priceRule = billObj.getDynamicObject("pricerule");
                    }
                } else {
                    priceRule = ((DynamicObject)bill).getDynamicObject("pricerule");
                }
                if (!EmptyUtil.isNoEmpty((String)hookMark) || !EmptyUtil.isNoEmpty((DynamicObject)priceRule)) break;
                Object forexQuoteId = priceRule.getDynamicObject("forexquote").getPkValue();
                v = StructDepositHelper.queryExRate(hookMark, markTime, markZone, forexQuoteId, date);
                break;
            }
            case goods: {
                v = StructDepositHelper.queryGoodsPrice(hookMark, priceType, date);
                break;
            }
        }
        if (v == null && showErrorMsg) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e02\u573a\u6570\u636e\u6ca1\u6709\u5f53\u5929\u5bf9\u5e94\u65f6\u95f4\u70b9\u7684\u62a5\u4ef7\u6570\u636e\uff0c\u66f4\u65b0\u5931\u8d25\u3002", (String)"StructDepositHelper_2", (String)"tmc-tm-common", (Object[])new Object[0]));
        }
        return v;
    }

    private static BigDecimal queryGoodsPrice(String number, String priceType, Date date) {
        if (date == null) {
            date = TcDateUtils.getCurrentDate();
        }
        String markPriceKey = StructDepositHelper.convertMarkPrice(priceType);
        QFilter filter = new QFilter("number", "=", (Object)number).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("bizdate", ">=", (Object)date)).and(new QFilter("bizdate", "<", (Object)TcDateUtils.getNextDay((Date)date, (int)1)));
        Object[] goods = TmcDataServiceHelper.load((String)"md_datagoods", (String)markPriceKey, (QFilter[])new QFilter[]{filter}, (String)"bizdate desc");
        if (EmptyUtil.isNoEmpty((Object[])goods)) {
            return goods[0].getBigDecimal(markPriceKey);
        }
        return null;
    }

    private static BigDecimal queryReferIndex(String number, String priceType, Integer markTime, DynamicObject markZone, Date date) {
        Date obsDate = date == null ? TcDateUtils.getCurrentDate() : date;
        QFilter filter = new QFilter("referindex.number", "=", (Object)number).and(new QFilter("enable", "=", (Object)"1"));
        if (MarkPriceEnum.spec_point.getValue().equals(priceType)) {
            obsDate = TcDateUtils.addSecond((Date)obsDate, (int)markTime);
            filter.and(new QFilter("quotetype", "=", (Object)"time"));
            filter.and(new QFilter("bizdate", ">=", (Object)TcDateUtils.getLastDay((Date)obsDate, (int)1)));
            filter.and(new QFilter("bizdate", "<=", (Object)TcDateUtils.getNextDay((Date)obsDate, (int)1)));
        } else {
            filter.and(new QFilter("quotetype", "=", (Object)"day"));
            filter.and(new QFilter("bizdate", ">=", (Object)obsDate));
            filter.and(new QFilter("bizdate", "<", (Object)TcDateUtils.getNextDay((Date)obsDate, (int)1)));
        }
        DynamicObject[] referIndexArray = TmcDataServiceHelper.load((String)"md_dataindex", (String)"bizdate,begin_price,end_price,max_price,min_price,spec_point", (QFilter[])filter.toArray(), (String)"bizdate desc");
        if (MarkPriceEnum.spec_point.getValue().equals(priceType)) {
            markZone = TmcDataServiceHelper.loadSingle((Object)markZone.getPkValue(), (String)"inte_timezone", (String)"timedif");
            DynamicObject referIndexObj = TmcDataServiceHelper.loadSingle((String)"tbd_referindex", (String)"issuezone", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            DynamicObject referIndexIssueZone = TmcDataServiceHelper.loadSingle((Object)referIndexObj.getDynamicObject("issuezone").getPkValue(), (String)"inte_timezone", (String)"timedif");
            long obsDateMillSeconds = StructDepositHelper.getMillSeconds(obsDate, markZone);
            for (DynamicObject referIndex : referIndexArray) {
                if (obsDateMillSeconds != StructDepositHelper.getMillSeconds(referIndex.getDate("bizdate"), referIndexIssueZone)) continue;
                return referIndex.getBigDecimal(priceType);
            }
        } else {
            for (DynamicObject referIndex : referIndexArray) {
                if (!obsDate.equals(TcDateUtils.truncateDate((Date)referIndex.getDate("bizdate")))) continue;
                return referIndex.getBigDecimal(priceType);
            }
        }
        return null;
    }

    private static BigDecimal queryReferRate(String number, Date date) {
        QFilter filter;
        DynamicObject referRate;
        if (date == null) {
            date = TcDateUtils.getCurrentDate();
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(referRate = TmcDataServiceHelper.loadSingle((String)"md_datarate", (String)"endprice", (QFilter[])(filter = new QFilter("referrate.number", "=", (Object)number).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("bizdate", "=", (Object)date))).toArray())))) {
            return referRate.getBigDecimal("endprice");
        }
        return null;
    }

    private static BigDecimal queryExRate(String pair, Integer markTime, DynamicObject markZone, Object forexQuoteId, Date date) {
        if (date == null) {
            date = TcDateUtils.getCurrentDate();
        }
        Date obsDate = TcDateUtils.addSecond((Date)date, (int)markTime);
        markZone = TmcDataServiceHelper.loadSingle((Object)markZone.getPkValue(), (String)"inte_timezone", (String)"timedif");
        String selectProperties = "issuezone,issuetime";
        DynamicObject forexQuote = TmcDataServiceHelper.loadSingle((Object)forexQuoteId, (String)"md_forexquote", (String)"issuezone,issuetime,input_quotetype,term,midprice");
        Date issueTime = forexQuote.getDate("issuetime");
        DynamicObject forexQuoteTimezone = TmcDataServiceHelper.loadSingle((Object)forexQuote.getDynamicObject("issuezone").getPkValue(), (String)"inte_timezone", (String)"timedif");
        long obsDateMillSeconds = StructDepositHelper.getMillSeconds(obsDate, markZone);
        if (obsDateMillSeconds == StructDepositHelper.getMillSeconds(issueTime, forexQuoteTimezone)) {
            DynamicObjectCollection quoteInput = forexQuote.getDynamicObjectCollection("quoteinput");
            return StructDepositHelper.getSpotMiddlePrice(quoteInput, pair);
        }
        QFilter filter = new QFilter("sourcebillid", "=", forexQuoteId);
        DynamicObject[] forexQuoteHs = TmcDataServiceHelper.load((String)"md_forexquote_h", (String)selectProperties, (QFilter[])filter.toArray());
        List issueZonePks = Arrays.stream(forexQuoteHs).map(forexQuoteH -> forexQuoteH.getDynamicObject("issuezone").getPkValue()).collect(Collectors.toList());
        QFilter issueZoneFilter = new QFilter("id", "in", issueZonePks);
        DynamicObject[] issueZones = TmcDataServiceHelper.load((String)"inte_timezone", (String)"timedif", (QFilter[])new QFilter[]{issueZoneFilter});
        Map<Object, DynamicObject> issueZoneMap = Arrays.stream(issueZones).collect(Collectors.toMap(DataEntityBase::getPkValue, issueZone -> issueZone));
        for (DynamicObject forexQuoteH2 : forexQuoteHs) {
            issueTime = forexQuoteH2.getDate("issuetime");
            if (obsDateMillSeconds != StructDepositHelper.getMillSeconds(issueTime, forexQuoteTimezone = issueZoneMap.get(forexQuoteH2.getDynamicObject("issuezone").getPkValue()))) continue;
            forexQuoteH2 = TmcDataServiceHelper.loadSingle((Object)forexQuoteH2.getPkValue(), (String)"md_forexquote_h", (String)"input_quotetype,term,midprice");
            DynamicObjectCollection quoteInput = forexQuoteH2.getDynamicObjectCollection("quoteinput");
            return StructDepositHelper.getSpotMiddlePrice(quoteInput, pair);
        }
        return null;
    }

    private static BigDecimal getSpotMiddlePrice(DynamicObjectCollection quoteInput, String pair) {
        String[] ss = pair.split("/");
        String revertPair = ss[1] + "/" + ss[0];
        for (DynamicObject input : quoteInput) {
            String term = input.getString("term");
            String quoteType = input.getString("input_quotetype");
            if (!"Spot".equals(term) || !pair.equals(quoteType) && !revertPair.equals(quoteType)) continue;
            return input.getBigDecimal("midprice");
        }
        return null;
    }

    private static long getMillSeconds(Date date, DynamicObject timeZone) {
        return date.getTime() - 3600000L * (long)timeZone.getInt("timedif");
    }

    private static String convertMarkPrice(String markPrice) {
        String markPriceKey = null;
        switch (markPrice) {
            case "begin_price": {
                markPriceKey = "beginprice";
                break;
            }
            case "end_price": {
                markPriceKey = "endprice";
                break;
            }
            case "settle_price": {
                markPriceKey = "settleprice";
                break;
            }
            case "max_price": {
                markPriceKey = "maxprice";
                break;
            }
            case "min_price": {
                markPriceKey = "minprice";
                break;
            }
            case "morning_price": {
                markPriceKey = "mornprice";
                break;
            }
            case "afternoon_price": {
                markPriceKey = "noonprice";
                break;
            }
        }
        return markPriceKey;
    }

    public static List<ComboItem> initRedeemDateBox(IDataModel model, IFormView view) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String obsFreq = (String)model.getValue("obsfreq");
        if (!ObsFrequeEnum.day.getValue().equals(obsFreq) && !ObsFrequeEnum.continuous.getValue().equals(obsFreq)) {
            ComboEdit redeemDate = (ComboEdit)view.getControl("redeemdate2");
            if (ObsFrequeEnum.one.getValue().equals(obsFreq)) {
                Date firstDate = (Date)model.getValue("firstobsdate");
                if (EmptyUtil.isNoEmpty((Object)firstDate)) {
                    String obsDate = TcDateUtils.formatString((Date)firstDate, (String)"yyyy-MM-dd");
                    items.add(new ComboItem(new LocaleString(obsDate), obsDate));
                }
            } else {
                DynamicObjectCollection entrys = model.getEntryEntity("observe");
                DynamicObjectCollection wc = (DynamicObjectCollection)model.getValue("workcalendar");
                Integer settleDelay = (Integer)model.getValue("settledelay");
                for (int index = entrys.size() - 1; index >= 0; --index) {
                    DynamicObject entry = (DynamicObject)entrys.get(index);
                    Date obsDate = entry.getDate("obsdate");
                    if (!EmptyUtil.isNoEmpty((Object)obsDate)) continue;
                    obsDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)obsDate, (int)settleDelay);
                    String date = TcDateUtils.formatString((Date)obsDate, (String)"yyyy-MM-dd");
                    items.add(new ComboItem(new LocaleString(date), date));
                }
            }
            redeemDate.setComboItems(items);
        }
        return items;
    }
}

