/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.AttachmentServiceHelper;

public class TcAttachmentHelper {
    private static final Log logger = LogFactory.getLog(TcAttachmentHelper.class);

    public static List<Map<String, Object>> copyAttachment(List<Map<String, Object>> attachments, String entityName) {
        ArrayList<Map<String, Object>> attaList = new ArrayList<Map<String, Object>>(attachments.size());
        for (int i = 0; i < attachments.size(); ++i) {
            Map<String, Object> attachmentInfo = attachments.get(i);
            String fileName = (String)attachmentInfo.get("name");
            String originalUid = (String)attachmentInfo.get("uid");
            String fileType = (String)attachmentInfo.get("type");
            String description = (String)attachmentInfo.get("description");
            OrmLocaleValue creator = (OrmLocaleValue)attachmentInfo.get("creator");
            AttachmentDto attachmentDto = AttachmentServiceHelper.getAttachmentInfoByAttPk((Object)attachmentInfo.get("attPkId"));
            String url = attachmentDto.getResourcePath();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FileServiceFactory.getAttachmentFileService().download(url, (OutputStream)out, null);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            attaList.add(TcAttachmentHelper.newModelTempFile(fileName, fileType, in, originalUid, entityName, description, creator));
            try {
                ((InputStream)in).close();
                continue;
            }
            catch (IOException ioException) {
                logger.error(ioException.getMessage());
            }
        }
        return attaList;
    }

    public static Map<String, Object> newModelTempFile(String fileName, String fileType, InputStream in, String originalUid, String entityName, String description, OrmLocaleValue creator) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("entityNum", entityName);
        long time = System.currentTimeMillis();
        map.put("createdate", time);
        map.put("lastModified", time);
        map.put("name", fileName);
        try {
            map.put("size", in.available());
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        map.put("status", "success");
        map.put("type", fileType);
        map.put("description", description);
        map.put("creator", creator);
        StringBuilder uid = new StringBuilder();
        uid.append("rc-upload-");
        uid.append(time);
        uid.append("-");
        String numberIndex = null;
        int index = originalUid.lastIndexOf(45);
        if (index != -1) {
            numberIndex = originalUid.substring(index + 1);
        }
        uid.append(numberIndex);
        map.put("uid", uid.toString());
        StringBuilder newUrl = new StringBuilder();
        newUrl.append(RequestContext.get().getClientFullContextPath());
        if (!newUrl.toString().endsWith("/")) {
            newUrl.append("/");
        }
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String tempUrl = tempFileCache.saveAsUrl(fileName, in, 7200);
        newUrl.append(tempUrl);
        map.put("url", newUrl.toString());
        return map;
    }
}

