/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class NumericLimitValValidator {
    private static final BigDecimal MAX_NUMERIC_VAL = new BigDecimal("9999999999999.9999999999");
    private static final BigDecimal MIN_NUMERIC_VAL = new BigDecimal("-9999999999999.9999999999");

    public static void validate(DynamicObject ... objs) {
        for (DynamicObject obj : objs) {
            for (IDataEntityProperty property : obj.getDataEntityType().getProperties()) {
                if (!(obj.get(property.getName()) instanceof BigDecimal) || ((BigDecimal)obj.get(property.getName())).abs().compareTo(MAX_NUMERIC_VAL) <= 0) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u8ba1\u7b97\u51fa\u7684\u201c{0}\u201d\u7684\u503c\u4e3a\u201c{1}\u201d\u8d85\u51fa\u6700\u5927\u503c\u8303\u56f4\u201c{2}~{3}\u201d\u3002", (String)"NumericLimitValValidator_0", (String)"tmc-tm-common", (Object[])new Object[]{property.getDisplayName(), obj.get(property.getName()).toString(), MIN_NUMERIC_VAL.toString(), MAX_NUMERIC_VAL.toString()}));
            }
        }
    }
}

