/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.business.opservice.plprovision;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class PlProvisionSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("billstatus");
        sic.add("org");
        sic.add("plcurrencyfloatplamt");
        sic.add("localcurrencyfloatplamt");
        sic.add("plinfo");
        sic.add("tradebill");
        sic.add("tradetype");
        sic.add("tradetypes");
        sic.add("type");
        sic.add("provisiondate");
        sic.add("plcurrency");
        sic.add("localcurrency");
        sic.add("plprovisioncurrency");
        sic.add("totalprovisionamt");
        sic.add("writeoffamt");
        sic.add("writeoffstatus");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet<Object> plIds = new HashSet<Object>(4);
        if (this.getOperationVariable().containsKey("do_submit_by_list_view")) {
            return;
        }
        HashMap<Object, DynamicObject> pl2ProvisionCurrencyMap = new HashMap<Object, DynamicObject>(4);
        HashMap<Object, BigDecimal> pl2ProvisionAmtMap = new HashMap<Object, BigDecimal>(4);
        for (DynamicObject info : dataEntities) {
            DynamicObject localCurrency = info.getDynamicObject("localcurrency");
            DynamicObject plProvisionCurrency = info.getDynamicObject("plprovisioncurrency");
            String plProvisionAmtProp = plProvisionCurrency.getPkValue() == localCurrency.getPkValue() ? "localcurrencyfloatplamt" : "plcurrencyfloatplamt";
            DynamicObjectCollection col = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRow : col) {
                Object plId = entryRow.getDynamicObject("plinfo").getPkValue();
                plIds.add(plId);
                pl2ProvisionCurrencyMap.put(plId, plProvisionCurrency);
                pl2ProvisionAmtMap.put(plId, entryRow.getBigDecimal(plProvisionAmtProp));
            }
        }
        DynamicObject[] plBills = BusinessDataServiceHelper.load((String)"tbo_plinfo_history", (String)"plprovisioncurrency,plprovisionamt", (QFilter[])new QFilter("id", "in", plIds).toArray());
        ArrayList<DynamicObject> writeBackPlBills = new ArrayList<DynamicObject>(1);
        for (DynamicObject plBill : plBills) {
            BigDecimal amt = (BigDecimal)pl2ProvisionAmtMap.get(plBill.getPkValue());
            DynamicObject currency = (DynamicObject)pl2ProvisionCurrencyMap.get(plBill.getPkValue());
            DynamicObject plProvisionCurrency = plBill.getDynamicObject("plprovisioncurrency");
            BigDecimal plProvisionAmt = plBill.getBigDecimal("plprovisionamt");
            if (amt.compareTo(plProvisionAmt) == 0 && currency.getPkValue() == plProvisionCurrency.getPkValue()) continue;
            plBill.set("plprovisioncurrency", (Object)currency);
            plBill.set("plprovisionamt", (Object)amt);
            writeBackPlBills.add(plBill);
        }
        if (writeBackPlBills.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])writeBackPlBills.toArray(new DynamicObject[0]));
        }
    }
}

