/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.business.opservice.pnl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.PlCalcMethodEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PlForexDataUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PlForexDataUpgradeService.class);
    private String SELECT_SQL = "select p.fid pfid, p.ftradebillid tradeid,p.fswapdir swapdir,p.ftradetypeid tradetype,p.fbizrecordid bizrecordid,p.fbizop bizop,p.fsrcbizbillid srcbizbill, p.fmodifytime modifytime,p.fcreatetime createtime,t.fcurrencyid buycurrencyid,t.famount buyamount,t.ftradedirect tradedirect,f.fsellcurrencyid sellcurrencyid,f.ffxquote fxquote,f.fpair pair,f.fsellamount sellamount,f.fspotrate spotrate,f.fforwrate forwrate,f.fbuycurrency_far farbuycurrency,f.fbuyamount_far farbuyamount,b.frestamt restamt,b.fexrate recordexrate from t_tbo_plinfo p,t_tm_trade t,t_tm_trade_f f ,t_tm_bizrecord b where p.ftradebillid = t.fid and t.fid=f.fid and p.fbizrecordid=b.fid and p.ftradetypeid in (937486862912605184,937487193708953600,937487388609891328,941773368233832448)";
    String UPDATE_PLINFO = "update t_tbo_plinfo set fbillno=?, fmodifytime=fcreatetime where fid=?";
    String INSERT_PLINFO_E = "insert into t_tbo_plinfo_e(fid,fsellcurrencyid,fsellamount,fbuycurrencyid,fbuyamount,fstandardcurrencyid,famount,fexrate,fupdatedate,fbizrestamt,fplcalcmethod,foptiontype,fpremiumcurrencyid,fpremium) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    String UPDATE_PLINFO_E = "update t_tbo_plinfo_e set fsellcurrencyid=?,fsellamount=?,fbuycurrencyid=?,fbuyamount=?,fstandardcurrencyid=?,famount=?,fexrate=?,fupdatedate=?,fbizrestamt=?,fplcalcmethod=?,foptiontype=?,fpremiumcurrencyid=?,fpremium=? where fid =?";
    String SELECT_TREAD_O = "select fexchangerate,foptiontype,fpremcurrencyid,fpremium from t_tm_trade_o where fid=?";
    String SELECT_PLINFO_E = "select fid from t_tbo_plinfo_e where fid=?";
    String SELECT_BUSINESSBILL = "select fbizamt1,fexratedey from t_tm_businessbill where fid=?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle handle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            result.setEl("warning");
            try {
                result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5916\u6c47\u7c7b\u635f\u76ca\u4fe1\u606f\u6570\u636e\u5347\u7ea7\u3002", (String)"PlForexDataUpgradeService_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                String sql = "select count(1) as recordcount from t_bas_deployinfodetail left join t_bas_deployinfoentry on t_bas_deployinfoentry.fentryid = t_bas_deployinfodetail.fentryid where t_bas_deployinfodetail.ffilename ='kd_1.5.229_tbo_update.sql' and t_bas_deployinfoentry.fappid ='tbo'";
                int recordCount = (Integer)DB.query((DBRoute)DBRouteConst.META, (String)sql, rs -> {
                    if (rs.next()) {
                        return rs.getInt("recordcount");
                    }
                    return 0;
                });
                if (recordCount == 0) {
                    this.dataUpgrade();
                }
                result.setLog(ResManager.loadKDString((String)"\u7ed3\u675f\u6267\u884c\u5916\u6c47\u7c7b\u635f\u76ca\u4fe1\u606f\u6570\u636e\u5347\u7ea7\u3002", (String)"PlForexDataUpgradeService_1", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                StackTraceElement[] stackTrace;
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement stackTraceElement : stackTrace = e.getStackTrace()) {
                    String s = stackTraceElement.toString();
                    sb.append(s);
                    sb.append("\n");
                }
                if (EmptyUtil.isEmpty((CharSequence)sb)) {
                    result.setErrorInfo(e.getMessage());
                } else {
                    sb.append("message\uff1a").append(e.getMessage());
                    result.setErrorInfo(sb.toString());
                }
                result.setSuccess(false);
                logger.info(e.getMessage());
                logger.info(result.getErrorInfo());
                handle.markRollback();
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private void dataUpgrade() {
        DataSet dataSet = DB.queryDataSet((String)"PlForexDataUpgradeService_Trade_DataSet", (DBRoute)DBRouteConst.TC, (String)this.SELECT_SQL);
        int no = 0;
        ArrayList<Object[]> updatePlinfoParamList = new ArrayList<Object[]>(500);
        ArrayList<Object[]> updatePlinfoeParamList = new ArrayList<Object[]>(500);
        ArrayList<Object[]> insertPlinfoeParamList = new ArrayList<Object[]>(500);
        HashMap<Long, Integer> currencyMap = new HashMap<Long, Integer>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long pfid = row.getLong("pfid");
            Long tradeid = row.getLong("tradeid");
            Long tradetype = row.getLong("tradetype");
            Long srcbizbill = row.getLong("srcbizbill");
            String bizop = row.getString("bizop");
            String swapdir = row.getString("swapdir");
            String fxquote = row.getString("fxquote");
            String pair = row.getString("pair");
            Date createtime = row.getDate("createtime");
            Long buycurrencyid = row.getLong("buycurrencyid");
            Long sellcurrencyid = row.getLong("sellcurrencyid");
            Long farbuycurrency = row.getLong("farbuycurrency");
            BigDecimal buyamount = row.getBigDecimal("buyamount");
            BigDecimal spotrate = row.getBigDecimal("spotrate");
            BigDecimal forwrate = row.getBigDecimal("forwrate");
            BigDecimal farbuyamount = row.getBigDecimal("farbuyamount");
            String tradedirect = row.getString("tradedirect");
            BigDecimal restamt = row.getBigDecimal("restamt");
            ProductTypeEnum productTypeEnum = ProductTypeEnum.getEnumById((String)String.valueOf(tradetype));
            boolean isSrcTrade = this.isSrcTrade(bizop, srcbizbill);
            boolean isMaudateOrdeferTrade = this.isMaudateOrdeferTrade(bizop, srcbizbill);
            BigDecimal fbizamt1 = BigDecimal.ZERO;
            BigDecimal fexratedey = BigDecimal.ZERO;
            if (isMaudateOrdeferTrade) {
                DataSet businessbillDs = this.selectBusinessBillByid(srcbizbill);
                if (businessbillDs.hasNext()) {
                    Row businessbill = businessbillDs.next();
                    fbizamt1 = businessbill.getBigDecimal("fbizamt1");
                    fexratedey = businessbill.getBigDecimal("fexratedey");
                }
                this.closeDataSet(businessbillDs);
            }
            Long standardcurrencyid = null;
            BigDecimal standardcurrencyamt = BigDecimal.ZERO;
            Long buycurrency = null;
            BigDecimal buycurrencyamt = BigDecimal.ZERO;
            Long sellcurrency = null;
            BigDecimal sellcurrencyamt = BigDecimal.ZERO;
            BigDecimal exrate = BigDecimal.ONE;
            String fplcalcmethod = "";
            String optiontype = "";
            Long fpremcurrencyid = 0L;
            BigDecimal fpremium = BigDecimal.ZERO;
            switch (productTypeEnum) {
                case FOREXSPOT: {
                    standardcurrencyid = buycurrencyid;
                    standardcurrencyamt = buyamount;
                    buycurrency = "buy".equals(tradedirect) ? buycurrencyid : sellcurrencyid;
                    sellcurrency = "sell".equals(tradedirect) ? buycurrencyid : sellcurrencyid;
                    exrate = spotrate;
                    buycurrencyamt = this.calAmt(buycurrency, standardcurrencyid, fxquote, pair, restamt, exrate, currencyMap);
                    sellcurrencyamt = this.calAmt(sellcurrency, standardcurrencyid, fxquote, pair, restamt, exrate, currencyMap);
                    break;
                }
                case FOREXFORWARD: {
                    if (isSrcTrade) {
                        standardcurrencyid = buycurrencyid;
                        standardcurrencyamt = buyamount;
                        exrate = spotrate;
                    }
                    if (isMaudateOrdeferTrade) {
                        standardcurrencyid = buycurrencyid;
                        standardcurrencyamt = fbizamt1;
                        exrate = fexratedey;
                    }
                    buycurrency = "buy".equals(tradedirect) ? buycurrencyid : sellcurrencyid;
                    sellcurrency = "sell".equals(tradedirect) ? buycurrencyid : sellcurrencyid;
                    buycurrencyamt = this.calAmt(buycurrency, standardcurrencyid, fxquote, pair, restamt, exrate, currencyMap);
                    sellcurrencyamt = this.calAmt(sellcurrency, standardcurrencyid, fxquote, pair, restamt, exrate, currencyMap);
                    break;
                }
                case FOREXSWAPS: {
                    if (isSrcTrade) {
                        standardcurrencyid = "isnear".equals(swapdir) ? buycurrencyid : farbuycurrency;
                        standardcurrencyamt = "isnear".equals(swapdir) ? buyamount : farbuyamount;
                        BigDecimal bigDecimal = exrate = "isnear".equals(swapdir) ? spotrate : forwrate;
                    }
                    if (isMaudateOrdeferTrade) {
                        standardcurrencyamt = fbizamt1;
                        standardcurrencyid = "isnear".equals(swapdir) ? buycurrencyid : farbuycurrency;
                        exrate = fexratedey;
                    }
                    buycurrency = "isnear".equals(swapdir) && "buy".equals(tradedirect) || "isfar".equals(swapdir) && "sell".equals(tradedirect) ? buycurrencyid : sellcurrencyid;
                    sellcurrency = "isnear".equals(swapdir) && "sell".equals(tradedirect) || "isfar".equals(swapdir) && "buy".equals(tradedirect) ? buycurrencyid : sellcurrencyid;
                    buycurrencyamt = this.calAmt(buycurrency, standardcurrencyid, fxquote, pair, restamt, exrate, currencyMap);
                    sellcurrencyamt = this.calAmt(sellcurrency, standardcurrencyid, fxquote, pair, restamt, exrate, currencyMap);
                    break;
                }
                case FOREXOPTION: {
                    fplcalcmethod = PlCalcMethodEnum.EXCHANGE_RATE_NETTING.getValue();
                    standardcurrencyid = buycurrencyid;
                    standardcurrencyamt = buyamount;
                    buycurrency = "buy".equals(tradedirect) ? buycurrencyid : sellcurrencyid;
                    sellcurrency = "sell".equals(tradedirect) ? buycurrencyid : sellcurrencyid;
                    DataSet option = this.selectTradeOptionByid(tradeid);
                    if (option.hasNext()) {
                        Row op = option.next();
                        exrate = op.getBigDecimal("fexchangerate");
                        optiontype = op.getString("foptiontype");
                        fpremcurrencyid = op.getLong("fpremcurrencyid");
                        fpremium = op.getBigDecimal("fpremium");
                    }
                    this.closeDataSet(option);
                    buycurrencyamt = this.calAmt(buycurrency, standardcurrencyid, fxquote, pair, restamt, exrate, currencyMap);
                    sellcurrencyamt = this.calAmt(sellcurrency, standardcurrencyid, fxquote, pair, restamt, exrate, currencyMap);
                }
            }
            String billno = "PnL_FX" + String.format("%08d", ++no);
            Object[] updatePlinfoParams = new Object[]{billno, pfid};
            updatePlinfoParamList.add(updatePlinfoParams);
            if (updatePlinfoParamList.size() == 500) {
                this.exeSqlBatch(this.UPDATE_PLINFO, updatePlinfoParamList);
                updatePlinfoParamList.clear();
            }
            if (!this.exsitPlinfo_e(pfid)) {
                Object[] insertPlinfoeParams = new Object[]{pfid, sellcurrency, sellcurrencyamt, buycurrency, buycurrencyamt, standardcurrencyid, standardcurrencyamt, exrate, createtime, restamt, fplcalcmethod, optiontype, fpremcurrencyid, fpremium};
                insertPlinfoeParamList.add(insertPlinfoeParams);
                if (insertPlinfoeParamList.size() != 500) continue;
                this.exeSqlBatch(this.INSERT_PLINFO_E, insertPlinfoeParamList);
                insertPlinfoeParamList.clear();
                continue;
            }
            Object[] updatePlinfoeParams = new Object[]{sellcurrency, sellcurrencyamt, buycurrency, buycurrencyamt, standardcurrencyid, standardcurrencyamt, exrate, createtime, restamt, fplcalcmethod, optiontype, fpremcurrencyid, fpremium, pfid};
            updatePlinfoeParamList.add(updatePlinfoeParams);
            if (updatePlinfoeParamList.size() != 500) continue;
            this.exeSqlBatch(this.UPDATE_PLINFO_E, updatePlinfoeParamList);
            updatePlinfoeParamList.clear();
        }
        if (updatePlinfoParamList.size() > 0) {
            this.exeSqlBatch(this.UPDATE_PLINFO, updatePlinfoParamList);
        }
        if (insertPlinfoeParamList.size() > 0) {
            this.exeSqlBatch(this.INSERT_PLINFO_E, insertPlinfoeParamList);
        }
        if (updatePlinfoeParamList.size() > 0) {
            this.exeSqlBatch(this.UPDATE_PLINFO_E, updatePlinfoeParamList);
        }
        this.closeDataSet(dataSet);
    }

    private BigDecimal calAmt(Long buycurrency, Long standardcurrencyid, String fxquote, String pair, BigDecimal standardcurrencyamt, BigDecimal exrate, Map<Long, Integer> currencyMap) {
        BigDecimal amount;
        boolean isSame = StringUtils.equals((CharSequence)fxquote, (CharSequence)pair);
        int amtprecision = 6;
        if (currencyMap.containsKey(buycurrency)) {
            amtprecision = currencyMap.get(buycurrency);
        } else {
            String sql = "select famtprecision from t_bd_currency where fid = ?";
            DataSet dataSet = DB.queryDataSet((String)"PlForexDataUpgradeService_OptionTrade", (DBRoute)DBRouteConst.SYS, (String)sql, (Object[])new Object[]{buycurrency});
            if (dataSet.hasNext()) {
                amtprecision = dataSet.next().getInteger("famtprecision");
                currencyMap.put(buycurrency, amtprecision);
            }
            this.closeDataSet(dataSet);
        }
        if (isSame) {
            BigDecimal amt = standardcurrencyamt.multiply(exrate).setScale(amtprecision, RoundingMode.HALF_UP);
            amount = Objects.equals(buycurrency, standardcurrencyid) ? standardcurrencyamt : amt;
        } else {
            amount = Objects.equals(buycurrency, standardcurrencyid) ? standardcurrencyamt : (EmptyUtil.isEmpty((BigDecimal)exrate) ? BigDecimal.ZERO : standardcurrencyamt.divide(exrate, amtprecision, RoundingMode.HALF_UP));
        }
        return amount;
    }

    private void closeDataSet(DataSet dataSet) {
        if (dataSet != null) {
            dataSet.close();
        }
    }

    private DataSet selectBusinessBillByid(Long srcbizbill) {
        return DB.queryDataSet((String)"PlForexDataUpgradeService_businessbill", (DBRoute)DBRouteConst.TC, (String)this.SELECT_BUSINESSBILL, (Object[])new Object[]{srcbizbill});
    }

    private boolean exsitPlinfo_e(Long fid) {
        DataSet dataSet = DB.queryDataSet((String)"PlForexDataUpgradeService_plinfo_e", (DBRoute)DBRouteConst.TC, (String)this.SELECT_PLINFO_E, (Object[])new Object[]{fid});
        boolean exsit = dataSet.hasNext();
        this.closeDataSet(dataSet);
        return exsit;
    }

    private DataSet selectTradeOptionByid(Long fid) {
        return DB.queryDataSet((String)"PlForexDataUpgradeService_OptionTrade", (DBRoute)DBRouteConst.TC, (String)this.SELECT_TREAD_O, (Object[])new Object[]{fid});
    }

    private boolean isSrcTrade(String bizop, Long srcbizbill) {
        return EmptyUtil.isEmpty((String)bizop) && EmptyUtil.isEmpty((Long)srcbizbill);
    }

    private boolean isMaudateOrdeferTrade(String bizop, Long srcbizbill) {
        return !EmptyUtil.isEmpty((String)bizop) && !EmptyUtil.isEmpty((Long)srcbizbill);
    }

    private void exeSqlBatch(String sql, List<Object[]> paramList) {
        DB.executeBatch((DBRoute)DBRouteConst.TC, (String)sql, paramList);
    }
}

