/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.business.opservice.pnl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.ExRateDirEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.enums.PlCalcMethodEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.RateTermEnum;
import kd.tmc.fbp.common.enums.ReturnValTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.enums.UseExRateEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.business.OptionsBizHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tbo.common.helper.PlInfoCalculateHelper;
import kd.tmc.tm.common.helper.RateSwapPlHelper;

public class PlInfoCalculateService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(PlInfoCalculateService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("org");
        sic.add("tradetype");
        sic.add("tradebill");
        sic.add("forexquote");
        sic.add("fxquote");
        sic.add("plcurrency");
        sic.add("plcurrency_s");
        sic.add("referexrate");
        sic.add("updatedate");
        sic.add("floatplamt");
        sic.add("exrate_local");
        sic.add("floatpllocalamt");
        sic.add("localcurrency");
        sic.add("fxquote_local");
        sic.add("srcbizbill");
        sic.add("bizrecord");
        sic.add("swapdir");
        sic.add("fxquotetype");
        sic.add("payfloatplamt");
        sic.add("recfloatplamt");
        sic.add("spotrate");
        sic.add("type");
        sic.add("floatplamt_in");
        sic.add("floatpllocalamt_in");
        sic.add("lastenterdate");
        sic.add("bizdate");
        sic.add("settledate");
        sic.add("biztype");
        sic.add("plamt");
        sic.add("pllocalamt");
        sic.add("bizbillid");
        sic.add("bizbillno");
        sic.add("bizop");
        sic.add("floatplamtcalcdate");
        sic.add("lastobsdate");
        sic.add("payyields");
        sic.add("recyields");
        sic.add("referpremium");
        sic.add("yieldcurve");
        sic.add("billno");
        sic.add("billstatus");
        sic.add("plamt_sum");
        sic.add("pllocalamt_sum");
        sic.add("forreferexrate");
        sic.add("forfloatplamt");
        sic.add("plcalcmethod");
        sic.add("issuedate");
        sic.add("buycurrency");
        sic.add("sellcurrency");
        sic.add("standardcurrency");
        sic.add("buyamount");
        sic.add("sellamount");
        sic.add("amount");
        sic.add("exrate");
        sic.add("buy_local_fq");
        sic.add("buy_local_exrate");
        sic.add("sell_local_fq");
        sic.add("sell_local_exrate");
        sic.add("bizrestamt");
        sic.add("voucher_pl");
        sic.add("bizbillamt");
        sic.add("bizbillvoucherpl");
        sic.add("forwrate");
        sic.add("currencyrate");
        sic.add("pricecurrencyrate");
        sic.add("volatility");
        sic.add("optiontype");
        sic.add("premiumcurrency");
        sic.add("premium");
        sic.add("swaptype");
        sic.add("maxhistoryplinfo");
        sic.add("spotexrate");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Date updateDate;
        ArrayList<DynamicObject> plHistoryInfoList = new ArrayList<DynamicObject>();
        if (this.getOperationVariable().containsKey("updatedate")) {
            String updateStr = (String)this.getOperationVariable().get("updatedate");
            updateDate = DateUtils.stringToDate((String)updateStr, (String)"yyyy-MM-dd");
        } else {
            updateDate = DateUtils.getCurrentDate();
        }
        DynamicObjectCollection historyFloatPls = QueryServiceHelper.query((String)"tbo_plinfo_history", (String)"plbill,billno,provision", (QFilter[])new QFilter("plbill", "in", (Object)Arrays.stream(dataEntities).map(o -> o.getPkValue()).toArray()).and("updatedate", "=", (Object)updateDate).toArray());
        Map<Object, DynamicObject> historyFloatPlMap = historyFloatPls.stream().collect(Collectors.toMap(o -> o.get("plbill"), o -> o));
        ArrayList<String> alreadyExistBillNos = new ArrayList<String>(1);
        ArrayList<String> alreadyProvisionBillNos = new ArrayList<String>(1);
        ArrayList<String> exceptionMsgList = new ArrayList<String>(1);
        for (DynamicObject info : dataEntities) {
            try {
                List plHistoryID_maxDate;
                DynamicObject plHistoryInfo;
                DynamicObject historyFloatPl = historyFloatPlMap.get(info.getPkValue());
                if (historyFloatPl != null) {
                    if (historyFloatPl.getBoolean("provision")) {
                        alreadyProvisionBillNos.add(historyFloatPl.getString("billno"));
                        continue;
                    }
                    alreadyExistBillNos.add(historyFloatPl.getString("billno"));
                    continue;
                }
                DynamicObject tradeType = info.getDynamicObject("tradetype");
                String number = tradeType.getString("number");
                DynamicObject tradeBill = info.getDynamicObject("tradebill");
                if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number) || ProductTypeEnum.FOREXSWAPS.getValue().equals(number) || ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
                    DynamicObject bizRecord;
                    Object bizRecordId = info.get("bizrecord");
                    BigDecimal bizRestAmt = info.getBigDecimal("bizrestamt");
                    if (bizRestAmt.compareTo((bizRecord = QueryServiceHelper.queryOne((String)"tm_bizrecord", (String)"restamt", (QFilter[])new QFilter("id", "=", bizRecordId).toArray())).getBigDecimal("restamt")) != 0) {
                        info.set("bizrestamt", (Object)bizRecord.getBigDecimal("restamt"));
                        this.bizRestAmtChangeEvt(info);
                    }
                }
                if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number) || ProductTypeEnum.FOREXSWAPS.getValue().equals(number)) {
                    info.set("updatedate", (Object)updateDate);
                    PlInfoCalculateHelper.updatePlInfo_Forex((DynamicObject)info, (DynamicObject)tradeBill);
                } else if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
                    info.set("updatedate", (Object)updateDate);
                    this.updatePlInfo_ForexOption(info, tradeBill);
                }
                if (ProductTypeEnum.SWAP.getValue().equals(number)) {
                    info.set("updatedate", (Object)updateDate);
                    this.updatePlInfo_RateSwap(info, tradeBill);
                    plHistoryInfo = PlInfoCalculateHelper.buildPlHistory((DynamicObject)info);
                    this.setPlHistoryYields(tradeBill, plHistoryInfo);
                    plHistoryInfoList.add(plHistoryInfo);
                    plHistoryID_maxDate = QueryServiceHelper.queryPrimaryKeys((String)"tbo_plinfo_history", (QFilter[])new QFilter("plbill", "=", info.getPkValue()).and("updatedate", ">", info.get("updatedate")).toArray(), (String)"updatedate desc", (int)1);
                    if (EmptyUtil.isNoEmpty((Object)plHistoryID_maxDate)) {
                        info.set("maxhistoryplinfo", plHistoryID_maxDate.get(0));
                    } else {
                        long historyPlInfoId = DBServiceHelper.genGlobalLongId();
                        info.set("maxhistoryplinfo", (Object)historyPlInfoId);
                        plHistoryInfo.set("id", (Object)historyPlInfoId);
                    }
                }
                if (ProductTypeEnum.FORWRATEAGREE.getValue().equals(number)) {
                    info.set("updatedate", (Object)updateDate);
                    DynamicObject bill = TmcDataServiceHelper.loadSingle((String)"tm_forwrateagree", (String)"org,pricerule,startdate,currency,amount,basis,market,tradedirect,adjustsettledate,adjustenddate,workcalendar,settledelay,contractrate,payrule", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradeBill.getLong("id"))});
                    this.updatePlInfo_ForwRateAgree(info, bill);
                }
                if (!ProductTypeEnum.FOREXFORWARD.getValue().equals(number) && !ProductTypeEnum.FOREXSWAPS.getValue().equals(number) && !ProductTypeEnum.FOREXOPTION.getValue().equals(number) && !ProductTypeEnum.FORWRATEAGREE.getValue().equals(number)) continue;
                plHistoryInfo = PlInfoCalculateHelper.buildPlHistory((DynamicObject)info);
                plHistoryInfoList.add(plHistoryInfo);
                plHistoryID_maxDate = QueryServiceHelper.queryPrimaryKeys((String)"tbo_plinfo_history", (QFilter[])new QFilter("plbill", "=", info.getPkValue()).and("updatedate", ">", info.get("updatedate")).toArray(), (String)"updatedate desc", (int)1);
                if (EmptyUtil.isNoEmpty((Object)plHistoryID_maxDate)) {
                    info.set("maxhistoryplinfo", plHistoryID_maxDate.get(0));
                    continue;
                }
                long historyPlInfoId = DBServiceHelper.genGlobalLongId();
                info.set("maxhistoryplinfo", (Object)historyPlInfoId);
                plHistoryInfo.set("id", (Object)historyPlInfoId);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                exceptionMsgList.add(info.get("billno") + " " + e.getMessage());
            }
        }
        if (!exceptionMsgList.isEmpty()) {
            throw new KDBizException(String.join((CharSequence)"\n", exceptionMsgList));
        }
        if (!plHistoryInfoList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])plHistoryInfoList.toArray(new DynamicObject[0]));
        }
        Set<Object> plIds = historyFloatPlMap.keySet();
        Object[] bills = (DynamicObject[])Arrays.stream(dataEntities).filter(o -> !plIds.contains(o.getPkValue())).toArray(DynamicObject[]::new);
        if (EmptyUtil.isNoEmpty((Object[])bills)) {
            SaveServiceHelper.update((DynamicObject[])bills);
        }
        JSONObject message = new JSONObject();
        if (alreadyProvisionBillNos.size() > 0) {
            message.put("already_provision_bills", alreadyProvisionBillNos);
        }
        if (alreadyExistBillNos.size() > 0) {
            message.put("already_exist_bills", alreadyExistBillNos);
        }
        if (message.size() > 0) {
            ValidateResultCollection validateResults = new ValidateResultCollection();
            validateResults.setMessage(message.toString());
            this.getOperationResult().setValidateResult(validateResults);
        }
    }

    private void setPlHistoryYields(DynamicObject tradeBill, DynamicObject plHistoryInfo) {
        QFilter filter = new QFilter("id", "=", tradeBill.getPkValue());
        Long priceRule = (tradeBill = QueryServiceHelper.queryOne((String)"tm_rateswap", (String)"pricerule,market,recmarket", (QFilter[])filter.toArray())).getLong("pricerule");
        if (EmptyUtil.isNoEmpty((Long)priceRule)) {
            long market = tradeBill.getLong("market");
            long recMarket = tradeBill.getLong("recmarket");
            DynamicObject priceRuleInfo = TmcDataServiceHelper.loadSingle((Object)priceRule, (String)"md_pricerule");
            for (DynamicObject row : priceRuleInfo.getDynamicObjectCollection("yield")) {
                DynamicObject rowMarket = row.getDynamicObject("market");
                if (!EmptyUtil.isEmpty((Long)market) && rowMarket != null && YieldTypeEnum.disc.getValue().equals(row.getString("type")) && market == rowMarket.getLong("id")) {
                    plHistoryInfo.set("payyields", row.get("yields"));
                }
                if (EmptyUtil.isEmpty((Long)recMarket) || rowMarket == null || !YieldTypeEnum.disc.getValue().equals(row.getString("type")) || recMarket != rowMarket.getLong("id")) continue;
                plHistoryInfo.set("recyields", row.get("yields"));
            }
        }
    }

    private void updatePlInfo_ForexOption(DynamicObject plInfo, DynamicObject tradeBill) {
        if (EmptyUtil.isNoEmpty((DynamicObject)plInfo.getDynamicObject("forexquote"))) {
            BigDecimal floatPlAmt;
            Long fqId = plInfo.getDynamicObject("forexquote").getLong("id");
            String pair = tradeBill.getString("pair");
            String fxQuote = tradeBill.getString("fxquote");
            String useExRate = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"useexrate");
            String exRateDir = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"exratedir");
            Date Dm = UseExRateEnum.FORWARD.getValue().equals(useExRate) ? tradeBill.getDate("adjustsettledate") : null;
            ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, null, (Date)Dm);
            if (!fxQuote.equals(fqInfo.getFxquote())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u4ef7\u6765\u6e90\u7684\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u4e0e\u4ea4\u6613\u5355\u636e\u7684\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u62a5\u4ef7\u6765\u6e90\u3002", (String)"PlInfoCalculateService_0", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            BigDecimal referExrate = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? PlInfoCalculateHelper.getReferExRate_ForexOptions((ForexQuoteInfo)fqInfo, (DynamicObject)tradeBill) : fqInfo.getMiddleprice();
            plInfo.set("referexrate", (Object)referExrate);
            plInfo.set("issuedate", (Object)fqInfo.getIssuetime());
            BigDecimal spotExRate = BigDecimal.ZERO;
            if (PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(plInfo.get("plcalcmethod"))) {
                ForexQuoteInfo sportFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)plInfo.getDate("updatedate"), null);
                BigDecimal spotRate = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? PlInfoCalculateHelper.getReferExRate_ForexOptions((ForexQuoteInfo)sportFqInfo, (DynamicObject)tradeBill) : sportFqInfo.getMiddleprice();
                plInfo.set("spotrate", (Object)spotRate);
                BigDecimal exRate = "american".equals(tradeBill.getString("optiontype")) ? spotRate : referExrate;
                BigDecimal volatility = plInfo.getBigDecimal("volatility");
                BigDecimal currencyRate = plInfo.getBigDecimal("currencyrate");
                BigDecimal priceCurrencyRate = plInfo.getBigDecimal("pricecurrencyrate");
                BigDecimal referPremium = !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{currencyRate, priceCurrencyRate, volatility}) ? OptionsBizHelper.getReferPremiumOption((ModelAgent)new ModelAgent((Object)tradeBill), (BigDecimal)exRate, (DynamicObject)plInfo, (BigDecimal[])new BigDecimal[]{volatility, currencyRate, priceCurrencyRate}) : OptionsBizHelper.getReferPremiumOption((ModelAgent)new ModelAgent((Object)tradeBill), (BigDecimal)("american".equals(tradeBill.getString("optiontype")) ? spotRate : referExrate), (DynamicObject)plInfo, (BigDecimal[])new BigDecimal[0]);
                plInfo.set("referpremium", (Object)referPremium);
                floatPlAmt = PlInfoCalculateHelper.calFloatPl_ForexOption_byReferPremium((DynamicObject)plInfo, (DynamicObject)tradeBill, (boolean)false);
            } else {
                Map result = PlInfoCalculateHelper.calFloatPl_ForexOption_byExRate((DynamicObject)plInfo, (DynamicObject)tradeBill, (boolean)false, null);
                floatPlAmt = (BigDecimal)result.get("floatplamt");
                spotExRate = (BigDecimal)result.get("spotexrate");
                DynamicObject localCurrency = plInfo.getDynamicObject("localcurrency");
                if (localCurrency != null && PlInfoCalculateHelper.isShowVoucherPlPanel((DynamicObject)tradeBill, (Long)localCurrency.getLong("id"))) {
                    PlInfoCalculateHelper.setVoucherPl_plInfo((DynamicObject)plInfo, (Long)fqId, (Date)Dm);
                }
            }
            plInfo.set("floatplamt", (Object)floatPlAmt);
            plInfo.set("spotexrate", (Object)spotExRate);
            plInfo.set("issuedate", (Object)fqInfo.getIssuetime());
        }
        PlInfoCalculateHelper.updatePlInfo_Local((DynamicObject)plInfo);
    }

    private void updatePlInfo_RateSwap(DynamicObject plInfo, DynamicObject tradeBill) {
        DynamicObject plCurrency = plInfo.getDynamicObject("plcurrency");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plInfo.getDynamicObject("forexquote"), plInfo.getString("fxquotetype")})) {
            Long fqId = plInfo.getDynamicObject("forexquote").getLong("id");
            ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)plInfo.getString("fxquotetype"), null, null);
            if (EmptyUtil.isNoEmpty((DynamicObject)plCurrency)) {
                BigDecimal referExrate = plCurrency.getString("number").equals(fqInfo.getFxquote().split("/")[0]) ? fqInfo.getSellPrice() : fqInfo.getBuyPrice();
                plInfo.set("referexrate", (Object)referExrate);
                plInfo.set("issuedate", (Object)fqInfo.getIssuetime());
            }
            plInfo.set("fxquotetype", (Object)fqInfo.getFxquote());
            tradeBill = TmcDataServiceHelper.loadSingle((Object)tradeBill.getLong("id"), (String)"tm_rateswap");
            BigDecimal payfloatplamt = RateSwapPlHelper.calPayFloatPlAmt((DynamicObject)plInfo, (DynamicObject)tradeBill);
            BigDecimal recfloatplamt = RateSwapPlHelper.calRecFloatPlAmt((DynamicObject)plInfo, (DynamicObject)tradeBill);
            plInfo.set("payfloatplamt", (Object)payfloatplamt);
            plInfo.set("recfloatplamt", (Object)recfloatplamt);
            plInfo.set("floatplamt", (Object)payfloatplamt.add(recfloatplamt));
        }
        PlInfoCalculateHelper.updatePlInfo_Local((DynamicObject)plInfo);
    }

    private void updatePlInfo_ForwRateAgree(DynamicObject plInfo, DynamicObject tradeBill) {
        if (EmptyUtil.isNoEmpty((DynamicObject)plInfo.getDynamicObject("yieldcurve"))) {
            QFilter filterCashFlow = new QFilter("billid", "=", tradeBill.getPkValue());
            DynamicObject cashFlow = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"cfbizrecordid,billno,cfpayamount,entrys.cfuserate,entrys.cfratefixdate,entrys.cfratefixindex,entrys.cfperioddays", (QFilter[])new QFilter[]{filterCashFlow});
            DynamicObjectCollection entrys = cashFlow.getDynamicObjectCollection("entrys");
            DynamicObject cashFlowEntry = (DynamicObject)entrys.get(0);
            BigDecimal referexrate = this.calRefrate_forwRateAgree(cashFlowEntry, plInfo);
            plInfo.set("referexrate", (Object)referexrate);
            plInfo.set("floatplamt", (Object)this.calcFloatPlAmt_forwRateAgree(tradeBill, cashFlowEntry, referexrate, plInfo));
            PlInfoCalculateHelper.updatePlInfo_Local((DynamicObject)plInfo);
        }
    }

    public BigDecimal calcFloatPlAmt_forwRateAgree(DynamicObject bill, DynamicObject cashflowEntry, BigDecimal referexrate, DynamicObject plInfo) {
        BigDecimal contractrate = bill.getBigDecimal("contractrate");
        BigDecimal amount = bill.getBigDecimal("amount");
        int cfperioddays = cashflowEntry.getInt("cfperioddays");
        int basis = TradeBusinessHelper.getBasis_YearDay((int)0, (BasisEnum)BasisEnum.getEnum((String)bill.getString("basis")));
        String tradeDirect = bill.getString("tradedirect");
        BigDecimal periodDaysDivYrbasis = BigDecimal.valueOf(cfperioddays).divide(BigDecimal.valueOf(basis), 10, RoundingMode.HALF_UP);
        DynamicObject plCurrency = plInfo.getDynamicObject("plcurrency");
        int amtprecision = plCurrency.getInt("amtprecision");
        BigDecimal floatPlAmt = referexrate.subtract(contractrate).multiply(amount).divide(Constants.ONE_HUNDRED, amtprecision, RoundingMode.HALF_UP).multiply(periodDaysDivYrbasis);
        if ("advance".equals(bill.getString("payrule"))) {
            floatPlAmt = floatPlAmt.divide(referexrate.divide(Constants.ONE_HUNDRED).multiply(periodDaysDivYrbasis).add(BigDecimal.ONE), amtprecision, RoundingMode.HALF_UP);
        }
        if ("buy".equals(tradeDirect)) {
            return floatPlAmt;
        }
        return floatPlAmt.negate();
    }

    private BigDecimal calRefrate_forwRateAgree(DynamicObject cashFlowEntry, DynamicObject plInfo) {
        DynamicObject yields = plInfo.getDynamicObject("yieldcurve");
        Date cfratefixdate = cashFlowEntry.getDate("cfratefixdate");
        DynamicObject cfratefixindex = cashFlowEntry.getDynamicObject("cfratefixindex");
        String cfreferindexfreq = cfratefixindex.getString("term");
        Date updateDate = plInfo.getDate("updatedate");
        if (updateDate.before(cfratefixdate)) {
            if (yields != null && EmptyUtil.isNoEmpty((Object)yields.getPkValue())) {
                Date nextDateByPayfreq = PayFrequeEnum.getNextDateByPayfreq((Date)cfratefixdate, (PayFrequeEnum)PayFrequeEnum.getEnumByName((String)RateTermEnum.getName((String)cfreferindexfreq)));
                BigDecimal rate = MarketDataHelper.yieldCurve((long)((Long)yields.getPkValue()), (YieldTypeEnum)YieldTypeEnum.ref, (ReturnValTypeEnum)ReturnValTypeEnum.furrate, (Date)updateDate, (Date)cfratefixdate, (Date)nextDateByPayfreq);
                return rate == null ? BigDecimal.ZERO : rate;
            }
            return BigDecimal.ZERO;
        }
        return cashFlowEntry.getBigDecimal("cfuserate");
    }

    private void bizRestAmtChangeEvt(DynamicObject info) {
        DynamicObject standardCurrency;
        DynamicObject buyCurrency;
        DynamicObject tradeBill = info.getDynamicObject("tradebill");
        String fxQuote = tradeBill.getString("fxquote");
        BigDecimal bizRestAmt = info.getBigDecimal("bizrestamt");
        BigDecimal exRate = info.getBigDecimal("exrate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{fxQuote, exRate, buyCurrency = info.getDynamicObject("buycurrency"), standardCurrency = info.getDynamicObject("standardcurrency")})) {
            BigDecimal priceCurrencyAmt = standardCurrency.getString("number").equals(fxQuote.split("/")[0]) ? bizRestAmt.multiply(exRate) : bizRestAmt.divide(exRate, 6, 4);
            if (standardCurrency.getString("number").equals(buyCurrency.getString("number"))) {
                info.set("buyamount", (Object)bizRestAmt);
                info.set("sellamount", (Object)priceCurrencyAmt);
            } else {
                info.set("buyamount", (Object)priceCurrencyAmt);
                info.set("sellamount", (Object)bizRestAmt);
            }
        }
    }
}

