/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.business.opservice.pnl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PlRateStructDataUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PlRateStructDataUpgradeService.class);
    private String SELECT_RATE_SQL = "select p.fid pfid,p.ftradetypeid ftradetypeid from t_tbo_plinfo p,t_tm_trade t where p.ftradebillid = t.fid and p.ftradetypeid in (952722152971330560,941771935417643008,1062099683381586944)";
    String UPDATE_PLINFO = "update t_tbo_plinfo set fbillno=?, fmodifytime=fcreatetime where fid=?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle handle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            result.setEl("warning");
            try {
                result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5229\u7387\u7c7b\u3001\u7ed3\u6784\u6027\u5b58\u6b3e\u635f\u76ca\u4fe1\u606f\u6570\u636e\u5347\u7ea7\u3002", (String)"PlRateStructDataUpgradeService_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                String sql = "select count(1) as recordcount from t_bas_deployinfodetail left join t_bas_deployinfoentry on t_bas_deployinfoentry.fentryid = t_bas_deployinfodetail.fentryid where t_bas_deployinfodetail.ffilename ='kd_1.5.216_tbo_update.sql' and t_bas_deployinfoentry.fappid ='tbo'";
                int recordCount = (Integer)DB.query((DBRoute)DBRouteConst.META, (String)sql, rs -> {
                    if (rs.next()) {
                        return rs.getInt("recordcount");
                    }
                    return 0;
                });
                if (recordCount == 0) {
                    this.dataUpgrade();
                }
                result.setLog(ResManager.loadKDString((String)"\u7ed3\u675f\u6267\u884c\u5229\u7387\u7c7b\u3001\u7ed3\u6784\u6027\u5b58\u6b3e\u635f\u76ca\u4fe1\u606f\u6570\u636e\u5347\u7ea7\u3002", (String)"PlRateStructDataUpgradeService_1", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                StackTraceElement[] stackTrace;
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement stackTraceElement : stackTrace = e.getStackTrace()) {
                    String s = stackTraceElement.toString();
                    sb.append(s);
                    sb.append("\n");
                }
                if (EmptyUtil.isEmpty((CharSequence)sb)) {
                    result.setErrorInfo(e.getMessage());
                } else {
                    sb.append("message\uff1a").append(e.getMessage());
                    result.setErrorInfo(sb.toString());
                }
                result.setSuccess(false);
                logger.info(e.getMessage());
                logger.info(result.getErrorInfo());
                handle.markRollback();
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private void dataUpgrade() {
        DataSet dataSet = DB.queryDataSet((String)"PlRateStructDataUpgradeService_DataSet", (DBRoute)DBRouteConst.TC, (String)this.SELECT_RATE_SQL);
        ArrayList<Object[]> updatePlinfoParamList = new ArrayList<Object[]>(500);
        int rateNo = 0;
        int structNo = 0;
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long pfid = row.getLong("pfid");
            Long ftradetypeid = row.getLong("ftradetypeid");
            String billno = 1062099683381586944L == ftradetypeid ? "PnL_SD" + String.format("%08d", ++structNo) : "PnL_IR" + String.format("%08d", ++rateNo);
            Object[] updatePlinfoParams = new Object[]{billno, pfid};
            updatePlinfoParamList.add(updatePlinfoParams);
            if (updatePlinfoParamList.size() != 500) continue;
            this.exeSqlBatch(this.UPDATE_PLINFO, updatePlinfoParamList);
            updatePlinfoParamList.clear();
        }
        if (updatePlinfoParamList.size() > 0) {
            this.exeSqlBatch(this.UPDATE_PLINFO, updatePlinfoParamList);
        }
        this.closeDataSet(dataSet);
    }

    private void closeDataSet(DataSet dataSet) {
        if (dataSet != null) {
            dataSet.close();
        }
    }

    private void exeSqlBatch(String sql, List<Object[]> paramList) {
        DB.executeBatch((DBRoute)DBRouteConst.TC, (String)sql, paramList);
    }
}

