/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.business.validate.pnl;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.PlCalcMethodEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tbo.common.helper.FormControlNameHelper;

public class PlHistorySaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("tradetype");
        sic.add("forexquote");
        sic.add("plcurrency");
        sic.add("referexrate");
        sic.add("updatedate");
        sic.add("exrate_local");
        sic.add("localcurrency");
        sic.add("swaptype");
        sic.add("referpremium");
        sic.add("plcalcmethod");
        sic.add("buycurrency");
        sic.add("sellcurrency");
        sic.add("buy_local_exrate");
        sic.add("sell_local_exrate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject dataEntity = data.getDataEntity();
            if (QueryServiceHelper.exists((String)"tbo_plinfo_history", (QFilter[])new QFilter("id", "=", dataEntity.get("id")).and("updatedate", "=", dataEntity.get("updatedate")).and("provision", "=", (Object)"1").toArray())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8be5\u65e5\u671f\u5df2\u53d1\u751f\u635f\u76ca\u8ba1\u63d0\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3001\u4fee\u6539\u6216\u5220\u9664\u3002", (String)"PlHistorySaveValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject tradeType = data.getDataEntity().getDynamicObject("tradetype");
            String tradeTypeNumber = tradeType.getString("number");
            this.checkAmountMaxValue(data);
            if (ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber) || ProductTypeEnum.FOREXFORWARD.getValue().equals(tradeTypeNumber) || ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber) || ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber)) {
                this.validate_forex(data, tradeTypeNumber);
            }
            if (ProductTypeEnum.SWAP.getValue().equals(tradeTypeNumber)) {
                this.validate_swap(data);
            }
            if (!ProductTypeEnum.FORWRATEAGREE.getValue().equals(tradeTypeNumber)) continue;
            this.validate_forwrateagree(data);
        }
    }

    private void validate_swap(ExtendedDataEntity data) {
        DynamicObject localcurrency;
        DynamicObject dataEntity = data.getDataEntity();
        String swapType = dataEntity.getString("swaptype");
        DynamicObject plcurrency = dataEntity.getDynamicObject("plcurrency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plcurrency, localcurrency = dataEntity.getDynamicObject("localcurrency")})) {
            this.validateMustInput(data, "plcurrency", "localcurrency");
        }
        this.validateMustInput(data, "updatedate");
        if ("currency".equals(swapType)) {
            this.validateFormMustInput(data, "tbo_plinfo_h_swap_l", "forexquote", "referexrate");
        }
        if ("rate".equals(swapType) && plcurrency.getLong("id") != localcurrency.getLong("id")) {
            this.validateMustInput(data, "forexquote");
        }
    }

    private void validate_forex(ExtendedDataEntity data, String tradeTypeNumber) {
        if (!ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber)) {
            this.validateMustInput(data, "forexquote", "updatedate", "referexrate");
        }
        DynamicObject localCurrency = data.getDataEntity().getDynamicObject("localcurrency");
        DynamicObject plCurrency = data.getDataEntity().getDynamicObject("plcurrency");
        if (!(ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber) || EmptyUtil.isAnyoneEmpty((Object[])new Object[]{localCurrency, plCurrency}) || localCurrency.getPkValue().equals(plCurrency.getPkValue()))) {
            this.validateMustInput(data, "exrate_local");
        }
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber)) {
            this.validateMustInput(data, "plcalcmethod");
        }
        DynamicObject buyCurrency = data.getDataEntity().getDynamicObject("buycurrency");
        DynamicObject sellCurrency = data.getDataEntity().getDynamicObject("sellcurrency");
        DynamicObject tradeBill = data.getDataEntity().getDynamicObject("tradebill");
        if (!(ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber) || EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCurrency, sellCurrency, localCurrency}) || buyCurrency.getLong("id") == localCurrency.getLong("id") || sellCurrency.getLong("id") == localCurrency.getLong("id") || ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber) && PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(data.getDataEntity().get("plcalcmethod")) || !"deliverable".equals(tradeBill.getString("deliveryway")))) {
            this.validateMustInput(data, "buy_local_exrate", "sell_local_exrate");
        }
    }

    protected void checkAmountMaxValue(ExtendedDataEntity data) {
        DynamicObject bill = data.getDataEntity();
        for (IDataEntityProperty prop : bill.getDataEntityType().getProperties()) {
            if (!(prop instanceof AmountProp) || bill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0 && bill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT.negate()) >= 0) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"%s:\u8d85\u51fa\u91d1\u989d\u6700\u5927\u503c\u8303\u56f4 -9,999,999,999,999.9999 \u81f3 9,999,999,999,999.9999", (String)"PlHistorySaveValidator_1", (String)"tmc-tm-business", (Object[])new Object[]{prop.getDisplayName().getLocaleValue()}));
        }
    }

    private void validateMustInput(ExtendedDataEntity dataEntity, String ... columnKeys) {
        for (String columnKey : columnKeys) {
            if (!EmptyUtil.isEmpty((Object)dataEntity.getDataEntity().get(columnKey))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlHistorySaveValidator_2", (String)"tmc-tm-business", (Object[])new Object[]{((IDataEntityProperty)dataEntity.getDataEntity().getDataEntityType().getProperties().get((Object)columnKey)).getDisplayName().getLocaleValue()}));
        }
    }

    private void validateFormMustInput(ExtendedDataEntity dataEntity, String formId, String ... columnKeys) {
        FormControlNameHelper formControlNameHelper = new FormControlNameHelper(formId);
        Map formControlNameMap = formControlNameHelper.getFormControlNameMap();
        for (String columnKey : columnKeys) {
            if (!EmptyUtil.isEmpty((Object)dataEntity.getDataEntity().get(columnKey))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlHistorySaveValidator_2", (String)"tmc-tm-business", (Object[])new Object[]{formControlNameMap.getOrDefault(columnKey, ((IDataEntityProperty)dataEntity.getDataEntity().getDataEntityType().getProperties().get((Object)columnKey)).getDisplayName()).getLocaleValue()}));
        }
    }

    private void validate_forwrateagree(ExtendedDataEntity data) {
        DynamicObject localCurrency = (DynamicObject)data.getValue("localcurrency");
        DynamicObject plCurrency = (DynamicObject)data.getValue("plcurrency");
        if (localCurrency.getLong("id") != plCurrency.getLong("id")) {
            this.validateFormMustInput(data, "tbo_pl_h_forwrateag_l", "forexquote", "exrate_local");
        }
        this.validateFormMustInput(data, "tbo_pl_h_forwrateag_l", "referexrate");
    }
}

