/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.business.validate.pnl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;

public class PlInfoCalculateValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("tradetype");
        sic.add("tradebill");
        sic.add("forexquote");
        sic.add("plcurrency");
        sic.add("localcurrency");
        sic.add("billno");
        sic.add("bizrestamt");
        sic.add("tradebizdate");
        sic.add("updatedate");
        sic.add("swaptype");
        sic.add("tradebill");
        return sic;
    }

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject plCurrency;
            DynamicObject localCurrency;
            Date updateDate;
            DynamicObject dataEntity = data.getDataEntity();
            DynamicObject tradeBill = dataEntity.getDynamicObject("tradebill");
            DynamicObject tradeType = dataEntity.getDynamicObject("tradetype");
            String tradeTypeNumber = tradeType.getString("number");
            if (ProductTypeEnum.STRUCTDEPOSIT.getValue().equals(tradeTypeNumber)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u6784\u6027\u5b58\u6b3e\u4e0d\u9700\u8981\u8fdb\u884c\u6d6e\u52a8\u635f\u76ca\u66f4\u65b0\u3002", (String)"PlInfoCalculateValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if (!this.validateMustInput(data, "billno", "plcurrency", "localcurrency", "tradebill", "tradetype")) continue;
            Date bizDate = dataEntity.getDate("tradebizdate");
            if (this.getOption().containsVariable("updatedate")) {
                String updateStr = this.getOption().getVariableValue("updatedate");
                updateDate = DateUtils.stringToDate((String)updateStr, (String)"yyyy-MM-dd");
            } else {
                updateDate = DateUtils.getCurrentDate();
            }
            if (EmptyUtil.isEmpty((Object)updateDate)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u66f4\u65b0\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlInfoCalculateValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if (bizDate != null && updateDate.compareTo(bizDate) < 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u66f4\u65b0\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u4ea4\u6613\u65e5\u671f\u3002", (String)"PlInfoCalculateValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if (ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5916\u6c47\u5373\u671f\u65e0\u9700\u66f4\u65b0\u6d6e\u52a8\u635f\u76ca\u3002", (String)"PlInfoCalculateValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if (this.isForexSwap_spotType(data, tradeBill)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5916\u6c47\u6389\u671f\u8fd1\u7aef\uff08\u8fdc\u7aef\uff09\u4e3a\u5373\u671f\uff0c\u65e0\u9700\u66f4\u65b0\u6d6e\u52a8\u635f\u76ca\u3002", (String)"PlInfoCalculateValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if ("E".equals(tradeBill.get("billstatus"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u7684\u635f\u76ca\u5355\u4e0d\u53ef\u66f4\u65b0\u635f\u76ca\u3002", (String)"PlInfoCalculateValidator_5", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if (ProductTypeEnum.FOREXFORWARD.getValue().equals(tradeTypeNumber) || ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber) || ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber)) {
                Object bizRecordId = dataEntity.get("bizrecord");
                DynamicObject bizRecord = QueryServiceHelper.queryOne((String)"tm_bizrecord", (String)"restamt", (QFilter[])new QFilter("id", "=", bizRecordId).toArray());
                if (BigDecimal.ZERO.compareTo(bizRecord.getBigDecimal("restamt")) == 0 || dataEntity.getBigDecimal("bizrestamt").compareTo(BigDecimal.ZERO) == 0) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u672a\u4ea4\u5272\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u5904\u7406\u3002", (String)"PlInfoCalculateValidator_6", (String)"tmc-tm-business", (Object[])new Object[0]));
                    continue;
                }
                if (!this.isForexSwap_spotType(data, tradeBill)) {
                    this.validateMustInput(data, "forexquote");
                }
            }
            if (ProductTypeEnum.SWAP.getValue().equals(tradeTypeNumber)) {
                localCurrency = dataEntity.getDynamicObject("localcurrency");
                plCurrency = dataEntity.getDynamicObject("plcurrency");
                String swapType = dataEntity.getString("swaptype");
                DynamicObject tradebill = dataEntity.getDynamicObject("tradebill");
                if (tradebill != null) {
                    QFilter qFilter = new QFilter("id", "=", tradebill.getPkValue());
                    DynamicObject bill = QueryServiceHelper.queryOne((String)"tm_rateswap", (String)"billstatus,isbuysettle", (QFilter[])qFilter.toArray());
                    boolean isbuysettle = bill.getBoolean("isbuysettle");
                    String billstatus = bill.getString("billstatus");
                    if ("currency".equals(swapType) && TcBillStatusEnum.AUDIT.getValue().equals(billstatus) && isbuysettle) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u8fd8\u672a\u4ea4\u6613\u786e\u8ba4\uff0c\u65e0\u6cd5\u66f4\u65b0\u6d6e\u52a8\u635f\u76ca\u3002", (String)"PlInfoCalculateValidator_7", (String)"tmc-tm-business", (Object[])new Object[0]));
                        continue;
                    }
                }
                if (localCurrency != null && plCurrency != null && localCurrency.getLong("id") != plCurrency.getLong("id")) {
                    this.validateMustInput(data, "forexquote");
                }
            }
            if (!ProductTypeEnum.FORWRATEAGREE.getValue().equals(tradeTypeNumber)) continue;
            localCurrency = (DynamicObject)data.getValue("localcurrency");
            plCurrency = (DynamicObject)data.getValue("plcurrency");
            if (localCurrency == null || plCurrency == null || localCurrency.getLong("id") == plCurrency.getLong("id")) continue;
            this.validateMustInput(data, "forexquote");
        }
    }

    private boolean isForexSwap_spotType(ExtendedDataEntity data, DynamicObject tradeBill) {
        String swapType = tradeBill.getString("swaptype");
        String swapDir = data.getDataEntity().getString("swapdir");
        if (ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(swapType) && "isnear".equals(swapDir)) {
            return true;
        }
        return ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(swapType);
    }

    private boolean validateMustInput(ExtendedDataEntity dataEntity, String ... columnKeys) {
        for (String columnKey : columnKeys) {
            if (!EmptyUtil.isEmpty((Object)dataEntity.getDataEntity().get(columnKey))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlInfoCalculateValidator_8", (String)"tmc-tm-business", (Object[])new Object[]{((IDataEntityProperty)dataEntity.getDataEntity().getDataEntityType().getProperties().get((Object)columnKey)).getDisplayName().getLocaleValue()}));
            return false;
        }
        return true;
    }
}

