/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.business.validate.pnl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.PlCalcMethodEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tbo.common.helper.FormControlNameHelper;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;

public class PlInfoSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("org");
        sic.add("tradetype");
        sic.add("tradebill");
        sic.add("forexquote");
        sic.add("fxquote");
        sic.add("plcurrency");
        sic.add("plcurrency_s");
        sic.add("referexrate");
        sic.add("updatedate");
        sic.add("floatplamt");
        sic.add("exrate_local");
        sic.add("floatpllocalamt");
        sic.add("localcurrency");
        sic.add("fxquote_local");
        sic.add("srcbizbill");
        sic.add("bizrecord");
        sic.add("swapdir");
        sic.add("swaptype");
        sic.add("fxquotetype");
        sic.add("payfloatplamt");
        sic.add("recfloatplamt");
        sic.add("spotrate");
        sic.add("type");
        sic.add("floatplamt_in");
        sic.add("floatpllocalamt_in");
        sic.add("lastenterdate");
        sic.add("bizdate");
        sic.add("settledate");
        sic.add("biztype");
        sic.add("plamt");
        sic.add("pllocalamt");
        sic.add("bizbillid");
        sic.add("bizbillno");
        sic.add("bizop");
        sic.add("floatplamtcalcdate");
        sic.add("lastobsdate");
        sic.add("payyields");
        sic.add("recyields");
        sic.add("referpremium");
        sic.add("yieldcurve");
        sic.add("billno");
        sic.add("billstatus");
        sic.add("pllocalamt_sum");
        sic.add("forreferexrate");
        sic.add("forfloatplamt");
        sic.add("plcalcmethod");
        sic.add("issuedate");
        sic.add("buycurrency");
        sic.add("sellcurrency");
        sic.add("standardcurrency");
        sic.add("buyamount");
        sic.add("sellamount");
        sic.add("amount");
        sic.add("exrate");
        sic.add("buy_local_fq");
        sic.add("buy_local_exrate");
        sic.add("sell_local_fq");
        sic.add("sell_local_exrate");
        sic.add("bizrestamt");
        sic.add("voucher_pl");
        sic.add("bizbillamt");
        sic.add("bizbillvoucherpl");
        sic.add("forwrate");
        sic.add("currencyrate");
        sic.add("pricecurrencyrate");
        sic.add("volatility");
        sic.add("optiontype");
        sic.add("premiumcurrency");
        sic.add("premium");
        sic.add("tradebizdate");
        return sic;
    }

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject dataEntity = data.getDataEntity();
            DynamicObject tradeBill = dataEntity.getDynamicObject("tradebill");
            Date bizDate = dataEntity.getDate("tradebizdate");
            Date updateDate = dataEntity.getDate("updatedate");
            DynamicObject tradeType = dataEntity.getDynamicObject("tradetype");
            String tradeTypeNumber = tradeType.getString("number");
            if ("E".equals(tradeBill.get("billstatus"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u7684\u635f\u76ca\u5355\u4e0d\u53ef\u66f4\u65b0\u635f\u76ca\u3002", (String)"PlInfoCalculateValidator_5", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if (!ProductTypeEnum.STRUCTDEPOSIT.getValue().equals(tradeTypeNumber) && EmptyUtil.isEmpty((Object)updateDate)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u66f4\u65b0\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlInfoSaveValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if (!ProductTypeEnum.STRUCTDEPOSIT.getValue().equals(tradeTypeNumber) && bizDate != null && updateDate.compareTo(bizDate) < 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u66f4\u65b0\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u4ea4\u6613\u65e5\u671f\u3002", (String)"PlInfoSaveValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            if (QueryServiceHelper.exists((String)"tbo_plinfo_history", (QFilter[])new QFilter("plbill", "=", dataEntity.get("id")).and("updatedate", "=", dataEntity.get("updatedate")).and("provision", "=", (Object)"1").toArray())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8be5\u65e5\u671f\u5df2\u53d1\u751f\u635f\u76ca\u8ba1\u63d0\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3001\u4fee\u6539\u6216\u5220\u9664\u3002", (String)"PlInfoSaveValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            this.checkAmountMaxValue(data);
            this.validateMustInput(data, "billno");
            if (!ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber)) {
                this.validateMustInput(data, "plcurrency");
            }
            if (ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber) || ProductTypeEnum.FOREXFORWARD.getValue().equals(tradeTypeNumber) || ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber) || ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber)) {
                Object bizRecordId = dataEntity.get("bizrecord");
                DynamicObject bizRecord = QueryServiceHelper.queryOne((String)"tm_bizrecord", (String)"restamt", (QFilter[])new QFilter("id", "=", bizRecordId).toArray());
                if (bizRecord != null && (BigDecimal.ZERO.compareTo(bizRecord.getBigDecimal("restamt")) == 0 || dataEntity.getBigDecimal("bizrestamt").compareTo(BigDecimal.ZERO) == 0)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u672a\u4ea4\u5272\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u5904\u7406\u3002", (String)"PlInfoSaveValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
                    continue;
                }
                this.validate_forex(data, tradeTypeNumber, tradeBill);
            }
            if (ProductTypeEnum.SWAP.getValue().equals(tradeTypeNumber)) {
                this.validate_swap(data);
            }
            if (!ProductTypeEnum.FORWRATEAGREE.getValue().equals(tradeTypeNumber)) continue;
            this.validate_forwrateagree(data);
        }
    }

    private void validate_forex(ExtendedDataEntity data, String tradeTypeNumber, DynamicObject tradeBill) {
        if (!ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber) && !this.isForexSwap_spotType(data, tradeBill)) {
            this.validateMustInput(data, "forexquote", "updatedate", "fxquotetype", "referexrate");
        }
        DynamicObject localCurrency = data.getDataEntity().getDynamicObject("localcurrency");
        DynamicObject plCurrency = data.getDataEntity().getDynamicObject("plcurrency");
        if (!(ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber) || EmptyUtil.isAnyoneEmpty((Object[])new Object[]{localCurrency, plCurrency}) || localCurrency.getPkValue().equals(plCurrency.getPkValue()) || this.isForexSwap_spotType(data, tradeBill))) {
            this.validateMustInput(data, "fxquote_local", "exrate_local");
        }
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber)) {
            this.validateMustInput(data, "plcalcmethod");
        }
        DynamicObject buyCurrency = data.getDataEntity().getDynamicObject("buycurrency");
        DynamicObject sellCurrency = data.getDataEntity().getDynamicObject("sellcurrency");
        if (!(ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber) || this.isForexSwap_spotType(data, tradeBill) || EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCurrency, sellCurrency, localCurrency}) || buyCurrency.getLong("id") == localCurrency.getLong("id") || sellCurrency.getLong("id") == localCurrency.getLong("id") || ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber) && PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(data.getDataEntity().get("plcalcmethod")) || !"deliverable".equals(tradeBill.getString("deliveryway")))) {
            this.validateMustInput(data, "buy_local_fq", "buy_local_exrate", "sell_local_fq", "sell_local_exrate");
        }
    }

    private boolean isForexSwap_spotType(ExtendedDataEntity data, DynamicObject tradeBill) {
        String swapType = tradeBill.getString("swaptype");
        String swapDir = data.getDataEntity().getString("swapdir");
        if (ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(swapType) && "isnear".equals(swapDir)) {
            return true;
        }
        return ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(swapType);
    }

    protected void checkAmountMaxValue(ExtendedDataEntity data) {
        DynamicObject bill = data.getDataEntity();
        for (IDataEntityProperty prop : bill.getDataEntityType().getProperties()) {
            if (!(prop instanceof AmountProp) || bill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0 && bill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT.negate()) >= 0) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"%s:\u8d85\u51fa\u91d1\u989d\u6700\u5927\u503c\u8303\u56f4 -9,999,999,999,999.9999 \u81f3 9,999,999,999,999.9999", (String)"PlInfoSaveValidator_4", (String)"tmc-tm-business", (Object[])new Object[]{prop.getDisplayName().getLocaleValue()}));
        }
    }

    private void validateMustInput(ExtendedDataEntity dataEntity, String ... columnKeys) {
        for (String columnKey : columnKeys) {
            if (!EmptyUtil.isEmpty((Object)dataEntity.getDataEntity().get(columnKey))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlInfoSaveValidator_6", (String)"tmc-tm-business", (Object[])new Object[]{((IDataEntityProperty)dataEntity.getDataEntity().getDataEntityType().getProperties().get((Object)columnKey)).getDisplayName().getLocaleValue()}));
        }
    }

    private void validateFormMustInput(ExtendedDataEntity dataEntity, String formId, String ... columnKeys) {
        FormControlNameHelper formControlNameHelper = new FormControlNameHelper(formId);
        Map formControlNameMap = formControlNameHelper.getFormControlNameMap();
        for (String columnKey : columnKeys) {
            if (!EmptyUtil.isEmpty((Object)dataEntity.getDataEntity().get(columnKey))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlInfoSaveValidator_6", (String)"tmc-tm-business", (Object[])new Object[]{formControlNameMap.getOrDefault(columnKey, ((IDataEntityProperty)dataEntity.getDataEntity().getDataEntityType().getProperties().get((Object)columnKey)).getDisplayName()).getLocaleValue()}));
        }
    }

    private void validate_swap(ExtendedDataEntity data) {
        DynamicObject dataEntity = data.getDataEntity();
        String swapType = dataEntity.getString("swaptype");
        DynamicObject tradebill = dataEntity.getDynamicObject("tradebill");
        if (tradebill != null) {
            QFilter qFilter = new QFilter("id", "=", tradebill.getPkValue());
            DynamicObject bill = QueryServiceHelper.queryOne((String)"tm_rateswap", (String)"billstatus,isbuysettle", (QFilter[])qFilter.toArray());
            boolean isbuysettle = bill.getBoolean("isbuysettle");
            String billstatus = bill.getString("billstatus");
            if ("currency".equals(swapType) && TcBillStatusEnum.AUDIT.getValue().equals(billstatus) && isbuysettle) {
                return;
            }
        }
        DynamicObject plcurrency = dataEntity.getDynamicObject("plcurrency");
        DynamicObject localcurrency = dataEntity.getDynamicObject("localcurrency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{localcurrency})) {
            this.validateMustInput(data, "localcurrency");
        }
        this.validateMustInput(data, "updatedate");
        if ("currency".equals(swapType)) {
            this.validateFormMustInput(data, "tbo_plinfo_swap_l", "forexquote", "referexrate");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plcurrency, localcurrency}) && plcurrency.getLong("id") != localcurrency.getLong("id")) {
                this.validateFormMustInput(data, "tbo_plinfo_swap_l", "exrate_local");
            }
        }
        if ("rate".equals(swapType) && !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plcurrency, localcurrency}) && plcurrency.getLong("id") != localcurrency.getLong("id")) {
            this.validateFormMustInput(data, "tbo_plinfo_swap_l", "forexquote", "exrate_local");
        }
    }

    private void validate_forwrateagree(ExtendedDataEntity data) {
        DynamicObject localCurrency = (DynamicObject)data.getValue("localcurrency");
        DynamicObject plCurrency = (DynamicObject)data.getValue("plcurrency");
        if (localCurrency.getLong("id") != plCurrency.getLong("id")) {
            this.validateFormMustInput(data, "tbo_plinfo_forwrateag_l", "forexquote", "exrate_local");
        }
        this.validateFormMustInput(data, "tbo_plinfo_forwrateag_l", "updatedate", "referexrate");
    }
}

