/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.business;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BusCreditOccAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("protecttype");
        sic.add("entrydetail");
        sic.add("operate");
        sic.add("farend");
        sic.add("nearend");
        return sic;
    }

    public void process(DynamicObject[] entities) throws KDException {
        for (DynamicObject entity : entities) {
            DynamicObject credituse;
            QFilter qFilter;
            if (!"tm_businessbill".equals(entity.getDataEntityType().getName())) continue;
            String tradebill = entity.getString("tradebill.number");
            String product = entity.getDynamicObject("protecttype").getString("number");
            String entityName = ProductTypeEnum.getEnumByValue((String)product).getEntity();
            DynamicObject bill = TmcDataServiceHelper.loadSingle((String)entityName, (String)"id,billno,credituse,currency,nearend,farend,billstatus", (QFilter[])new QFilter[]{qFilter = new QFilter("billno", "=", (Object)tradebill)});
            if (!bill.getDataEntityType().getProperties().containsKey((Object)"credituse") || EmptyUtil.isEmpty((DynamicObject)(credituse = bill.getDynamicObject("credituse")))) continue;
            BigDecimal amt = entity.getBigDecimal("bizamt1");
            String operate = entity.getString("operate");
            if ("expiredey".equals(operate) || "bdelivery".equals(operate) || "flat".equals(operate) || "exercise".equals(operate) || "giveup".equals(operate)) {
                this.returnCreditLimit(entity, bill, amt);
                continue;
            }
            if ("flat_n".equals(operate) || "expiredey_n".equals(operate) || "bdelivery_n".equals(operate)) {
                if (!bill.getBoolean("nearend")) continue;
                this.returnCreditLimit(entity, bill, amt);
                continue;
            }
            if (!"expiredey_f".equals(operate) && !"flat_f".equals(operate) && !"bdelivery_f".equals(operate) || !bill.getBoolean("farend")) continue;
            this.returnCreditLimit(entity, bill, amt);
        }
    }

    private void returnCreditLimit(DynamicObject entity, DynamicObject bill, BigDecimal amt) {
        String status = bill.getString("billstatus");
        Long entityId = entity.getLong("id");
        if (TcBillStatusEnum.FINISH.getValue().equals(status)) {
            CreditLimitServiceHelper.returnCreditLimit((DynamicObject)entity, (DynamicObject)bill, (boolean)false, (BigDecimal)amt, (Long)entityId, (boolean)true);
        } else {
            CreditLimitServiceHelper.returnCreditLimit((DynamicObject)entity, (DynamicObject)bill, (boolean)false, (BigDecimal)amt, (Long)entityId, (boolean)false);
        }
    }
}

