/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.cashflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.opservice.cashflow.CashFlowBuildAndSaveService;
import kd.tmc.tm.business.service.builder.ICashFlowBuilder;
import kd.tmc.tm.business.service.builder.forex.ForexBuyCashFlowBuilder;
import kd.tmc.tm.business.service.builder.forex.ForexSellCashFlowBuilder;
import kd.tmc.tm.business.service.builder.option.ForexOptionsBuyCashFlowBuilder;
import kd.tmc.tm.business.service.builder.option.ForexOptionsSellCashFlowBuilder;
import kd.tmc.tm.business.service.builder.rate.ForwRateAgreeCashFlowBuiler;
import kd.tmc.tm.business.service.builder.structdeposit.StructDepositCashFlowBuilder;
import kd.tmc.tm.business.service.builder.swap.ForexSwapsBuyCashFlowBuilder;
import kd.tmc.tm.business.service.builder.swap.ForexSwapsSellCashFlowBuilder;

public class CashFlowRefreshService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(CashFlowBuildAndSaveService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("amount");
        sic.add("bizdate");
        sic.add("currency");
        sic.add("settledate");
        sic.add("dateadjustmethod");
        sic.add("adjustsettledate");
        sic.add("basis");
        sic.add("workcalendar");
        sic.add("pricerule");
        sic.add("market");
        sic.add("fxquote");
        sic.add("pair");
        sic.add("tradedirect");
        sic.add("deliveryway");
        sic.add("sellcurrency");
        sic.add("settlecurrency");
        sic.add("tradetype");
        sic.add("exchangerate");
        sic.add("hooktype");
        sic.add("structtype");
        sic.add("predictmark");
        sic.add("predictrate");
        sic.add("firstobsdate");
        sic.add("obstacle");
        sic.add("lastobsdate");
        sic.add("intdate");
        sic.add("hookmark");
        sic.add("markprice");
        sic.add("marktime");
        sic.add("markzone");
        sic.add("displayform");
        sic.add("zone");
        sic.add("pricex");
        sic.add("pricey");
        sic.add("bwsymbol");
        sic.add("rate");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObjectCollection colls = new DynamicObjectCollection();
        for (DynamicObject bill : dataEntities) {
            logger.info("------" + bill.getString("billno") + "------");
            if (this.isRateCfg_structDeposit(bill)) continue;
            List<DynamicObject> cashFlows = this.builderCashFlow(bill);
            colls.addAll(cashFlows);
        }
        if (colls.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])((DynamicObject[])colls.toArray((Object[])new DynamicObject[colls.size()])));
        }
    }

    private boolean isRateCfg_structDeposit(DynamicObject bill) {
        if (!"tm_structdeposit".equals(bill.getDynamicObjectType().getName())) {
            return false;
        }
        QFilter filter = new QFilter("billid", "=", bill.get("id"));
        Object[] cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)String.join((CharSequence)",", "billno", "entrys", "cfisratecfg"), (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])cashFlows)) {
            for (Object cashFlow : cashFlows) {
                if (!"2".equals(cashFlow.get("billno"))) continue;
                return ((DynamicObject)((DynamicObjectCollection)cashFlow.get("entrys")).get(0)).getBoolean("cfisratecfg");
            }
        }
        return false;
    }

    protected List<DynamicObject> builderCashFlow(DynamicObject tradeBill) {
        ICashFlowBuilder[] builders;
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (ICashFlowBuilder builder : builders = this.getCashFlowBuilder(tradeBill)) {
            ModelAgent model = new ModelAgent((Object)tradeBill);
            model.setParam(this.getOperationVariable());
            DynamicObject[] data = builder.refresh(model);
            if (data == null) continue;
            list.addAll(Arrays.asList(data));
        }
        return list;
    }

    protected ICashFlowBuilder[] getCashFlowBuilder(DynamicObject tradeBill) {
        String entityNumber;
        ICashFlowBuilder[] builders = null;
        switch (entityNumber = tradeBill.getDataEntityType().getName()) {
            case "tm_forex": 
            case "tm_forex_forward": {
                builders = new ICashFlowBuilder[]{new ForexBuyCashFlowBuilder(), new ForexSellCashFlowBuilder()};
                break;
            }
            case "tm_forex_swaps": {
                builders = new ICashFlowBuilder[]{new ForexSwapsBuyCashFlowBuilder(), new ForexSwapsSellCashFlowBuilder()};
                break;
            }
            case "tm_structdeposit": {
                builders = new ICashFlowBuilder[]{new StructDepositCashFlowBuilder()};
                break;
            }
            case "tm_forwrateagree": {
                builders = new ICashFlowBuilder[]{new ForwRateAgreeCashFlowBuiler()};
                break;
            }
            case "tm_forex_options": {
                builders = new ICashFlowBuilder[]{new ForexOptionsBuyCashFlowBuilder(), new ForexOptionsSellCashFlowBuilder()};
                break;
            }
            default: {
                builders = new ICashFlowBuilder[]{};
            }
        }
        return builders;
    }
}

