/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.combreqnote;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.tm.common.enums.CombReqNoteEnum;

public class CombReqNotePushTradeOpService
extends AbstractTmcBizOppService {
    Map<Long, List<String>> errorMap = new HashMap<Long, List<String>>();

    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("producttype");
        selectors.add("isalllgenbill");
        for (CombReqNoteEnum combReqNote : CombReqNoteEnum.values()) {
            selectors.add(combReqNote.getEntryName());
            selectors.add(combReqNote.getBillIdName());
            selectors.add(combReqNote.getGenbizbillField());
        }
        return selectors;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] combTradeReqs;
        for (DynamicObject combReq : dataEntities) {
            Long id = combReq.getLong("id");
            DynamicObjectCollection productTypes = combReq.getDynamicObjectCollection("producttype");
            for (DynamicObject productType : productTypes) {
                OperationResult res;
                Optional<DynamicObject> opt;
                DynamicObject product = productType.getDynamicObject("fbasedataid");
                String number = product.getString("number");
                CombReqNoteEnum combReqNote = CombReqNoteEnum.getByProductType((String)number);
                DynamicObjectCollection entryEntity = combReq.getDynamicObjectCollection(combReqNote.getEntryName());
                if (entryEntity.isEmpty() || !(opt = entryEntity.stream().filter(e -> !e.getBoolean(combReqNote.getGenbizbillField())).findFirst()).isPresent() || (res = TmcOperateServiceHelper.execOperateWithoutThrow((String)combReqNote.getPushType(), (String)"tm_combreqnote", (Object[])new Long[]{id}, (OperateOption)OperateOption.create())).isSuccess()) continue;
                List<String> errors = this.errorMap.get(id);
                if (errors == null) {
                    errors = new ArrayList<String>(5);
                    this.errorMap.put(id, errors);
                }
                errors.add(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8%s\u5931\u8d25:", (String)"CombReqNotePushTradeOpService_0", (String)"tmc-tm-business", (Object[])new Object[0]), ProductTypeEnum.getEnumById((String)product.getString("id")).getName()) + TmcOperateServiceHelper.decodeErrorMsg((OperationResult)res));
            }
        }
        ArrayList<DynamicObject> updateDOs = new ArrayList<DynamicObject>(dataEntities.length);
        List ids = Arrays.stream(dataEntities).map(v -> v.getPkValue()).collect(Collectors.toList());
        for (DynamicObject comReq : combTradeReqs = TmcDataServiceHelper.load((String)"tm_combreqnote", (String)"isalllgenbill,spotinfo.spisbizbill,forwardinfo.foisbizbill,swapsinfo.swisbizbill,optionsinfo.opisbizbill", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
            boolean isAllGenBizbill = true;
            boolean hasEntry = false;
            for (CombReqNoteEnum combReqNote : CombReqNoteEnum.values()) {
                DynamicObjectCollection entries = comReq.getDynamicObjectCollection(combReqNote.getEntryName());
                if (entries.isEmpty()) continue;
                hasEntry = true;
                if (entries.stream().allMatch(e -> e.getBoolean(combReqNote.getGenbizbillField()))) continue;
                isAllGenBizbill = false;
                break;
            }
            if (!hasEntry) continue;
            comReq.set("isalllgenbill", (Object)isAllGenBizbill);
            updateDOs.add(comReq);
        }
        if (!updateDOs.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateDOs.toArray(new DynamicObject[0]));
        }
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        for (Map.Entry<Long, List<String>> err : this.errorMap.entrySet()) {
            Long id = err.getKey();
            String val = String.join((CharSequence)",", (Iterable<? extends CharSequence>)err.getValue());
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setLevel(ErrorLevel.Info);
            errorInfo.setPkValue((Object)id);
            errorInfo.setMessage(val);
            e.addErrorInfo(errorInfo);
        }
    }
}

