/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.combtrade;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class CombTradeAuditOpService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("billno");
        sel.add("tradebill");
        sel.add("tradebillentity");
        sel.add("tradestatus");
        return sel;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap tradeId2EntityType = new HashMap(16);
        HashMap<String, HashSet<Long>> tradeId4AuditMap = new HashMap<String, HashSet<Long>>(16);
        for (DynamicObject combtradeBill : dataEntities) {
            boolean isFinish = true;
            DynamicObjectCollection entryentity = combtradeBill.getDynamicObjectCollection("entryentity");
            List tradeIds = entryentity.stream().map(v -> v.getLong("tradebill")).collect(Collectors.toList());
            entryentity.forEach(v -> {
                String entityType = v.getString("tradebillentity");
                Long billId = v.getLong("tradebill");
                tradeId2EntityType.put(billId, entityType);
            });
            DynamicObjectCollection tradeList = QueryServiceHelper.query((String)"tm_trade", (String)"id,protecttype, billstatus,composeaudit", (QFilter[])new QFilter[]{new QFilter("id", "in", tradeIds)});
            for (DynamicObject tradeDO : tradeList) {
                if (!TcBillStatusEnum.FINISH.getValue().equals(tradeDO.getString("billstatus"))) {
                    isFinish = false;
                }
                boolean composeaudit = tradeDO.getBoolean("composeaudit");
                String billstatus = tradeDO.getString("billstatus");
                if (!composeaudit || !TcBillStatusEnum.SUBMIT.getValue().equals(billstatus)) continue;
                long billId = tradeDO.getLong("id");
                String entityType = (String)tradeId2EntityType.get(tradeDO.getLong("id"));
                HashSet<Long> billIds4Audit = (HashSet<Long>)tradeId4AuditMap.get(entityType);
                if (billIds4Audit == null) {
                    billIds4Audit = new HashSet<Long>(5);
                    tradeId4AuditMap.put(entityType, billIds4Audit);
                }
                billIds4Audit.add(billId);
            }
            if (!isFinish) continue;
            combtradeBill.set("billstatus", (Object)TcBillStatusEnum.FINISH.getValue());
        }
        if (!tradeId4AuditMap.isEmpty()) {
            OperateOption opOption = OperateOption.create();
            opOption.setVariableValue("combtrade_audit", "true");
            for (Map.Entry entry : tradeId4AuditMap.entrySet()) {
                String entityNumber = (String)entry.getKey();
                Set ids = (Set)entry.getValue();
                TmcOperateServiceHelper.execOperate((String)"audit", (String)entityNumber, (Object[])ids.toArray(new Object[0]), (OperateOption)opOption);
            }
        }
    }
}

