/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.forex;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.CombReqNoteEnum;

public class ForexDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("source");
        selector.add("reqnoteno");
        return selector;
    }

    public void process(DynamicObject[] entities) throws KDException {
        for (DynamicObject entity : entities) {
            DynamicObject note;
            String entityName = entity.getDataEntityType().getName();
            if (!"tm_forex_forward".equals(entityName) && !"tm_forex".equals(entityName) && !"tm_forex_swaps".equals(entityName) && !"tm_forex_options".equals(entityName)) continue;
            long sourcebillid = entity.getLong("sourcebillid");
            String source = entity.getString("source");
            String reqnoteno = entity.getString("reqnoteno");
            if (EmptyUtil.isEmpty((Long)sourcebillid)) continue;
            QFilter qFilter = new QFilter("billno", "=", (Object)reqnoteno);
            String entryIdProp = this.getProductTypeMap(entityName) + ".id";
            qFilter.and(new QFilter(entryIdProp, "=", (Object)sourcebillid));
            CombReqNoteEnum combReqNote = CombReqNoteEnum.getByBillType((String)entityName);
            String selectProp = this.getSelectProp(entityName);
            boolean isCombreqnote = StringUtils.contains((CharSequence)source, (CharSequence)"combreqnote");
            if (isCombreqnote) {
                note = TmcDataServiceHelper.loadSingle((String)"tm_combreqnote", (String)(selectProp + String.format(",%s.%s", combReqNote.getEntryName(), combReqNote.getBillIdName()) + ",isalllgenbill"), (QFilter[])new QFilter[]{qFilter});
                note.set("isalllgenbill", (Object)false);
            } else {
                note = TmcDataServiceHelper.loadSingle((String)"tm_reqnote", (String)selectProp, (QFilter[])new QFilter[]{qFilter});
            }
            DynamicObjectCollection entry = note.getDynamicObjectCollection(this.getProductTypeMap(entityName));
            for (DynamicObject row : entry) {
                long id = row.getLong("id");
                if (id != sourcebillid) continue;
                row.set(this.getIsbizbill(entityName), (Object)false);
                if (isCombreqnote) {
                    row.set(combReqNote.getBillIdName(), null);
                }
                this.clearFar(entityName, entry, row);
                break;
            }
            SaveServiceHelper.update((DynamicObject)note);
        }
    }

    private void clearFar(String entityName, DynamicObjectCollection entry, DynamicObject row) {
        if ("tm_forex_swaps".equals(entityName)) {
            for (DynamicObject farrow : entry) {
                int seq = row.getInt("seq");
                int farseq = farrow.getInt("seq");
                if (farseq != seq + 1) continue;
                farrow.set(this.getIsbizbill(entityName), (Object)false);
                return;
            }
        }
    }

    private String getSelectProp(String entitType) {
        if ("tm_forex_forward".equals(entitType)) {
            return "forwardinfo.foisbizbill,forwardinfo.id,forwardinfo.transactionno";
        }
        if ("tm_forex".equals(entitType)) {
            return "spotinfo.spisbizbill,spotinfo.id,spotinfo.spottransactionno";
        }
        if ("tm_forex_swaps".equals(entitType)) {
            return "swapsinfo.swisbizbill,swapsinfo.id,swapsinfo.bizbillno,swapsinfo.seq";
        }
        if ("tm_forex_options".equals(entitType)) {
            Object[] propArr = new String[]{StringUtils.join((Object[])new String[]{"optionsinfo", ".", "opisbizbill"}), StringUtils.join((Object[])new String[]{"optionsinfo", ".", "id"}), StringUtils.join((Object[])new String[]{"optionsinfo", ".", "opbizbillno"})};
            return StringUtils.join((Object[])propArr, (String)",");
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"ForexDeleteService_0", (String)"tmc-tm-business", (Object[])new Object[0]));
    }

    private String getProductTypeMap(String entitType) {
        if ("tm_forex_forward".equals(entitType)) {
            return "forwardinfo";
        }
        if ("tm_forex".equals(entitType)) {
            return "spotinfo";
        }
        if ("tm_forex_swaps".equals(entitType)) {
            return "swapsinfo";
        }
        if ("tm_forex_options".equals(entitType)) {
            return "optionsinfo";
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"ForexDeleteService_0", (String)"tmc-tm-business", (Object[])new Object[0]));
    }

    private String getIsbizbill(String entitType) {
        if ("tm_forex_forward".equals(entitType)) {
            return "foisbizbill";
        }
        if ("tm_forex".equals(entitType)) {
            return "spisbizbill";
        }
        if ("tm_forex_swaps".equals(entitType)) {
            return "swisbizbill";
        }
        if ("tm_forex_options".equals(entitType)) {
            return "opisbizbill";
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"ForexDeleteService_0", (String)"tmc-tm-business", (Object[])new Object[0]));
    }
}

