/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.optioncom;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class OptionCombUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List select = super.getSelector();
        select.add("assettype");
        select.add("entrys.tradeno");
        return select;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> tradeIdList4Unaudit = new ArrayList<Long>(16);
        ArrayList<DynamicObject> tradeBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject bill : dataEntities) {
            DynamicObject[] tradeList;
            String assetType = bill.getString("assettype");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entrys");
            List tradeIdList = entrys.stream().map(s -> s.getDynamicObject("tradeno").getLong("id")).collect(Collectors.toList());
            for (DynamicObject tradeDO : tradeList = TmcDataServiceHelper.load((String)assetType.replace("_l", ""), (String)"id,billstatus,composeno,composeaudit,auditor,auditdate,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", tradeIdList)})) {
                boolean composeaudit = tradeDO.getBoolean("composeaudit");
                String billstatus = tradeDO.getString("billstatus");
                if (composeaudit && TcBillStatusEnum.AUDIT.getValue().equals(billstatus)) {
                    tradeIdList4Unaudit.add(tradeDO.getLong("id"));
                    continue;
                }
                tradeDO.set("composeno", null);
                tradeBills.add(tradeDO);
            }
        }
        if (!tradeBills.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])tradeBills.toArray(new DynamicObject[0]));
        }
        if (!tradeIdList4Unaudit.isEmpty()) {
            OperateOption opOption = OperateOption.create();
            opOption.setVariableValue("combtrade_unaudit", "true");
            TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"tm_forex_options", (Object[])tradeIdList4Unaudit.toArray(new Object[0]), (OperateOption)opOption);
        }
    }
}

