/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.requestnote;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.CombReqNoteEnum;
import kd.tmc.tm.common.helper.ReqLimitHelper;
import kd.tmc.tm.common.helper.ReqNoteHelper;

public class ReqNoteLimitReturnService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ReqNoteLimitReturnService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("spotinfo");
        selector.add(StringUtils.join((Object[])new String[]{"spotinfo", ".", "spotcurrencytypein"}));
        selector.add(StringUtils.join((Object[])new String[]{"spotinfo", ".", "spotcurrencytypeout"}));
        selector.add(StringUtils.join((Object[])new String[]{"spotinfo", ".", "spotamountin"}));
        selector.add(StringUtils.join((Object[])new String[]{"spotinfo", ".", "spotamountout"}));
        selector.add(StringUtils.join((Object[])new String[]{"spotinfo", ".", "spbizdate"}));
        selector.add("swapsinfo");
        selector.add(StringUtils.join((Object[])new String[]{"swapsinfo", ".", "currin"}));
        selector.add(StringUtils.join((Object[])new String[]{"swapsinfo", ".", "currout"}));
        selector.add(StringUtils.join((Object[])new String[]{"swapsinfo", ".", "amtin"}));
        selector.add(StringUtils.join((Object[])new String[]{"swapsinfo", ".", "amtout"}));
        selector.add(StringUtils.join((Object[])new String[]{"swapsinfo", ".", "swbizdate"}));
        selector.add("forwardinfo");
        selector.add(StringUtils.join((Object[])new String[]{"forwardinfo", ".", "currencytypein"}));
        selector.add(StringUtils.join((Object[])new String[]{"forwardinfo", ".", "currencytypeout"}));
        selector.add(StringUtils.join((Object[])new String[]{"forwardinfo", ".", "amountin"}));
        selector.add(StringUtils.join((Object[])new String[]{"forwardinfo", ".", "amountout"}));
        selector.add(StringUtils.join((Object[])new String[]{"forwardinfo", ".", "fobizdate"}));
        selector.add("optionsinfo");
        selector.add(StringUtils.join((Object[])new String[]{"optionsinfo", ".", "opcurrin"}));
        selector.add(StringUtils.join((Object[])new String[]{"optionsinfo", ".", "opcurrout"}));
        selector.add(StringUtils.join((Object[])new String[]{"optionsinfo", ".", "opamtin"}));
        selector.add(StringUtils.join((Object[])new String[]{"optionsinfo", ".", "opamtout"}));
        selector.add(StringUtils.join((Object[])new String[]{"optionsinfo", ".", "opbizdate"}));
        selector.add("producttype");
        selector.add("limtno");
        return selector;
    }

    public void process(DynamicObject[] entities) throws KDException {
        logger.info("start process limitocc :" + Thread.currentThread().getId());
        for (DynamicObject entity : entities) {
            this.returnLimit(entity);
        }
        logger.info("end process limitocc :" + Thread.currentThread().getId());
    }

    private void returnLimit(DynamicObject entity) {
        DynamicObject productType = entity.getDynamicObject("producttype");
        if (EmptyUtil.isEmpty((DynamicObject)productType)) {
            return;
        }
        String number = productType.getString("number");
        CombReqNoteEnum productTypeEnum = CombReqNoteEnum.getByProductType((String)number);
        String entryName = productTypeEnum.getEntryName();
        DynamicObjectCollection reqNoteEntries = entity.getDynamicObjectCollection(entryName);
        DynamicObject limit = entity.getDynamicObject("limtno");
        if (EmptyUtil.isEmpty((DynamicObject)limit)) {
            return;
        }
        long limitId = limit.getLong("id");
        DynamicObject limitDb = TmcDataServiceHelper.loadSingle((Object)limitId, (String)"tm_reqlimit");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{limitDb, reqNoteEntries})) {
            return;
        }
        HashMap reqnoteCurrencyMap = new HashMap();
        ReqNoteHelper.sumReqNoteCurrAndAmt((DynamicObjectCollection)reqNoteEntries, (CombReqNoteEnum)productTypeEnum, reqnoteCurrencyMap, null);
        ReqLimitHelper.returnLimitAmt((DynamicObject)entity, (DynamicObject)limitDb, reqnoteCurrencyMap);
    }
}

