/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.requestnote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.ReqNoteEnum;

public class ReqNotePushTradeService
extends AbstractTmcBizOppService {
    Map<Long, List<String>> errorMap = new HashMap<Long, List<String>>();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("producttype");
        selector.add("producttype.number");
        selector.add("producttype.name");
        return selector;
    }

    public void process(DynamicObject[] entities) throws KDException {
        for (DynamicObject entity : entities) {
            OperationResult res;
            String pushOperation;
            long id = entity.getLong("id");
            DynamicObject protectType = entity.getDynamicObject("producttype");
            if (protectType == null || !EmptyUtil.isNotEmpty((CharSequence)(pushOperation = this.getPushOperation(protectType.getString("number")))) || (res = TmcOperateServiceHelper.execOperateWithoutThrow((String)pushOperation, (String)"tm_reqnote", (Object[])new Long[]{id}, (OperateOption)OperateOption.create())).isSuccess()) continue;
            List<String> errors = this.errorMap.get(id);
            if (EmptyUtil.isEmpty(errors)) {
                errors = new ArrayList<String>(5);
                this.errorMap.put(id, errors);
            }
            errors.add(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8%s\u5931\u8d25:", (String)"ReqNotePushTradeService_0", (String)"tmc-tm-business", (Object[])new Object[0]), protectType.getString("name")) + TmcOperateServiceHelper.decodeErrorMsg((OperationResult)res));
        }
    }

    private String getPushOperation(String number) {
        if (ReqNoteEnum.FOREXSPOT.getNumber().equals(number)) {
            return "pushandsavespot";
        }
        if (ReqNoteEnum.FOREXFORWARD.getNumber().equals(number)) {
            return "pushandsavefwd";
        }
        if (ReqNoteEnum.FOREXSWAPS.getNumber().equals(number)) {
            return "pushandsaveswaps";
        }
        if (ReqNoteEnum.FOREXOPTION.getNumber().equals(number)) {
            return "pushandsaveoptions";
        }
        return "";
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        for (Map.Entry<Long, List<String>> err : this.errorMap.entrySet()) {
            Long id = err.getKey();
            String val = String.join((CharSequence)",", (Iterable<? extends CharSequence>)err.getValue());
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setLevel(ErrorLevel.Info);
            errorInfo.setPkValue((Object)id);
            errorInfo.setMessage(val);
            e.addErrorInfo(errorInfo);
        }
    }
}

