/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.schedule;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.ObsFrequeEnum;
import kd.tmc.tm.common.helper.StructDepositHelper;

public class StructDepositObserveService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(StructDepositObserveService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("hooktype");
        sic.add("structtype");
        sic.add("predictmark");
        sic.add("predictrate");
        sic.add("firstobsdate");
        sic.add("obstacle");
        sic.add("lastobsdate");
        sic.add("intdate");
        sic.add("hookmark");
        sic.add("markprice");
        sic.add("marktime");
        sic.add("markzone");
        sic.add("displayform");
        sic.add("zone");
        sic.add("pricex");
        sic.add("pricey");
        sic.add("bwsymbol");
        sic.add("rate");
        sic.add("basis");
        sic.add("amount");
        sic.add("workcalendar");
        sic.add("redeemtype");
        sic.add("redeemdate");
        sic.add("obsdate");
        sic.add("observe");
        sic.add("obsfreq");
        sic.add("pricemethod");
        sic.add("initialprice");
        sic.add("zoneobsdate");
        sic.add("daytype");
        sic.add("settledate");
        sic.add("obssystime");
        sic.add("isstopobs");
        sic.add("firstbreakdate");
        sic.add("isobsfinish");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bill : dataEntities) {
            String structType = bill.getString("structtype");
            boolean isRateCfg = this.isRateCfg(bill);
            boolean isStopObs = (Boolean)bill.get("isstopobs");
            Date firstObsDate = (Date)bill.get("firstobsdate");
            Date lastObsDate = (Date)bill.get("lastobsdate");
            Date obsDate = EmptyUtil.isEmpty((Object)lastObsDate) ? firstObsDate : lastObsDate;
            Date rateFixDate = this.getRateCfgDate(bill);
            if (EmptyUtil.isEmpty((Object)rateFixDate)) {
                rateFixDate = lastObsDate;
            }
            if (EmptyUtil.isEmpty((Object)rateFixDate)) {
                rateFixDate = firstObsDate;
            }
            if (!isRateCfg && "total".equals(structType) && !TcDateUtils.getCurrentDate().after(rateFixDate)) {
                boolean isObs = StructDepositHelper.isObsTotalPredictRate((ModelAgent)new ModelAgent((Object)bill));
                logger.info("isObs = " + isObs);
                if (isObs) {
                    BigDecimal M = bill.getBigDecimal("predictmark");
                    bill.set("predictmark", (Object)M.add(Constants.ONE));
                }
                BigDecimal rate = StructDepositHelper.callTotalPredictResult((ModelAgent)new ModelAgent((Object)bill));
                bill.set("predictrate", (Object)rate);
            } else if (!isRateCfg && "break".equals(structType) && !isStopObs && !TcDateUtils.getCurrentDate().after(obsDate)) {
                BigDecimal[] result = StructDepositHelper.callBreakPredictResult((ModelAgent)new ModelAgent((Object)bill), (boolean)false);
                bill.set("predictmark", (Object)result[0]);
                bill.set("predictrate", (Object)result[1]);
                BigDecimal predictMark = bill.getBigDecimal("predictmark");
                this.checkBreakZoneObstacle(bill, predictMark);
            }
            bill.set("zoneobsdate", (Object)TcDateUtils.getCurrentDate());
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }

    private boolean isRateCfg(DynamicObject bill) {
        QFilter filter = new QFilter("billid", "=", (Object)bill.getLong("id"));
        filter.and(new QFilter("entrys.cfisratecfg", "=", (Object)Boolean.TRUE));
        return TmcDataServiceHelper.exists((String)"tm_cashflow", (QFilter[])filter.toArray());
    }

    private Date getRateCfgDate(DynamicObject bill) {
        DynamicObject[] cashFlows;
        QFilter filter = new QFilter("billid", "=", (Object)bill.getLong("id"));
        for (DynamicObject cashFlow : cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfratefixdate", (QFilter[])filter.toArray())) {
            if (!"2".equals(cashFlow.getString("billno")) || !EmptyUtil.isNoEmpty((DynamicObjectCollection)cashFlow.getDynamicObjectCollection("entrys"))) continue;
            return ((DynamicObject)cashFlow.getDynamicObjectCollection("entrys").get(0)).getDate("cfratefixdate");
        }
        return null;
    }

    private void checkBreakZoneObstacle(DynamicObject bill, BigDecimal predictMark) {
        boolean isBreak = StructDepositHelper.isBreakRateObstacle((ModelAgent)new ModelAgent((Object)bill), (BigDecimal)predictMark);
        boolean isObsDate = this.checkIsObsDate(bill);
        logger.info("isBreak = " + isBreak + "; isObsDate" + isObsDate);
        if (isBreak && isObsDate) {
            bill.set("isstopobs", (Object)Boolean.TRUE);
            bill.set("firstbreakdate", (Object)TcDateUtils.getCurrentDate());
        }
    }

    private boolean checkIsObsDate(DynamicObject bill) {
        String obsFreq = bill.getString("obsfreq");
        if (ObsFrequeEnum.month.getValue().equals(obsFreq) || ObsFrequeEnum.season.getValue().equals(obsFreq) || ObsFrequeEnum.half_year.getValue().equals(obsFreq) || ObsFrequeEnum.year.getValue().equals(obsFreq)) {
            DynamicObjectCollection observes = bill.getDynamicObjectCollection("observe");
            for (DynamicObject observe : observes) {
                Date obsDate = TcDateUtils.truncateDate((Date)observe.getDate("obssystime"));
                if (!EmptyUtil.isNoEmpty((Object)obsDate) || obsDate.compareTo(TcDateUtils.getCurrentDate()) != 0) continue;
                observe.set("isobsfinish", (Object)Boolean.TRUE);
                return true;
            }
            return false;
        }
        return bill.getDate("firstobsdate").compareTo(TcDateUtils.getCurrentDate()) <= 0;
    }
}

