/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.SettleSettingEnum;
import kd.tmc.tm.common.enums.SettleSettingModuleEnum;
import kd.tmc.tm.common.enums.SettleSettingOpEnum;
import kd.tmc.tm.common.helper.CashFlowDAOHelper;
import kd.tmc.tm.common.helper.RateSwapHelper;

public class BuySettleService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("bizdate");
        sic.add("settledate");
        sic.add("settledelay");
        sic.add("bondissue.calendars");
        sic.add("isbuysettle");
        sic.add("paysettletype");
        sic.add("paybankacct");
        sic.add("paybank");
        sic.add("opppaybankacct");
        sic.add("opppaybank");
        sic.add("buysettledate");
        sic.add("buysettleamt");
        sic.add("recsettletype");
        sic.add("recbankacct");
        sic.add("recbank");
        sic.add("opprecbankacct");
        sic.add("opprecbank");
        sic.add("tradedirect");
        sic.add("plcurrency");
        sic.add("fxquote");
        sic.add("spotrate");
        sic.add("plamt");
        sic.add("basefq");
        sic.add("baseexrate");
        sic.add("baseplamt");
        sic.add("basecurrency");
        sic.add("billno");
        sic.add("protecttype");
        sic.add("reccurrency");
        sic.add("rateswaptype");
        sic.add("initpriextype");
        sic.add("bizdate");
        sic.add("amount");
        sic.add("currency");
        sic.add("recamount");
        sic.add("pricerule");
        sic.add("voucher_pl");
        sic.add("voucherpl");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void afterProcess(DynamicObject[] dataEntities) {
        block13: for (DynamicObject bill : dataEntities) {
            String entity;
            switch (entity = bill.getDataEntityType().getName()) {
                case "tm_rateswap": {
                    this.settleRateSwap(bill);
                    continue block13;
                }
                case "tm_bond_fix": 
                case "tm_bond_float": {
                    this.settleBond(bill);
                    continue block13;
                }
                case "tm_structdeposit": {
                    this.settleStructDeposit(bill);
                    continue block13;
                }
                case "tm_forex_options": {
                    this.settleForexOptions(bill);
                }
            }
        }
    }

    private void updateCashflow(QFilter[] qFilters, Date buySettleDate) {
        DynamicObject cashFlow = CashFlowDAOHelper.loadAscTopOne((String)"billno,cfpaydate,cfispay,cfishis", (QFilter[])qFilters);
        if (EmptyUtil.isNoEmpty((DynamicObject)cashFlow)) {
            cashFlow.set("cfpaydate", (Object)buySettleDate);
            cashFlow.set("cfispay", (Object)true);
            cashFlow.set("cfishis", (Object)true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cashFlow});
        }
    }

    private void settleRateSwap(DynamicObject bill) {
        SettleSettingEnum settleSetting = this.getSettleSetting(bill);
        switch (settleSetting) {
            case REC_PAY_BILL: {
                this.pushPayRecBill(bill);
                break;
            }
            case EXCHANGE_BILL: {
                this.pushExchangebill(bill);
                break;
            }
        }
    }

    private void pushExchangebill(DynamicObject bill) {
        Date buySettleDate = bill.getDate("buysettledate");
        OperationResult exchangebillResult = TmcOperateServiceHelper.execOperate((String)"genexchangebil", (String)bill.getDataEntityType().getName(), (Object[])new Long[]{bill.getLong("id")}, (OperateOption)OperateOption.create(), (boolean)true);
        if (exchangebillResult.isSuccess()) {
            bill.set("isbuysettle", (Object)Boolean.TRUE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            QFilter filter = new QFilter("billid", "=", bill.getPkValue());
            QFilter filter_buy = new QFilter("cfdirection", "=", (Object)"buy");
            this.updateCashflow(new QFilter[]{filter, filter_buy}, buySettleDate);
            QFilter filter_sell = new QFilter("cfdirection", "=", (Object)"sell");
            this.updateCashflow(new QFilter[]{filter, filter_sell}, buySettleDate);
            this.genPlInfo(bill);
        }
    }

    private void pushPayRecBill(DynamicObject bill) {
        Date buySettleDate = bill.getDate("buysettledate");
        OperationResult result_pay = TmcOperateServiceHelper.execOperate((String)"genpay", (String)bill.getDataEntityType().getName(), (Object[])new Long[]{bill.getLong("id")}, (OperateOption)OperateOption.create(), (boolean)true);
        OperationResult result_rec = TmcOperateServiceHelper.execOperate((String)"genrec", (String)bill.getDataEntityType().getName(), (Object[])new Long[]{bill.getLong("id")}, (OperateOption)OperateOption.create(), (boolean)true);
        if (result_pay.isSuccess() && result_rec.isSuccess()) {
            bill.set("isbuysettle", (Object)Boolean.TRUE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            QFilter filter = new QFilter("billid", "=", bill.getPkValue());
            QFilter filter_buy = new QFilter("cfdirection", "=", (Object)"buy");
            this.updateCashflow(new QFilter[]{filter, filter_buy}, buySettleDate);
            QFilter filter_sell = new QFilter("cfdirection", "=", (Object)"sell");
            this.updateCashflow(new QFilter[]{filter, filter_sell}, buySettleDate);
            this.genPlInfo(bill);
        }
    }

    private SettleSettingEnum getSettleSetting(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        QFilter qFilter = new QFilter("orgcol.fbasedataid", "=", (Object)org.getLong("id"));
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((String)"tm_settlement_setting", (String)"ratesetting.rate_module,ratesetting.rate_op,ratesetting.rate_setting", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            return SettleSettingEnum.REC_PAY_BILL;
        }
        DynamicObjectCollection rateSettings = dynamicObject.getDynamicObjectCollection("ratesetting");
        for (DynamicObject rateSetting : rateSettings) {
            String module = rateSetting.getString("rate_module");
            String op = rateSetting.getString("rate_op");
            String setting = rateSetting.getString("rate_setting");
            if (!SettleSettingModuleEnum.SWAP_CURRENCY.getValue().equals(module) || !SettleSettingOpEnum.BUY_SETTLE.getValue().equals(op)) continue;
            return SettleSettingEnum.getByValue((String)setting);
        }
        return SettleSettingEnum.REC_PAY_BILL;
    }

    private void genPlInfo(DynamicObject bill) {
        DynamicObject swapPlInfo = RateSwapHelper.createSwapPlInfo((DynamicObject)bill);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{swapPlInfo});
    }

    private void settleStructDeposit(DynamicObject bill) {
        Date buySettleDate = bill.getDate("buysettledate");
        OperationResult result = TmcOperateServiceHelper.execOperate((String)"genpay", (String)bill.getDataEntityType().getName(), (Object[])new Long[]{bill.getLong("id")}, (OperateOption)OperateOption.create(), (boolean)true);
        if (result.isSuccess()) {
            bill.set("isbuysettle", (Object)Boolean.TRUE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            QFilter filter = new QFilter("billid", "=", bill.getPkValue());
            this.updateCashflow(new QFilter[]{filter}, buySettleDate);
        }
    }

    private void settleBond(DynamicObject bill) {
        Date buySettleDate = bill.getDate("buysettledate");
        OperationResult result_bond = TmcOperateServiceHelper.execOperate((String)"genpay", (String)bill.getDataEntityType().getName(), (Object[])new Long[]{bill.getLong("id")}, (OperateOption)OperateOption.create(), (boolean)true);
        if (result_bond.isSuccess()) {
            int delay;
            Date bizdate = bill.getDate("bizdate");
            DynamicObject bondIssueF7 = bill.getDynamicObject("bondissue");
            if (EmptyUtil.isNoEmpty((DynamicObject)bondIssueF7)) {
                DynamicObjectCollection calendars = bondIssueF7.getDynamicObjectCollection("calendars");
                delay = TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)calendars, (Date)bizdate, (Date)buySettleDate);
            } else {
                delay = TradeBusinessHelper.callSettleDelayDay(null, (Date)bizdate, (Date)buySettleDate);
            }
            bill.set("settledate", (Object)buySettleDate);
            bill.set("settledelay", (Object)delay);
            bill.set("isbuysettle", (Object)Boolean.TRUE);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{bill});
            QFilter filter = new QFilter("billid", "=", bill.getPkValue());
            this.updateCashflow(new QFilter[]{filter}, buySettleDate);
        }
    }

    private void settleForexOptions(DynamicObject bill) {
        OperationResult result;
        String tradeDir = bill.getString("tradedirect");
        if (TradeDirectionEnum.buy.getValue().equals(tradeDir) && (result = TmcOperateServiceHelper.execOperate((String)"genpay", (String)bill.getDataEntityType().getName(), (Object[])new Long[]{bill.getLong("id")}, (OperateOption)OperateOption.create(), (boolean)true)).isSuccess()) {
            bill.set("isbuysettle", (Object)Boolean.TRUE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        }
        if (TradeDirectionEnum.sell.getValue().equals(tradeDir) && (result = TmcOperateServiceHelper.execOperate((String)"genrec", (String)bill.getDataEntityType().getName(), (Object[])new Long[]{bill.getLong("id")}, (OperateOption)OperateOption.create(), (boolean)true)).isSuccess()) {
            bill.set("isbuysettle", (Object)Boolean.TRUE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        }
    }
}

