/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.opservice.trade.cfg.TradeBillCfgHandlerWrapper;
import kd.tmc.tm.common.enums.BizBillTypeEnum;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.helper.PlHelper;

public class TradeBillCfgOpService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TradeBillCfgOpService.class);
    private TradeBillCfgHandlerWrapper handlerWrapper = new TradeBillCfgHandlerWrapper();

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("org");
        sic.add("bizdate");
        sic.add("protecttype");
        sic.add("settledate");
        sic.add("sellcurrency");
        sic.add("deliveryway");
        sic.add("settlecurrency");
        sic.add("pair");
        sic.add("pricerule.forexquote");
        sic.add("pricerule.yield");
        sic.add("isdaterange");
        sic.add("adjsettledate_start");
        sic.add("adjsettledate_end");
        sic.add("adjustsettledate");
        sic.add("fxquote");
        sic.add("tradedirect");
        sic.add("workcalendar");
        sic.add("settledelay");
        sic.add("spotrate");
        sic.add("amount");
        sic.add("currency");
        sic.add("forwrate");
        sic.add("bizrestamt");
        sic.add("forwrate");
        sic.add("adjustsettledate");
        sic.add("adjustsettledate_far");
        sic.add("farbizrestamt");
        sic.add("exchangerate");
        sic.add("deliveryway");
        sic.add("settlecurrency");
        sic.add("tradedirect");
        sic.add("tradetype");
        sic.add("tradetype");
        sic.add("premiumcurrency");
        sic.add("premium");
        sic.add("swaptype");
        sic.add("enddate");
        sic.add("reccurrency");
        sic.add("rateswaptype");
        sic.add("currency");
        sic.add("buysettledate");
        sic.add("plamt");
        sic.add("baseplamt");
        sic.add("plcurrency");
        sic.add("intdate");
        sic.add("basis");
        sic.add("zoneobsdate");
        sic.add("intdate");
        sic.add("ratetype");
        sic.add("firstfixedrate");
        sic.add("bizop");
        sic.add("recratetype");
        sic.add("recfirstfixedrate");
        sic.add("recbizop");
        sic.add("initpriextype");
        sic.add("adjustedenddate");
        sic.add("basecurrency");
        sic.add("market");
        sic.add("contractrate");
        sic.add("lifecycle");
        sic.add("lifecycle.seq");
        sic.add("swapdir_entry");
        sic.add("isdaterange_entry");
        sic.add("currency_entry");
        sic.add("amount_entry");
        sic.add("rate_entry");
        sic.add("startdate_entry");
        sic.add("enddate_entry");
        sic.add("adjdeliverydate_entry");
        sic.add("currency");
        sic.add("amount");
        sic.add("sellamount");
        sic.add("optiontype");
        sic.add("buyamount_far");
        sic.add("sellamount_far");
        sic.add("recamount");
        sic.add("payrule");
        sic.add("voucher_pl");
        sic.add("voucherpl");
        sic.add("buy_currency");
        sic.add("buy_amount");
        sic.add("sell_currency");
        sic.add("sell_amount");
        sic.add("far_buy_currency");
        sic.add("far_buy_amount");
        sic.add("far_sell_currency");
        sic.add("far_sell_amount");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.handlerWrapper.process(dataEntities);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        DynamicObject protectType = dataEntities[0].getDynamicObject("protecttype");
        String protectNumber = protectType.getString("number");
        if (!ProductTypeEnum.FOREXSPOT.getValue().equals(protectNumber)) {
            return;
        }
        for (DynamicObject tradeBill : dataEntities) {
            boolean forexSpotAutoDelivery;
            if (0 != tradeBill.getInt("settledelay") || !(forexSpotAutoDelivery = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"forexspotautodelivery"))) continue;
            DynamicObject bizBill = this.autoDelivery(tradeBill);
            boolean bizBillAutoSettle = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"bizbillautosettle");
            if (!bizBillAutoSettle) continue;
            TmcOperateServiceHelper.execOperate((String)"settle", (String)"tm_businessbill", (DynamicObject[])new DynamicObject[]{bizBill}, (OperateOption)OperateOption.create());
        }
    }

    private DynamicObject autoDelivery(DynamicObject tradeBill) {
        String ConvertRuleId = "1010928675316958208";
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber("tm_forex");
        args.setTargetEntityNumber("tm_businessbill");
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(1);
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(tradeBill.getPkValue());
        selectedRows.add(row);
        args.setSelectedRows(selectedRows);
        args.setRuleId(ConvertRuleId);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        if (result.isSuccess()) {
            DynamicObject sellCurrency;
            DynamicObject buyCurrency;
            logger.info("\u5916\u6c47\u5373\u671f\u3010{}\u3011\u63a8\u5230\u671f\u4ea4\u5272\u64cd\u4f5c\u5355\u6210\u529f", tradeBill.get("billno"));
            IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"tm_businessbill");
            List bizBills = result.loadTargetDataObjects(refDataProvider, mainType);
            DynamicObject bizBill = (DynamicObject)bizBills.get(0);
            bizBill.set("billtype_id", (Object)BizBillTypeEnum.c_expiredey.getId());
            bizBill.set("operate", (Object)BizOperateEnum.expiredey.getValue());
            bizBill.set("protecttype", tradeBill.get("protecttype"));
            QFilter filter = new QFilter("tradebillid", "=", (Object)tradeBill.getLong("id"));
            DynamicObject[] bizRecords = TmcDataServiceHelper.load((String)"tm_bizrecord", (String)"id,bizdate,enddate,exrate,restamt,currency,desc,createtime,srcbizbill", (QFilter[])new QFilter[]{filter}, (String)"createtime");
            DynamicObject oneRecord = bizRecords[0];
            bizBill.set("bizrecordid", oneRecord.get("id"));
            bizBill.set("restamt_src", oneRecord.get("restamt"));
            bizBill.set("exrate_src", oneRecord.get("exrate"));
            bizBill.set("date_src", oneRecord.get("bizdate"));
            bizBill.set("enddate_src", oneRecord.get("enddate"));
            bizBill.set("bizdate_src", tradeBill.get("bizdate"));
            BigDecimal restAmt = bizBill.getBigDecimal("restamt_src");
            BigDecimal exRate = bizBill.getBigDecimal("exrate_src");
            String pair = tradeBill.getString("pair");
            String fxQuote = tradeBill.getString("fxquote");
            BigDecimal bizAmt2 = !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, fxQuote}) && pair.equals(fxQuote) ? restAmt.multiply(exRate) : (EmptyUtil.isEmpty((BigDecimal)exRate) ? BigDecimal.ZERO : restAmt.divide(exRate, 10, 4));
            bizBill.set("bizamt1", (Object)restAmt);
            bizBill.set("bizamt2", (Object)bizAmt2);
            bizBill.set("restamt1", (Object)BigDecimal.ZERO);
            bizBill.set("restamt2", (Object)BigDecimal.ZERO);
            Date deliveryDate = tradeBill.getDate("settledate");
            bizBill.set("bizdate", (Object)deliveryDate);
            bizBill.set("deliverydate", (Object)deliveryDate);
            String dir = tradeBill.getString("tradedirect");
            if (TradeDirectionEnum.buy.getValue().equals(dir)) {
                buyCurrency = tradeBill.getDynamicObject("currency");
                sellCurrency = tradeBill.getDynamicObject("sellcurrency");
            } else {
                buyCurrency = tradeBill.getDynamicObject("sellcurrency");
                sellCurrency = tradeBill.getDynamicObject("currency");
            }
            bizBill.set("reccurrency", (Object)buyCurrency);
            bizBill.set("paycurrency", (Object)sellCurrency);
            bizBill.set("fq", (Object)tradeBill.getString("fxquote"));
            Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)tradeBill.getDynamicObject("org").getLong("id"));
            Long localCurrencyId = (Long)map.get("baseCurrencyID");
            if (EmptyUtil.isEmpty((Long)localCurrencyId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5f53\u524d\u4ea4\u6613\u4e3b\u4f53\u7684\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u3002", (String)"BizBillEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject localCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)localCurrencyId, (String)"bd_currency");
            bizBill.set("basecurrency", (Object)localCurrency);
            if (PlHelper.isShowVoucherPlPanel((DynamicObject)tradeBill, (Long)localCurrency.getLong("id"))) {
                if (tradeBill.getDynamicObject("pricerule") == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u6613%s\u672a\u8bbe\u7f6e\u5b9a\u4ef7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizBillEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[]{tradeBill.getString("number")}));
                }
                DynamicObject priceRule = QueryServiceHelper.queryOne((String)"md_pricerule", (String)"forexquote.id,forexquote.issuetime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradeBill.getDynamicObject("pricerule").getLong("id"))});
                bizBill.set("show_voucher_pl_panel", (Object)Boolean.TRUE);
                this.setVoucherPl_bizBill(tradeBill, priceRule, localCurrency, bizBill);
            }
            OperateOption saveOp = OperateOption.create();
            saveOp.setVariableValue("WF", "TRUE");
            TmcOperateServiceHelper.execOperate((String)"save", (String)"tm_businessbill", (DynamicObject[])new DynamicObject[]{bizBill}, (OperateOption)saveOp);
            OperateOption submitOp = OperateOption.create();
            submitOp.setVariableValue("WF", "TRUE");
            TmcOperateServiceHelper.execOperate((String)"submit", (String)"tm_businessbill", (DynamicObject[])new DynamicObject[]{bizBill}, (OperateOption)submitOp);
            OperateOption auditOp = OperateOption.create();
            auditOp.setVariableValue("WF", "TRUE");
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"tm_businessbill", (DynamicObject[])new DynamicObject[]{bizBill}, (OperateOption)auditOp);
            return bizBill;
        }
        if (EmptyUtil.isNoEmpty((String)result.getMessage())) {
            throw new KDBizException(result.getMessage());
        }
        if (EmptyUtil.isNoEmpty((Object)result.getBillReports())) {
            throw new KDBizException(((SourceBillReport)result.getBillReports().get(0)).toString());
        }
        throw new KDBizException(ResManager.loadKDString((String)"%s\u751f\u6210\u5230\u671f\u4ea4\u5272\u64cd\u4f5c\u5355\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"TradeBillCfgOpService_5", (String)"tmc-tm-business", (Object[])new Object[0]));
    }

    private void setVoucherPl_bizBill(DynamicObject tradeBill, DynamicObject priceRule, DynamicObject localCurrency, DynamicObject bizBill) {
        BigDecimal sellExAmt;
        BigDecimal sellExRate;
        BigDecimal buyExAmt;
        BigDecimal buyExRate;
        DynamicObject sellCurrency;
        DynamicObject buyCurrency;
        BigDecimal sellAmt;
        BigDecimal buyAmt;
        if ("buy".equals(tradeBill.getString("tradedirect"))) {
            buyAmt = bizBill.getBigDecimal("bizamt1");
            sellAmt = bizBill.getBigDecimal("bizamt2");
            buyCurrency = tradeBill.getDynamicObject("currency");
            sellCurrency = tradeBill.getDynamicObject("sellcurrency");
        } else {
            buyAmt = bizBill.getBigDecimal("bizamt2");
            sellAmt = bizBill.getBigDecimal("bizamt1");
            buyCurrency = tradeBill.getDynamicObject("sellcurrency");
            sellCurrency = tradeBill.getDynamicObject("currency");
        }
        int buyAmtPrecision = buyCurrency.getInt("amtprecision");
        buyAmt = buyAmt.setScale(buyAmtPrecision, 4);
        int sellAmtPrecision = sellCurrency.getInt("amtprecision");
        sellAmt = sellAmt.setScale(sellAmtPrecision, 4);
        String buyCurrencyNumber = buyCurrency.getString("number");
        String sellCurrencyNumber = sellCurrency.getString("number");
        Date bizDate = bizBill.getDate("bizdate");
        ForexQuoteInfo buyCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexquote.id"), (String)(buyCurrencyNumber + "/" + localCurrency.getString("number")), (Date)bizDate, null);
        String buyCurFxQuote = buyCurFqInfo.getFxquote();
        if (buyCurrencyNumber.equals(buyCurFxQuote.split("/")[0])) {
            buyExRate = buyCurFqInfo.getBuyPrice();
            buyExAmt = buyAmt.multiply(buyExRate);
        } else {
            buyExRate = buyCurFqInfo.getSellPrice();
            buyExAmt = buyAmt.divide(buyExRate, 10, 4);
        }
        ForexQuoteInfo sellCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexquote.id"), (String)(sellCurrencyNumber + "/" + localCurrency.getString("number")), (Date)bizDate, null);
        String sellCurFxQuote = sellCurFqInfo.getFxquote();
        if (sellCurrencyNumber.equals(sellCurFxQuote.split("/")[0])) {
            sellExRate = sellCurFqInfo.getBuyPrice();
            sellExAmt = sellAmt.multiply(sellExRate);
        } else {
            sellExRate = sellCurFqInfo.getSellPrice();
            sellExAmt = sellAmt.divide(sellExRate, 10, 4);
        }
        bizBill.set("buy_local_fq", (Object)buyCurFxQuote);
        bizBill.set("buy_local_exrate", (Object)buyExRate);
        bizBill.set("sell_local_fq", (Object)sellCurFxQuote);
        bizBill.set("sell_local_exrate", (Object)sellExRate);
        bizBill.set("voucher_pl", (Object)buyExAmt.subtract(sellExAmt));
    }
}

