/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.tm.common.enums.SwapTypeEnum;

public class TradeBillUnCfgOpService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("bizop");
        sic.add("recbizop");
        sic.add("rateswaptype");
        sic.add("isbuysettle");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bill : dataEntities) {
            QFilter filter = new QFilter("tradebill", "=", (Object)bill.getLong("id"));
            QFilter filter_id = new QFilter("tradebillid", "=", (Object)bill.getLong("id"));
            DeleteServiceHelper.delete((String)"tm_bizrecord", (QFilter[])new QFilter[]{filter_id});
            String protectTypeId = bill.getDynamicObject("protecttype").getString("id");
            if (ProductTypeEnum.SWAP.getId().equals(protectTypeId)) {
                bill.set("bizop", null);
                bill.set("recbizop", null);
                this.clearOrDeleteFloatPlInfo(bill, filter);
                continue;
            }
            DeleteServiceHelper.delete((String)"tbo_plinfo", (QFilter[])new QFilter[]{filter});
            DeleteServiceHelper.delete((String)"tbo_plinfo_history", (QFilter[])new QFilter[]{filter});
        }
    }

    private void clearOrDeleteFloatPlInfo(DynamicObject bill, QFilter filter) {
        String swapType = bill.getString("rateswaptype");
        boolean isbuysettle = bill.getBoolean("isbuysettle");
        String billStatus = bill.getString("billstatus");
        if (SwapTypeEnum.currency.getValue().equals(swapType) && TcBillStatusEnum.AUDIT.getValue().equals(billStatus) && isbuysettle) {
            DynamicObject plInfo = TmcDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"floatplamt,payfloatplamt,recfloatplamt,fxquote_local,exrate_local,floatpllocalamt,payyields,recyields,forexquote,yieldcurve,updatedate,referexrate,maxhistoryplinfo", (QFilter[])filter.toArray());
            if (plInfo != null) {
                plInfo.set("floatplamt", (Object)0);
                plInfo.set("payfloatplamt", (Object)0);
                plInfo.set("recfloatplamt", (Object)0);
                plInfo.set("fxquote_local", null);
                plInfo.set("exrate_local", null);
                plInfo.set("floatpllocalamt", (Object)0);
                plInfo.set("payyields", null);
                plInfo.set("recyields", null);
                plInfo.set("forexquote", null);
                plInfo.set("yieldcurve", null);
                plInfo.set("updatedate", null);
                plInfo.set("referexrate", null);
                plInfo.set("maxhistoryplinfo", null);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plInfo});
        } else {
            DeleteServiceHelper.delete((String)"tbo_plinfo", (QFilter[])new QFilter[]{filter});
        }
        DeleteServiceHelper.delete((String)"tbo_plinfo_history", (QFilter[])new QFilter[]{filter});
    }
}

