/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade.cfg;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.resource.TeBizResource;

public class ForexPlInfoCreator {
    public DynamicObject genPlInfo_Forex(String flag, DynamicObject tradeBill, DynamicObject bizRecord) {
        DynamicObject priceRule = tradeBill.getDynamicObject("pricerule");
        if (priceRule == null) {
            throw new KDBizException(TeBizResource.priceRuleNotSet((String)tradeBill.getString("billno")));
        }
        DynamicObject plInfo = TmcDataServiceHelper.newDynamicObject((String)"tbo_plinfo");
        plInfo.set("bizrestamt", bizRecord.get("restamt"));
        plInfo.set("tradebizdate", tradeBill.get("bizdate"));
        String protectTypeId = tradeBill.getDynamicObject("protecttype").getString("id");
        if ("forw".equals(flag)) {
            plInfo.set("adjustdeliverydate", tradeBill.get("adjustsettledate_far"));
        } else if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectTypeId) && tradeBill.getBoolean("isdaterange")) {
            plInfo.set("adjustdeliverydatestart", tradeBill.get("adjsettledate_start"));
            plInfo.set("adjustdeliverydateend", tradeBill.get("adjsettledate_end"));
        } else {
            plInfo.set("adjustdeliverydate", tradeBill.get("adjustsettledate"));
        }
        Long orgId = tradeBill.getDynamicObject("org").getLong("id");
        plInfo.set("createtime", (Object)new Date());
        plInfo.set("modifytime", (Object)new Date());
        plInfo.set("tradebill", (Object)tradeBill.getLong("id"));
        plInfo.set("org", (Object)orgId);
        String billNo = CodeRuleServiceHelper.getNumber((String)"tbo_plinfo", (DynamicObject)plInfo, (String)String.valueOf(orgId));
        if (EmptyUtil.isEmpty((String)billNo)) {
            throw new KDBizException(TeBizResource.plCodeRuleNotSet());
        }
        plInfo.set("billno", (Object)billNo);
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        this.validateBaseCurrency(localCurrencyId);
        DynamicObject localCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)localCurrencyId, (String)"bd_currency");
        plInfo.set("localcurrency", (Object)localCurrency);
        plInfo.set("plcurrency_s", tradeBill.get("sellcurrency"));
        if ((ProductTypeEnum.FOREXFORWARD.getId().equals(protectTypeId) || ProductTypeEnum.FOREXOPTION.getId().equals(protectTypeId)) && DeliveryWayEnum.non_deliverable.getValue().equals(tradeBill.getString("deliveryway"))) {
            plInfo.set("plcurrency", tradeBill.get("settlecurrency"));
        } else {
            plInfo.set("plcurrency", tradeBill.get("sellcurrency"));
        }
        plInfo.set("tradetype", (Object)tradeBill.getDynamicObject("protecttype"));
        plInfo.set("billstatus", (Object)TcBillStatusEnum.SAVE.getValue());
        if (!"forw".equals(flag)) {
            if ("buy".equals(tradeBill.getString("tradedirect"))) {
                plInfo.set("buycurrency", tradeBill.get("currency"));
                plInfo.set("sellcurrency", tradeBill.get("sellcurrency"));
                plInfo.set("buyamount", tradeBill.get("amount"));
                plInfo.set("sellamount", tradeBill.get("sellamount"));
            } else {
                plInfo.set("buycurrency", tradeBill.get("sellcurrency"));
                plInfo.set("sellcurrency", tradeBill.get("currency"));
                plInfo.set("buyamount", tradeBill.get("sellamount"));
                plInfo.set("sellamount", tradeBill.get("amount"));
            }
        } else if ("buy".equals(tradeBill.getString("tradedirect"))) {
            plInfo.set("buycurrency", tradeBill.get("sellcurrency"));
            plInfo.set("sellcurrency", tradeBill.get("currency"));
            plInfo.set("buyamount", tradeBill.get("sellamount_far"));
            plInfo.set("sellamount", tradeBill.get("buyamount_far"));
        } else {
            plInfo.set("buycurrency", tradeBill.get("currency"));
            plInfo.set("sellcurrency", tradeBill.get("sellcurrency"));
            plInfo.set("buyamount", tradeBill.get("buyamount_far"));
            plInfo.set("sellamount", tradeBill.get("sellamount_far"));
        }
        plInfo.set("standardcurrency", tradeBill.get("currency"));
        plInfo.set("amount", tradeBill.get("amount"));
        if (ProductTypeEnum.FOREXOPTION.getId().equals(protectTypeId)) {
            plInfo.set("exrate", tradeBill.get("exchangerate"));
            plInfo.set("optiontype", tradeBill.get("optiontype"));
            plInfo.set("premiumcurrency", tradeBill.get("premiumcurrency"));
            plInfo.set("premium", tradeBill.get("premium"));
        } else if ("forw".equals(flag)) {
            plInfo.set("exrate", tradeBill.get("forwrate"));
        } else {
            plInfo.set("exrate", tradeBill.get("spotrate"));
        }
        plInfo.set("updatedate", (Object)TcDateUtils.getCurrentDate());
        plInfo.set("forexquote", priceRule.get("forexquote"));
        return plInfo;
    }

    private void validateBaseCurrency(Long localCurrencyId) {
        if (EmptyUtil.isEmpty((Long)localCurrencyId)) {
            throw new KDBizException(TeBizResource.checkTradeCfgBaseCurrency());
        }
    }
}

