/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade.cfg;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.opservice.trade.cfg.AbsTradeBillCfgHandler;
import kd.tmc.tm.business.opservice.trade.cfg.ForexPlInfoCreator;
import kd.tmc.tm.common.enums.BizRecordDescEnum;
import kd.tmc.tm.common.helper.ForexHelper;

public class ForexSpotCfgHandler
extends AbsTradeBillCfgHandler {
    @Override
    public void process(DynamicObject[] dataEntities) {
        this.billDataEntities = Arrays.stream(dataEntities).filter(v -> ProductTypeEnum.FOREXSPOT.getId().equals(v.getDynamicObject("protecttype").getString("id"))).collect(Collectors.toList());
        for (DynamicObject bill : this.billDataEntities) {
            ForexHelper.setBuyAmtAndSellAmtInfo((DynamicObject)bill);
            this.cfg_forexSpot(bill, this.plInfos, this.bizRecords);
        }
        this.saveBills();
    }

    private void cfg_forexSpot(DynamicObject bill, List<DynamicObject> plInfos, List<DynamicObject> bizRecords) {
        Object[] cashflowCol;
        DynamicObject bizRecord = this.createBizRecord(bill);
        bizRecords.add(bizRecord);
        long bizRecordId = bizRecord.getLong("id");
        for (Object cashflow : cashflowCol = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cfbizrecordid", (QFilter[])new QFilter[]{new QFilter("billid", "=", bill.getPkValue())})) {
            cashflow.set("cfbizrecordid", (Object)bizRecordId);
        }
        if (EmptyUtil.isNoEmpty((Object[])cashflowCol)) {
            this.cashFlows.addAll(Arrays.asList(cashflowCol));
        }
        DynamicObject plInfo = this.genPlInfo_Forex("spot", bill, bizRecord);
        plInfo.set("bizrecord", (Object)bizRecordId);
        plInfos.add(plInfo);
    }

    private DynamicObject createBizRecord(DynamicObject bill) {
        DynamicObject bizRecord = TmcDataServiceHelper.newDynamicObject((String)"tm_bizrecord");
        long bizRecordId = DBServiceHelper.genGlobalLongId();
        bizRecord.set("id", (Object)bizRecordId);
        bizRecord.set("createtime", (Object)new Date());
        bizRecord.set("tradebillid", (Object)bill.getLong("id"));
        bizRecord.set("exrate", bill.get("spotrate"));
        bizRecord.set("restamt", bill.get("amount"));
        bizRecord.set("currency", bill.get("currency"));
        bizRecord.set("lv", (Object)0);
        bizRecord.set("seqno", (Object)0);
        bizRecord.set("desc", (Object)BizRecordDescEnum.ORIGINAL.getValue());
        bizRecord.set("bizdate", bill.get("settledate"));
        return bizRecord;
    }

    private DynamicObject genPlInfo_Forex(String flag, DynamicObject tradeBill, DynamicObject bizRecord) {
        return new ForexPlInfoCreator().genPlInfo_Forex(flag, tradeBill, bizRecord);
    }
}

