/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade.cfg;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.tm.business.opservice.trade.cfg.AbsTradeBillCfgHandler;
import kd.tmc.tm.business.opservice.trade.cfg.FwRatePlInfoCreator;
import kd.tmc.tm.common.enums.BizRecordDescEnum;
import kd.tmc.tm.common.helper.PlHelper;

public class FwRateAgreeCfgHandler
extends AbsTradeBillCfgHandler {
    @Override
    public void process(DynamicObject[] dataEntities) {
        this.billDataEntities = Arrays.stream(dataEntities).filter(v -> ProductTypeEnum.FORWRATEAGREE.getId().equals(v.getDynamicObject("protecttype").getString("id"))).collect(Collectors.toList());
        for (DynamicObject bill : this.billDataEntities) {
            this.cfg_forwRateAgree(bill, this.plInfos);
        }
        this.saveBills();
    }

    private void cfg_forwRateAgree(DynamicObject bill, List<DynamicObject> plInfos) {
        DynamicObject bizRecord = this.createBizRecord(bill);
        long bizRecordId = bizRecord.getLong("id");
        DynamicObject plInfo = this.genPlInfo_ForwRateAgree(bill, bizRecord);
        plInfo.set("bizrecord", (Object)bizRecordId);
        Map localPlResult = PlHelper.calcLocalInfo_PlInfo((DynamicObject)plInfo, (DynamicObject)bill, (BigDecimal)plInfo.getBigDecimal("floatplamt"));
        PlHelper.setValue((DynamicObject)plInfo, (Map)localPlResult);
        QFilter filterCashFlow = new QFilter("billid", "=", bill.getPkValue());
        DynamicObject cashFlow = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"cfbizrecordid,billno", (QFilter[])new QFilter[]{filterCashFlow});
        cashFlow.set("cfbizrecordid", bizRecord.getPkValue());
        this.cashFlows.add(cashFlow);
        this.bizRecords.add(bizRecord);
        plInfos.add(plInfo);
    }

    private DynamicObject createBizRecord(DynamicObject bill) {
        DynamicObject bizRecord = TmcDataServiceHelper.newDynamicObject((String)"tm_bizrecord");
        long bizRecordId = DBServiceHelper.genGlobalLongId();
        bizRecord.set("id", (Object)bizRecordId);
        bizRecord.set("createtime", (Object)new Date());
        bizRecord.set("tradebillid", (Object)bill.getLong("id"));
        bizRecord.set("exrate", bill.get("contractrate"));
        bizRecord.set("restamt", bill.get("amount"));
        bizRecord.set("currency", bill.get("currency"));
        bizRecord.set("bizdate", (Object)bill.getDate("adjustsettledate"));
        bizRecord.set("lv", (Object)0);
        bizRecord.set("seqno", (Object)0);
        bizRecord.set("desc", (Object)BizRecordDescEnum.ORIGINAL.getValue());
        return bizRecord;
    }

    private DynamicObject genPlInfo_ForwRateAgree(DynamicObject bill, DynamicObject bizRecord) {
        return new FwRatePlInfoCreator().genPlInfo_ForwRateAgree(bill, bizRecord);
    }
}

