/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.bizbill.IBizBillAuditService;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.BizRecordDescEnum;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;
import kd.tmc.tm.common.helper.CombTradeBillWriteBackHelper;
import kd.tmc.tm.common.helper.PlHelper;
import kd.tmc.tm.common.helper.RateSwapHelper;

public abstract class AbstractBizBillAuditService
implements IBizBillAuditService {
    protected void checkUnAuditDownBizBill(String entityName, Long id, Map<String, Object> result) {
        QFilter filter = new QFilter("tradebill", "=", (Object)id);
        QFilter filter_status = new QFilter("billstatus", "<", (Object)TcBillStatusEnum.AUDIT.getValue());
        if (TmcDataServiceHelper.exists((String)"tm_businessbill", (QFilter[])new QFilter[]{filter, filter_status})) {
            result.put("flag", Boolean.FALSE);
            result.put("tip", ResManager.loadKDString((String)"\u8be5\u4ea4\u6613\u5355\u5b58\u5728\u672a\u5ba1\u6838\u7684\u751f\u547d\u5468\u671f\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"IsExistUnAuditBizBillDown", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    protected void splitCashFlow(DynamicObject tradebill, DynamicObject bill, String dir, List<DynamicObject> updateCol, Set<Long> delCol, List<DynamicObject> writeBackCol, boolean isNeedReNo) {
        DynamicObject[] cashflowCol;
        Long bizRecordId = bill.getLong("bizrecordid");
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        QFilter filter_dir = new QFilter("cfdirection", "=", (Object)dir);
        for (DynamicObject cashflow : cashflowCol = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfbizrecordid,cfishis,cfpaydate,cfcurrency,cfpayamount,cfprincipal,no,cffixrate,cfuserate", (QFilter[])new QFilter[]{filter_cashflow, filter_dir})) {
            if (bizRecordId.equals(cashflow.getLong("cfbizrecordid"))) {
                if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("restamt1")) != 0) {
                    writeBackCol.add(cashflow);
                    updateCol.add(cashflow);
                    continue;
                }
                delCol.add(cashflow.getLong("id"));
                continue;
            }
            if (!isNeedReNo) continue;
            updateCol.add(cashflow);
        }
    }

    protected DynamicObject genBizRecord(DynamicObject bill, String bizOp) {
        Long bizRecordId = bill.getLong("bizrecordid");
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((Object)bizRecordId, (String)"tm_bizrecord");
        bizRecord.set("restamt", (Object)bill.getBigDecimal("restamt1"));
        DynamicObjectCollection entrys = bizRecord.getDynamicObjectCollection("entryentity");
        int seq = entrys.size() + 1;
        DynamicObject newEntry = entrys.addNew();
        newEntry.set("seq", (Object)seq);
        newEntry.set("bizbillid", (Object)bill.getLong("id"));
        newEntry.set("bizop", (Object)bizOp);
        newEntry.set("opdate", (Object)bill.getDate("bizdate"));
        newEntry.set("amount", (Object)bill.getBigDecimal("bizamt1"));
        return bizRecord;
    }

    protected DynamicObject genPlBizRecord(DynamicObject tradebill, DynamicObject bill, DynamicObject bizRecord) {
        DynamicObject plInfo = this.queryPlInfo(tradebill, bill);
        plInfo.set("bizrestamt", (Object)bill.getBigDecimal("restamt1"));
        PlHelper.calcPLBuySellAmount((DynamicObject)tradebill, (DynamicObject)plInfo);
        DynamicObject productType = bill.getDynamicObject("protecttype");
        String entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
        String op = bill.getString("operate");
        if (EmptyUtil.isNoEmpty((DynamicObject)plInfo)) {
            DynamicObjectCollection entrys = plInfo.getDynamicObjectCollection("entrys");
            int seq = entrys.size() + 1;
            DynamicObject newRecord = entrys.addNew();
            newRecord.set("seq", (Object)seq);
            newRecord.set("bizdate", (Object)bill.getDate("bizdate"));
            newRecord.set("settledate", (Object)bill.getDate("plsettledate"));
            newRecord.set("biztype", (Object)bill.getString("operate"));
            if (BizOperateEnum.expiredey.getValue().equals(op) && "tm_forex".equals(entityType)) {
                newRecord.set("bizbillplcurrency", tradebill.get("sellcurrency"));
            } else if ("tm_forex_swaps".equals(entityType) && (ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(tradebill.getString("swaptype")) && (BizOperateEnum.expiredey_n.getValue().equals(op) || BizOperateEnum.expiredey_f.getValue().equals(op)) || ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(tradebill.getString("swaptype")) && BizOperateEnum.expiredey_n.getValue().equals(op))) {
                newRecord.set("bizbillplcurrency", tradebill.get("sellcurrency"));
            } else {
                newRecord.set("bizbillplcurrency", bill.get("plcurrency"));
            }
            newRecord.set("plamt", (Object)bill.getBigDecimal("plamt"));
            DynamicObject baseCurrency = bill.getDynamicObject("basecurrency");
            DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
            if (baseCurrency != null && plCurrency != null && baseCurrency.getString("number").equals(plCurrency.getString("number"))) {
                newRecord.set("pllocalamt", (Object)bill.getBigDecimal("plamt"));
            } else {
                newRecord.set("pllocalamt", (Object)bill.getBigDecimal("baseplamt"));
            }
            newRecord.set("bizbillid", (Object)bill.getLong("id"));
            if ("tm_forex".equals(entityType) || "tm_forex_forward".equals(entityType) || "tm_forex_swaps".equals(entityType) || "tm_forex_options".equals(entityType)) {
                newRecord.set("bizbillamt", bill.get("bizamt1"));
                newRecord.set("bizbillvoucherpl", bill.get("voucher_pl"));
                plInfo.set("floatplamt", (Object)BigDecimal.ZERO);
                plInfo.set("floatpllocalamt", (Object)BigDecimal.ZERO);
                plInfo.set("voucher_pl", (Object)BigDecimal.ZERO);
                plInfo.set("act_floatplamt", (Object)BigDecimal.ZERO);
            }
            if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("restamt1")) == 0) {
                plInfo.set("floatplamt", (Object)BigDecimal.ZERO);
                plInfo.set("floatpllocalamt", (Object)BigDecimal.ZERO);
            }
            if ("tm_rateswap".equals(entityType)) {
                if (TcBillStatusEnum.FINISH.getValue().equals(tradebill.getString("billstatus"))) {
                    plInfo.set("floatplamt", (Object)BigDecimal.ZERO);
                    plInfo.set("floatpllocalamt", (Object)BigDecimal.ZERO);
                } else {
                    BigDecimal floatPlAmt = RateSwapHelper.calFloatPlAmt((DynamicObject)plInfo, (Long)tradebill.getLong("id"));
                    plInfo.set("floatplamt", (Object)floatPlAmt);
                    plInfo.set("floatpllocalamt", (Object)PlHelper.calFloatPlLocalAmt((DynamicObject)plInfo, (BigDecimal)floatPlAmt));
                }
                newRecord.set("bizbillvoucherpl", bill.get("voucher_pl"));
            }
            BigDecimal pllocalamt = entrys.stream().map(s -> s.getBigDecimal("pllocalamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            plInfo.set("pllocalamt_sum", (Object)pllocalamt);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plInfo});
        }
        return plInfo;
    }

    protected DynamicObject queryPlInfo(DynamicObject tradebill, DynamicObject bill) {
        Long bizRecordId = bill.getLong("bizrecordid");
        QFilter filter = new QFilter("tradebill", "=", (Object)tradebill.getLong("id"));
        QFilter filter_bizrecord = new QFilter("bizrecord", "=", (Object)bizRecordId);
        DynamicObject plInfo = TmcDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"entrys.seq,entrys.bizdate,entrys.settledate,entrys.biztype,entrys.plamt,entrys.pllocalamt,entrys.bizbillid,entrys.bizbillamt,entrys.bizbillvoucherpl,entrys.bizbillplcurrency,billno,tradebill,org,tradetype,type,localcurrency,plamt_sum,pllocalamt_sum,floatplamt,floatpllocalamt,forfloatplamt,forfloatpllocalamt,referexrate,forreferexrate,plcurrency,plcurrency_s,updatedate,forexquote,fxquotetype,fxquote_local,exrate_local,floatplamt,floatpllocalamt,act_floatplamt,buycurrency,sellcurrency,buyamount,sellamount,standardcurrency,optiontype,premiumcurrency,premium,buy_local_fq,buy_local_exrate,sell_local_fq,sell_local_exrate,voucher_pl,bizrestamt,exrate,forexswaptype", (QFilter[])new QFilter[]{filter, filter_bizrecord});
        return plInfo;
    }

    protected void dealTradeBill_Forex(DynamicObject tradebill, DynamicObject bill, String bizOp, DynamicObject bizRecord) {
        boolean isSwapOp = false;
        String operate = bill.getString("operate");
        if (operate.indexOf("_n") > 0 || operate.indexOf("_f") > 0) {
            isSwapOp = true;
        }
        if (isSwapOp) {
            QFilter filter = new QFilter("tradebillid", "=", (Object)tradebill.getLong("id"));
            DynamicObject[] bizRecords = TmcDataServiceHelper.load((String)"tm_bizrecord", (String)"restamt,swapdir", (QFilter[])new QFilter[]{filter});
            BigDecimal amtNear = BigDecimal.ZERO;
            BigDecimal amtFar = BigDecimal.ZERO;
            for (DynamicObject oneRecord : bizRecords) {
                if ("isnear".equals(oneRecord.getString("swapdir"))) {
                    amtNear = amtNear.add(oneRecord.getBigDecimal("restamt"));
                }
                if (!"isfar".equals(oneRecord.getString("swapdir"))) continue;
                amtFar = amtFar.add(oneRecord.getBigDecimal("restamt"));
            }
            if (amtNear.compareTo(BigDecimal.ZERO) == 0 && amtFar.compareTo(BigDecimal.ZERO) == 0) {
                tradebill.set("billstatus", (Object)TcBillStatusEnum.FINISH.getValue());
                CombTradeBillWriteBackHelper.finishWriteBack((DynamicObject[])new DynamicObject[]{tradebill});
            }
            tradebill.set("bizrestamt", (Object)amtNear);
            tradebill.set("farbizrestamt", (Object)amtFar);
        } else {
            QFilter filter = new QFilter("tradebillid", "=", (Object)tradebill.getLong("id"));
            DynamicObject[] bizRecords = TmcDataServiceHelper.load((String)"tm_bizrecord", (String)"restamt", (QFilter[])new QFilter[]{filter});
            BigDecimal amt = BigDecimal.ZERO;
            for (DynamicObject oneRecord : bizRecords) {
                amt = amt.add(oneRecord.getBigDecimal("restamt"));
            }
            if (amt.compareTo(BigDecimal.ZERO) == 0) {
                tradebill.set("billstatus", (Object)TcBillStatusEnum.FINISH.getValue());
            }
            tradebill.set("bizrestamt", (Object)amt);
        }
        tradebill.set("bizop", (Object)bizOp);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tradebill});
        if (tradebill.getString("billstatus").equals(TcBillStatusEnum.FINISH.getValue())) {
            CombTradeBillWriteBackHelper.finishWriteBack((DynamicObject[])new DynamicObject[]{tradebill});
        }
    }

    protected DynamicObject createCashFlow_Forex(DynamicObject tradeBill, String dir, DynamicObject currency, BigDecimal payAmount, Date paydate, BigDecimal fixRate, BigDecimal useRate, Boolean isHis, Long bizRecordId) {
        DynamicObject cashflow = TmcDataServiceHelper.newDynamicObject((String)"tm_cashflow");
        cashflow.set("id", (Object)DBServiceHelper.genGlobalLongId());
        cashflow.set("billnumber", (Object)tradeBill.getString("billno"));
        cashflow.set("org", (Object)tradeBill.getDynamicObject("org"));
        cashflow.set("billid", (Object)tradeBill.getLong("id"));
        String deliveryWay = tradeBill.getString("deliveryway");
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
            cashflow.set("cftype", (Object)CashFlowTypeEnum.pl.getValue());
        } else {
            cashflow.set("cftype", (Object)CashFlowTypeEnum.capital.getValue());
        }
        cashflow.set("cfdirection", (Object)dir);
        cashflow.set("cfcurrency", (Object)currency);
        cashflow.set("cfpayamount", (Object)payAmount);
        cashflow.set("cfpaydate", (Object)paydate);
        cashflow.set("cfishis", (Object)isHis);
        cashflow.set("cfbizrecordid", (Object)bizRecordId);
        DynamicObject resetRow = cashflow.getDynamicObjectCollection("entrys").addNew();
        resetRow.set("cffixrate", (Object)fixRate);
        resetRow.set("cfuserate", (Object)useRate);
        return cashflow;
    }

    protected void reSetCashFlowNo(List<DynamicObject> cashFlowCol) {
        cashFlowCol.sort((o1, o2) -> {
            int i = o1.getDate("cfpaydate").compareTo(o2.getDate("cfpaydate"));
            if (i == 0) {
                return o1.getBoolean("cfishis") ? -1 : 1;
            }
            return i;
        });
        for (int i = 0; i < cashFlowCol.size(); ++i) {
            cashFlowCol.get(i).set("billno", (Object)(i + 1));
            DynamicObjectCollection entrys = cashFlowCol.get(i).getDynamicObjectCollection("entrys");
            for (int j = 0; j < entrys.size(); ++j) {
                ((DynamicObject)entrys.get(j)).set("no", (Object)(i + 1 + "." + (j + 1)));
            }
        }
    }

    protected DynamicObject genNewPlInfo(DynamicObject tradebill, DynamicObject bill, DynamicObject srcPlInfo, DynamicObject bizRecord) {
        this.dealSelectedContractRestAmt(tradebill, bill);
        DynamicObject plInfo = TmcDataServiceHelper.newDynamicObject((String)"tbo_plinfo");
        String billNo = CodeRuleServiceHelper.getNumber((String)"tbo_plinfo", (DynamicObject)plInfo, null);
        if (EmptyUtil.isEmpty((String)billNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5df2\u6b63\u786e\u8bbe\u7f6e\u635f\u76ca\u5355\u636e\u7f16\u53f7\u89c4\u5219\u3002", (String)"TradeBillCfgOpService_6", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        plInfo.set("billno", (Object)billNo);
        PlHelper.copyPlInfo((DynamicObject)srcPlInfo, (DynamicObject)plInfo);
        plInfo.set("bizbillno", bill.get("billno"));
        plInfo.set("bizop", bill.get("operate"));
        plInfo.set("createtime", (Object)new Date());
        plInfo.set("modifytime", (Object)new Date());
        plInfo.set("srcbizbill", bill.getPkValue());
        plInfo.set("bizrecord", bizRecord.getPkValue());
        plInfo.set("amount", bill.get("bizamt1"));
        plInfo.set("exrate", bill.get("spotrate_dey"));
        plInfo.set("bizrestamt", bill.get("bizamt1"));
        plInfo.set("tradebizdate", bill.get("bizdate"));
        if (bill.getBoolean("isdaterange")) {
            plInfo.set("adjustdeliverydatestart", bill.get("deydate_start"));
            plInfo.set("adjustdeliverydateend", bill.get("deydate_end"));
        } else {
            plInfo.set("adjustdeliverydate", bill.get("deliverydate"));
        }
        PlHelper.calcPLBuySellAmount((DynamicObject)tradebill, (DynamicObject)plInfo);
        plInfo.set("forexquote", srcPlInfo.get("forexquote"));
        return plInfo;
    }

    private void dealSelectedContractRestAmt(DynamicObject tradebill, DynamicObject bill) {
        DynamicObject plInfo = TmcDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"exrate,bizrestamt,buycurrency,buyamount,sellcurrency,sellamount,standardcurrency", (QFilter[])new QFilter("tradebill", "=", (Object)tradebill.getLong("id")).and("bizrecord", "=", (Object)bill.getLong("bizrecordid")).toArray());
        BigDecimal bizRestAmt = bill.getBigDecimal("restamt1");
        plInfo.set("bizrestamt", (Object)bizRestAmt);
        PlHelper.calcPLBuySellAmount((DynamicObject)tradebill, (DynamicObject)plInfo);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{plInfo});
    }

    protected DynamicObject genSubBizRecord(DynamicObject tradebill, DynamicObject bill, DynamicObject bizRecord) {
        Long bizRecordId = bill.getLong("bizrecordid");
        int count = TmcDataServiceHelper.count((String)"tm_bizrecord", (QFilter[])new QFilter[]{new QFilter("pid", "=", (Object)bizRecordId)});
        DynamicObject subBizRecord = TmcDataServiceHelper.newDynamicObject((String)"tm_bizrecord");
        subBizRecord.set("id", (Object)DBServiceHelper.genGlobalLongId());
        subBizRecord.set("createtime", (Object)new Date());
        subBizRecord.set("pid", (Object)bizRecordId);
        subBizRecord.set("tradebillid", (Object)tradebill.getLong("id"));
        subBizRecord.set("srcbizbill", (Object)bill.getLong("id"));
        if (bill.getBoolean("isdaterange")) {
            subBizRecord.set("bizdate", (Object)bill.getDate("deydate_start"));
            subBizRecord.set("enddate", (Object)bill.getDate("deydate_end"));
        } else {
            subBizRecord.set("bizdate", (Object)bill.getDate("deliverydate"));
        }
        subBizRecord.set("exrate", (Object)bill.getBigDecimal("spotrate_dey"));
        subBizRecord.set("restamt", (Object)bill.getBigDecimal("bizamt1"));
        subBizRecord.set("currency", tradebill.get("currency"));
        subBizRecord.set("lv", (Object)(bizRecord.getInt("lv") + 1));
        subBizRecord.set("seqno", (Object)(count + 1));
        String desc = null;
        String op = bill.getString("operate");
        BizOperateEnum operateEnum = BizOperateEnum.valueOf((String)op);
        if (BizOperateEnum.defer == operateEnum || BizOperateEnum.defer_n == operateEnum || BizOperateEnum.defer_f == operateEnum) {
            desc = BizRecordDescEnum.DEFER.getValue();
        } else if (BizOperateEnum.maudate == operateEnum || BizOperateEnum.maudate_n == operateEnum || BizOperateEnum.maudate_f == operateEnum) {
            desc = BizRecordDescEnum.EARLY.getValue();
        }
        subBizRecord.set("desc", (Object)desc);
        return subBizRecord;
    }
}

