/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.bizbill.IBizBillSettleService;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.enums.SettleSettingEnum;
import kd.tmc.tm.common.enums.SettleSettingModuleEnum;
import kd.tmc.tm.common.enums.SettleSettingOpEnum;

public abstract class AbstractBizBillSettleService
implements IBizBillSettleService {
    private static Log logger = LogFactory.getLog(AbstractBizBillSettleService.class);

    protected void genExchangeBill(DynamicObject bizBill) {
        ConvertOperationResult result;
        List rules = ConvertMetaServiceHelper.loadRules((String)"tm_businessbill", (String)"cas_exchangebill");
        String ConvertRuleId = ((ConvertRuleElement)rules.get(0)).getId();
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber("tm_businessbill");
        args.setTargetEntityNumber("cas_exchangebill");
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(1);
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(bizBill.getPkValue());
        selectedRows.add(row);
        args.setSelectedRows(selectedRows);
        args.setRuleId(ConvertRuleId);
        args.addCustomParam("call_by_settle", "yes");
        try (TXHandle h = TX.requiresNew();){
            try {
                result = ConvertServiceHelper.pushAndSave((PushArgs)args);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        if (result.isSuccess()) {
            DynamicObjectCollection targetBillCol = TmcBotpHelper.queryTargetBills((String)"tm_businessbill", (Object)bizBill.getLong("id"), (String)"cas_exchangebill", (String)"billNo");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)targetBillCol)) {
                List billNoList = targetBillCol.stream().map(s -> s.getString("billNo")).collect(Collectors.toList());
                bizBill.set("exchangebillno", (Object)String.join((CharSequence)",", billNoList));
                logger.info("\u751f\u547d\u5468\u671f\u5355\u3010{}\u3011\u63a8\u5916\u5e01\u5151\u6362\u5355\u6210\u529f", bizBill.get("billno"));
            } else {
                logger.info("\u751f\u547d\u5468\u671f\u5355\u3010{}\u3011\u63a8\u5916\u5e01\u5151\u6362\u5355\u51fa\u73b0\u5f02\u5e38\uff0cpushAndSave\u6210\u529f\u4f46\u662f\u65e0\u6cd5\u4e0b\u67e5\u5230\u5916\u5e01\u5151\u6362\u5355", bizBill.get("billno"));
            }
        } else {
            if (EmptyUtil.isNoEmpty((String)result.getMessage())) {
                throw new KDBizException(result.getMessage());
            }
            if (EmptyUtil.isNoEmpty((Object)result.getBillReports())) {
                throw new KDBizException(((SourceBillReport)result.getBillReports().get(0)).toString());
            }
            throw new KDBizException(ResManager.loadKDString((String)"%s \u751f\u6210\u5916\u5e01\u5151\u6362\u5355\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"BusinessSettleService_1", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    protected void bDelivery(Map<Long, DynamicObject> settlementSettingCache, DynamicObject bill) {
        Optional<DynamicObject> settleSetOptional;
        DynamicObject settleSetBill = this.querySettlementSetting(settlementSettingCache, bill.getDynamicObject("org").getLong("id"));
        String settleSet = null;
        if (settleSetBill != null && (settleSetOptional = settleSetBill.getDynamicObjectCollection("forexsetting").stream().filter(o -> SettleSettingModuleEnum.BIZBILL.getValue().equals(o.get("forex_module")) && SettleSettingOpEnum.BE_DEY.getValue().equals(o.get("forex_op"))).findAny()).isPresent()) {
            settleSet = settleSetOptional.get().getString("forex_setting");
        }
        if (SettleSettingEnum.EXCHANGE_BILL.getValue().equals(settleSet)) {
            this.genExchangeBill(bill);
        } else {
            this.genPayBill(bill, null);
            this.genRecBill(bill, null);
        }
        String exRateCalMtd = bill.getString("exratecalmtd");
        if (ExRateCalMethodEnum.Rate.getValue().equals(exRateCalMtd)) {
            BigDecimal plAmt = bill.getBigDecimal("plamt");
            if (BigDecimal.ZERO.compareTo(plAmt) < 0) {
                this.genRecBill(bill, "forPl");
            }
            if (BigDecimal.ZERO.compareTo(plAmt) > 0) {
                this.genPayBill(bill, "forPl");
            }
        }
    }

    protected boolean isGenExchangeBill(Map<Long, DynamicObject> settlementSettingCache, DynamicObject bill) {
        Optional<DynamicObject> settleSetOptional;
        boolean isGenExchangeBill = false;
        DynamicObject settleSetBill = this.querySettlementSetting(settlementSettingCache, bill.getDynamicObject("org").getLong("id"));
        if (settleSetBill != null && (settleSetOptional = settleSetBill.getDynamicObjectCollection("forexsetting").stream().filter(o -> SettleSettingModuleEnum.BIZBILL.getValue().equals(o.get("forex_module")) && SettleSettingOpEnum.EXPIRE_DEY.getValue().equals(o.get("forex_op"))).findAny()).isPresent() && SettleSettingEnum.EXCHANGE_BILL.getValue().equals(settleSetOptional.get().getString("forex_setting"))) {
            isGenExchangeBill = true;
        }
        return isGenExchangeBill;
    }

    protected DynamicObject querySettlementSetting(Map<Long, DynamicObject> settlementSettingCache, long orgId) {
        if (settlementSettingCache.containsKey(orgId)) {
            return settlementSettingCache.get(orgId);
        }
        String sql = "select fid from t_tm_settlement_set_org where fbasedataid = ?";
        DataSet dataSet = DB.queryDataSet((String)"settlementSetting", (DBRoute)DBRouteConst.TC, (String)sql, (Object[])new Object[]{orgId});
        if (!dataSet.isEmpty()) {
            Long settingBillId = ((Row)dataSet.iterator().next()).getLong("fid");
            DynamicObject settleSetBill = BusinessDataServiceHelper.loadSingle((Object)settingBillId, (String)"tm_settlement_setting");
            if (settleSetBill.getBoolean("enable")) {
                settlementSettingCache.put(orgId, settleSetBill);
                return settleSetBill;
            }
            return null;
        }
        return null;
    }

    protected void genPayOrRecBill_bySettleAmount(DynamicObject bill) {
        if (bill.getBigDecimal("settleamount").compareTo(Constants.ZERO) < 0) {
            this.genPayBill(bill, null);
        }
        if (bill.getBigDecimal("settleamount").compareTo(Constants.ZERO) > 0) {
            this.genRecBill(bill, null);
        }
    }

    protected void genPayOrRecBill_byPl(DynamicObject bizBill) {
        if (bizBill.getBigDecimal("plamt").compareTo(BigDecimal.ZERO) > 0) {
            this.genRecBill(bizBill, null);
        }
        if (bizBill.getBigDecimal("plamt").compareTo(BigDecimal.ZERO) < 0) {
            this.genPayBill(bizBill, null);
        }
    }

    protected void genPayBill(DynamicObject bill, String variableValue) {
        DynamicObjectCollection targetBillCol;
        OperateOption op = OperateOption.create();
        op.setVariableValue("call_by_settle_op", null);
        if (variableValue != null) {
            op.setVariableValue("onemorebill", variableValue);
        }
        op.setVariableValue("call_by_settle", "yes");
        OperationResult result = TmcOperateServiceHelper.execOperate((String)"genpaybill", (String)"tm_businessbill", (Object[])new Long[]{bill.getLong("id")}, (OperateOption)op, (boolean)true);
        if (result.isSuccess() && EmptyUtil.isNoEmpty((DynamicObjectCollection)(targetBillCol = TmcBotpHelper.queryTargetBills((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_paybill", (String)"billNo")))) {
            List billNoList = targetBillCol.stream().map(s -> s.getString("billNo")).collect(Collectors.toList());
            bill.set("paybillno", (Object)String.join((CharSequence)",", billNoList));
        }
    }

    protected void genRecBill(DynamicObject bill, String variableValue) {
        DynamicObjectCollection targetBillCol;
        OperateOption op = OperateOption.create();
        op.setVariableValue("call_by_settle_op", null);
        if (variableValue != null) {
            op.setVariableValue("onemorebill", variableValue);
        }
        op.setVariableValue("call_by_settle", "yes");
        OperationResult result = TmcOperateServiceHelper.execOperate((String)"genrecbill", (String)"tm_businessbill", (Object[])new Long[]{bill.getLong("id")}, (OperateOption)op, (boolean)true);
        if (result.isSuccess() && EmptyUtil.isNoEmpty((DynamicObjectCollection)(targetBillCol = TmcBotpHelper.queryTargetBills((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_recbill", (String)"billNo")))) {
            List billNoList = targetBillCol.stream().map(s -> s.getString("billNo")).collect(Collectors.toList());
            bill.set("recbillno", (Object)String.join((CharSequence)",", billNoList));
        }
    }
}

