/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill;

import kd.tmc.tm.business.service.bizbill.AbstractBizBillAuditService;
import kd.tmc.tm.business.service.bizbill.DefaultBizFactory;
import kd.tmc.tm.business.service.bizbill.IBizBillAuditService;
import kd.tmc.tm.business.service.bizbill.forex.ForexFwdBizBillAuditService;
import kd.tmc.tm.business.service.bizbill.forex.ForexOptionsBizBillAuditService;
import kd.tmc.tm.business.service.bizbill.forex.ForexSpotBizBillAuditService;
import kd.tmc.tm.business.service.bizbill.forex.ForexSwapBizBillAuditService;
import kd.tmc.tm.business.service.bizbill.other.StructDepositBizBillAuditService;
import kd.tmc.tm.business.service.bizbill.rate.ForwRateAgreeBizBillAuditService;
import kd.tmc.tm.business.service.bizbill.rate.RateSwapBizBillAuditService;

public class BizBillAuditServiceFactory {
    public static IBizBillAuditService createTradeFactory(String entity) {
        AbstractBizBillAuditService object;
        switch (entity) {
            case "tm_forex": {
                object = new ForexSpotBizBillAuditService();
                break;
            }
            case "tm_forex_forward": {
                object = new ForexFwdBizBillAuditService();
                break;
            }
            case "tm_forex_options": {
                object = new ForexOptionsBizBillAuditService();
                break;
            }
            case "tm_forex_swaps": {
                object = new ForexSwapBizBillAuditService();
                break;
            }
            case "tm_forwrateagree": {
                object = new ForwRateAgreeBizBillAuditService();
                break;
            }
            case "tm_rateswap": {
                object = new RateSwapBizBillAuditService();
                break;
            }
            case "tm_structdeposit": {
                object = new StructDepositBizBillAuditService();
                break;
            }
            default: {
                object = new DefaultBizFactory();
            }
        }
        return object;
    }
}

