/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.SettleTagEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.ForexOptionsHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BizBillWriteBackPayHelper {
    public static final String[] BIZ_BILL_PROPS = new String[]{"protecttype", "operate", "cashflow_pay", "cashflow_rec", "tradebill", "plamt", "settleamount", "bizamt2", "bizamt1", "plcurrency", "settlecurrency", "paycurrency", "reccurrency", "billno", "billstatus", "exchangebillno", "recbillno", "paybillno", "tradebill.currency", "tradebill.sellcurrency", "tradebill.deliveryway", "tradebill.rateswaptype", "tradebill.tradedirect", "tradebill.tradetype"};

    public static List<Pair<String, String>> getAmtAndCurrencyColName(DynamicObject bizBill, String settleTag) {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>(1);
        DynamicObject productType = bizBill.getDynamicObject("protecttype");
        String entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
        String operate = bizBill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        String amtColumn = null;
        switch (bizOp) {
            case bdelivery: 
            case bdelivery_n: 
            case bdelivery_f: {
                if (!"tm_forex_forward".equals(entityType) && !"tm_forex_swaps".equals(entityType)) break;
                if (EmptyUtil.isEmpty((String)settleTag)) {
                    list.add(BizBillWriteBackPayHelper.getAmtAndCurrencyColNamePair(entityType, "plamt"));
                    list.add(BizBillWriteBackPayHelper.getAmtAndCurrencyColNamePair(entityType, BizBillWriteBackPayHelper.getAmtColForDey(bizBill)));
                    return list;
                }
                if (SettleTagEnum.PL.getValue().equals(settleTag)) {
                    amtColumn = "plamt";
                    break;
                }
                amtColumn = BizBillWriteBackPayHelper.getAmtColForDey(bizBill);
                break;
            }
            case expiredey: 
            case expiredey_f: 
            case expiredey_n: {
                if ("tm_forex".equals(entityType) || "tm_forex_swaps".equals(entityType)) {
                    amtColumn = BizBillWriteBackPayHelper.getAmtColForDey(bizBill);
                }
                if (!"tm_forex_forward".equals(entityType)) break;
                DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
                String deliveryWay = tradeBill.getString("deliveryway");
                if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                    amtColumn = BizBillWriteBackPayHelper.getAmtColForDey(bizBill);
                }
                if (!DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) break;
                amtColumn = "plamt";
                break;
            }
            case flat_n: 
            case flat_f: {
                if (!"tm_forex_swaps".equals(entityType)) break;
                amtColumn = "plamt";
                break;
            }
            case exercise: {
                if ("tm_forex_options".equals(entityType)) {
                    DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
                    String deliveryWay = tradeBill.getString("deliveryway");
                    amtColumn = DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) ? BizBillWriteBackPayHelper.getAmtColForDeyOption(bizBill) : "settleamount";
                }
                if (!"tm_ratebound".equals(entityType)) break;
                amtColumn = "settleamount";
                break;
            }
            case flat: {
                if ("tm_forex_options".equals(entityType)) {
                    amtColumn = "settleamount";
                }
                if ("tm_ratebound".equals(entityType)) {
                    amtColumn = "settleamount";
                }
                if (!"tm_forex".equals(entityType) && !"tm_forex_forward".equals(entityType)) break;
                amtColumn = "plamt";
                break;
            }
            case defer: 
            case maudate: 
            case defer_n: 
            case defer_f: 
            case maudate_n: 
            case maudate_f: {
                if (!"tm_forex_forward".equals(entityType) && !"tm_forex_swaps".equals(entityType)) break;
                amtColumn = "plamt";
                break;
            }
            case pay: {
                if (!"tm_structdeposit".equals(entityType)) break;
                amtColumn = "settleamount";
                break;
            }
            case interestpay: {
                if ("tm_rateswap".equals(entityType)) {
                    Long cashflow_rec;
                    Long cashflow_pay = bizBill.getLong("cashflow_pay");
                    if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{cashflow_pay, cashflow_rec = Long.valueOf(bizBill.getLong("cashflow_rec"))})) {
                        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
                        String rateswapType = tradeBill.getString("rateswaptype");
                        if (SwapTypeEnum.rate.getValue().equals(rateswapType)) {
                            amtColumn = "settleamount";
                        }
                        if (SwapTypeEnum.currency.getValue().equals(rateswapType)) {
                            amtColumn = "bizamt1";
                        }
                    } else {
                        amtColumn = "bizamt1";
                    }
                }
                if (!"tm_forwrateagree".equals(entityType)) break;
                amtColumn = "settleamount";
                break;
            }
            case capitalpay: {
                if (!"tm_rateswap".equals(entityType)) break;
                amtColumn = "bizamt1";
                break;
            }
        }
        list.add(BizBillWriteBackPayHelper.getAmtAndCurrencyColNamePair(entityType, amtColumn));
        return list;
    }

    private static Pair<String, String> getAmtAndCurrencyColNamePair(String entityType, String amtColumn) {
        if (amtColumn == null) {
            throw new KDBizException("Unknown entityType of bizBill:" + entityType);
        }
        if ("tm_rateswap".equals(entityType)) {
            return Pair.of((Object)amtColumn, (Object)"paycurrency");
        }
        String currencyColumn = "bizamt1".equals(amtColumn) ? "currency" : ("bizamt2".equals(amtColumn) ? "sellcurrency" : ("plamt".equals(amtColumn) ? "plcurrency" : "settlecurrency"));
        return Pair.of((Object)amtColumn, (Object)currencyColumn);
    }

    private static String getAmtColForDey(DynamicObject bizBill) {
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        String dir = tradeBill.getString("tradedirect");
        String op = bizBill.getString("operate");
        if (op.indexOf("_f") > 0) {
            if (TradeDirectionEnum.buy.getValue().equals(dir)) {
                return "bizamt1";
            }
            return "bizamt2";
        }
        if (TradeDirectionEnum.buy.getValue().equals(dir)) {
            return "bizamt2";
        }
        return "bizamt1";
    }

    private static String getAmtColForDeyOption(DynamicObject bizBill) {
        String tradeType;
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        String dir = tradeBill.getString("tradedirect");
        if (ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)(tradeType = tradeBill.getString("tradetype")))) {
            return "bizamt2";
        }
        return "bizamt1";
    }
}

