/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill.forex;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.bizbill.AbstractBizBillAuditService;
import kd.tmc.tm.common.enums.BizBillTypeEnum;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.helper.CashFlowHelper;
import kd.tmc.tm.common.helper.ForexCashFlowHelper;

public class ForexFwdBizBillAuditService
extends AbstractBizBillAuditService {
    private String entityName = "tm_forex_forward";

    @Override
    public String getBizBillTypeId(String op) {
        String billTypeId;
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)op);
        switch (bizOp) {
            case expiredey: {
                billTypeId = BizBillTypeEnum.expiredey.getId();
                break;
            }
            case bdelivery: {
                billTypeId = BizBillTypeEnum.bdelivery.getId();
                break;
            }
            case flat: {
                billTypeId = BizBillTypeEnum.f_flat.getId();
                break;
            }
            case defer: {
                billTypeId = BizBillTypeEnum.defer.getId();
                break;
            }
            case maudate: {
                billTypeId = BizBillTypeEnum.maudate.getId();
                break;
            }
            default: {
                billTypeId = null;
            }
        }
        return billTypeId;
    }

    @Override
    public Map<String, Object> verifyBeforeDo(Long id, String op) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)id, (String)this.entityName, (String)"billstatus,deliveryway,source,iscfgrate");
        String billstatus = bill.getString("billstatus");
        String deliveryway = bill.getString("deliveryway");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)op);
        switch (bizOp) {
            case expiredey: 
            case flat: 
            case defer: 
            case maudate: {
                if (TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) break;
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
            case bdelivery: {
                if (TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus) && DeliveryWayEnum.deliverable.getValue().equals(deliveryway)) break;
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u672c\u91d1\u4ea4\u5272\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival_Deliverable", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
        }
        this.checkUnAuditDownBizBill(this.entityName, id, result);
        return result;
    }

    @Override
    public void auditBusinessBill(DynamicObject tradebill, DynamicObject bill) {
        String operate = bill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case expiredey: {
                this.expiredDey_ForexFwd(tradebill, bill);
                break;
            }
            case bdelivery: {
                this.beDey_forexFwd(tradebill, bill);
                break;
            }
            case flat: {
                this.flat_ForexFwd(tradebill, bill);
                break;
            }
            case defer: 
            case maudate: {
                this.deferOrMaudate_ForexFwd(tradebill, bill, bizOp);
            }
        }
    }

    protected void expiredDey_ForexFwd(DynamicObject tradebill, DynamicObject bill) {
        DynamicObject bizRecord = this.genBizRecord(bill, BizOperateEnum.expiredey.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> updateCol = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> insertCol = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            buyAmtDir = buyAmtDir.negate();
        }
        ArrayList<DynamicObject> buyCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "buy", buyCol, delCol, writeBackCol_buy, true);
        DynamicObject setttleCurrency = tradebill.getDynamicObject("settlecurrency");
        String deliveryWay = tradebill.getString("deliveryway");
        BigDecimal fixRate = bizRecord.getBigDecimal("exrate");
        if (!DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) || tradebill.getDynamicObject("sellcurrency").getLong("id") != setttleCurrency.getLong("id")) {
            BigDecimal amt_new;
            BigDecimal principal;
            BigDecimal payAmt;
            Date paydate = bill.getDate("deliverydate");
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                payAmt = bill.getBigDecimal("plamt");
                principal = bill.getBigDecimal("bizamt1");
                for (DynamicObject dynamicObject : writeBackCol_buy) {
                    amt_new = bill.getBigDecimal("restamt1");
                    ((DynamicObject)dynamicObject.getDynamicObjectCollection("entrys").get(0)).set("cfuserate", (Object)ForexCashFlowHelper.queryExRate((DynamicObject)tradebill, (Date)dynamicObject.getDate("cfpaydate")));
                    dynamicObject.set("cfprincipal", (Object)amt_new);
                    dynamicObject.set("cfpayamount", (Object)ForexCashFlowHelper.calcPayAmount_fwd((DynamicObject)tradebill, (BigDecimal)amt_new, (BigDecimal)((DynamicObject)dynamicObject.getDynamicObjectCollection("entrys").get(0)).getBigDecimal("cffixrate"), (BigDecimal)((DynamicObject)dynamicObject.getDynamicObjectCollection("entrys").get(0)).getBigDecimal("cfuserate")));
                }
            } else {
                payAmt = bill.getBigDecimal("bizamt1").multiply(buyAmtDir);
                principal = BigDecimal.ZERO;
                for (DynamicObject dynamicObject : writeBackCol_buy) {
                    amt_new = bill.getBigDecimal("restamt1").multiply(buyAmtDir);
                    dynamicObject.set("cfpayamount", (Object)amt_new);
                }
            }
            DynamicObject newCashflowBuy = this.createCashFlow_Forex(tradebill, "buy", DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) ? bill.getDynamicObject("plcurrency") : tradebill.getDynamicObject("currency"), payAmt, paydate, fixRate, bill.getBigDecimal("execexrate"), Boolean.TRUE, null);
            newCashflowBuy.set("cfprincipal", (Object)principal);
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                ((DynamicObject)newCashflowBuy.getDynamicObjectCollection("entrys").get(0)).set("cfratefixdate", bill.get("bizdate"));
            }
            insertCol.add(newCashflowBuy);
            buyCol.add(newCashflowBuy);
            this.reSetCashFlowNo(buyCol);
            buyCol.remove(newCashflowBuy);
            updateCol.addAll(buyCol);
        }
        ArrayList<DynamicObject> sellCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "sell", sellCol, delCol, writeBackCol_sell, true);
        if (!DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) || tradebill.getDynamicObject("currency").getLong("id") != setttleCurrency.getLong("id")) {
            BigDecimal principal;
            BigDecimal payAmt;
            Date paydate = bill.getDate("deliverydate");
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                payAmt = bill.getBigDecimal("plamt");
                principal = bill.getBigDecimal("bizamt1");
                for (DynamicObject cashflow : writeBackCol_sell) {
                    BigDecimal amt_new = bill.getBigDecimal("restamt1");
                    ((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).set("cfuserate", (Object)ForexCashFlowHelper.queryExRate((DynamicObject)tradebill, (Date)cashflow.getDate("cfpaydate")));
                    cashflow.set("cfprincipal", (Object)amt_new);
                    cashflow.set("cfpayamount", (Object)ForexCashFlowHelper.calcPayAmount_fwd((DynamicObject)tradebill, (BigDecimal)amt_new, (BigDecimal)((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).getBigDecimal("cffixrate"), (BigDecimal)((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).getBigDecimal("cfuserate")));
                }
            } else {
                payAmt = bill.getBigDecimal("bizamt2").multiply(buyAmtDir.negate());
                principal = BigDecimal.ZERO;
                for (DynamicObject cashflow : writeBackCol_sell) {
                    BigDecimal amt_new = bill.getBigDecimal("restamt2").multiply(buyAmtDir.negate());
                    cashflow.set("cfpayamount", (Object)amt_new);
                }
            }
            DynamicObject dynamicObject = this.createCashFlow_Forex(tradebill, "sell", DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) ? bill.getDynamicObject("plcurrency") : tradebill.getDynamicObject("sellcurrency"), payAmt, paydate, fixRate, bill.getBigDecimal("execexrate"), Boolean.TRUE, null);
            dynamicObject.set("cfprincipal", (Object)principal);
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                ((DynamicObject)dynamicObject.getDynamicObjectCollection("entrys").get(0)).set("cfratefixdate", bill.get("bizdate"));
            }
            insertCol.add(dynamicObject);
            sellCol.add(dynamicObject);
            this.reSetCashFlowNo(sellCol);
            sellCol.remove(dynamicObject);
            updateCol.addAll(sellCol);
        }
        if (insertCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertCol.toArray(new DynamicObject[0]));
        }
        if (updateCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        this.genPlBizRecord(tradebill, bill, bizRecord);
        this.dealTradeBill_Forex(tradebill, bill, BizOperateEnum.expiredey.getValue(), bizRecord);
    }

    protected void beDey_forexFwd(DynamicObject tradebill, DynamicObject bill) {
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> updateCol = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> insertCol = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            buyAmtDir = buyAmtDir.negate();
        }
        ArrayList<DynamicObject> buyCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "buy", buyCol, delCol, writeBackCol_buy, true);
        for (DynamicObject cashflow : writeBackCol_buy) {
            BigDecimal amt_new = bill.getBigDecimal("restamt1").multiply(buyAmtDir);
            cashflow.set("cfpayamount", (Object)amt_new);
        }
        Date paydate = bill.getDate("deliverydate");
        BigDecimal useRate = ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(bill.getString("exratecalmtd")) ? bill.getBigDecimal("execexrate") : bill.getBigDecimal("spotrate_dey");
        DynamicObject newCashflowBuy = this.createCashFlow_Forex(tradebill, "buy", tradebill.getDynamicObject("currency"), bill.getBigDecimal("bizamt1").multiply(buyAmtDir), paydate, bill.getBigDecimal("spotrate_dey"), useRate, Boolean.TRUE, null);
        insertCol.add(newCashflowBuy);
        buyCol.add(newCashflowBuy);
        this.reSetCashFlowNo(buyCol);
        buyCol.remove(newCashflowBuy);
        updateCol.addAll(buyCol);
        ArrayList<DynamicObject> sellCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "sell", sellCol, delCol, writeBackCol_sell, true);
        for (DynamicObject cashflow : writeBackCol_sell) {
            BigDecimal amt_new = bill.getBigDecimal("restamt2").multiply(buyAmtDir.negate());
            cashflow.set("cfpayamount", (Object)amt_new);
        }
        DynamicObject newCashflowSell = this.createCashFlow_Forex(tradebill, "sell", tradebill.getDynamicObject("sellcurrency"), bill.getBigDecimal("bizamt2").multiply(buyAmtDir.negate()), paydate, bill.getBigDecimal("spotrate_dey"), useRate, Boolean.TRUE, null);
        insertCol.add(newCashflowSell);
        sellCol.add(newCashflowSell);
        this.reSetCashFlowNo(sellCol);
        sellCol.remove(newCashflowSell);
        updateCol.addAll(sellCol);
        if (insertCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertCol.toArray(new DynamicObject[0]));
        }
        if (updateCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        DynamicObject bizRecord = this.genBizRecord(bill, BizOperateEnum.bdelivery.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        this.genPlBizRecord(tradebill, bill, bizRecord);
        this.dealTradeBill_Forex(tradebill, bill, BizOperateEnum.bdelivery.getValue(), bizRecord);
    }

    protected void flat_ForexFwd(DynamicObject tradebill, DynamicObject bill) {
        Object[] sellCashFlowCol;
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        ArrayList<DynamicObject> saveCol = new ArrayList<DynamicObject>(2);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            buyAmtDir = buyAmtDir.negate();
        }
        this.splitCashFlow(tradebill, bill, "buy", saveCol, delCol, writeBackCol_buy, false);
        this.splitCashFlow(tradebill, bill, "sell", saveCol, delCol, writeBackCol_sell, false);
        String deliveryWay = tradebill.getString("deliveryway");
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
            Iterator principal = bill.getBigDecimal("restamt1");
            for (DynamicObject cashflow : writeBackCol_buy) {
                ((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).set("cfuserate", (Object)ForexCashFlowHelper.queryExRate((DynamicObject)tradebill, (Date)cashflow.getDate("cfpaydate")));
                cashflow.set("cfprincipal", principal);
                cashflow.set("cfpayamount", (Object)ForexCashFlowHelper.calcPayAmount_fwd((DynamicObject)tradebill, principal, (BigDecimal)((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).getBigDecimal("cffixrate"), (BigDecimal)((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).getBigDecimal("cfuserate")));
            }
            for (DynamicObject cashflow : writeBackCol_sell) {
                ((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).set("cfuserate", (Object)ForexCashFlowHelper.queryExRate((DynamicObject)tradebill, (Date)cashflow.getDate("cfpaydate")));
                cashflow.set("cfprincipal", principal);
                cashflow.set("cfpayamount", (Object)ForexCashFlowHelper.calcPayAmount_fwd((DynamicObject)tradebill, principal, (BigDecimal)((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).getBigDecimal("cffixrate"), (BigDecimal)((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).getBigDecimal("cfuserate")));
            }
        } else {
            BigDecimal amt_new;
            for (DynamicObject cashflow : writeBackCol_buy) {
                amt_new = bill.getBigDecimal("restamt1").multiply(buyAmtDir);
                cashflow.set("cfpayamount", (Object)amt_new);
            }
            for (DynamicObject cashflow : writeBackCol_sell) {
                amt_new = bill.getBigDecimal("restamt2").multiply(buyAmtDir.negate());
                cashflow.set("cfpayamount", (Object)amt_new);
            }
        }
        if (saveCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        DynamicObject bizRecord = this.genBizRecord(bill, BizOperateEnum.flat.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        this.genPlBizRecord(tradebill, bill, bizRecord);
        this.dealTradeBill_Forex(tradebill, bill, BizOperateEnum.flat.getValue(), bizRecord);
        Object[] buyCashFlowCol = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfbizrecordid,cfishis,cfpaydate,cfcurrency,cfpayamount,cfprincipal,no,cffixrate,cfuserate", (QFilter[])new QFilter[]{filter_cashflow, new QFilter("cfdirection", "=", (Object)"buy")});
        if (EmptyUtil.isNoEmpty((Object[])buyCashFlowCol)) {
            List<DynamicObject> list = Arrays.stream(buyCashFlowCol).collect(Collectors.toList());
            this.reSetCashFlowNo(list);
            SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
        if (EmptyUtil.isNoEmpty((Object[])(sellCashFlowCol = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfbizrecordid,cfishis,cfpaydate,cfcurrency,cfpayamount,cfprincipal,no,cffixrate,cfuserate", (QFilter[])new QFilter[]{filter_cashflow, new QFilter("cfdirection", "=", (Object)"sell")})))) {
            List<DynamicObject> list = Arrays.stream(sellCashFlowCol).collect(Collectors.toList());
            this.reSetCashFlowNo(list);
            SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    protected void deferOrMaudate_ForexFwd(DynamicObject tradebill, DynamicObject bill, BizOperateEnum deferOrMaudate) {
        DynamicObject srcPlInfo;
        DynamicObject newCashflowSell;
        DynamicObject newCashflowBuy;
        DynamicObject bizRecord = this.genBizRecord(bill, deferOrMaudate.getValue());
        DynamicObject subBizRecord = this.genSubBizRecord(tradebill, bill, bizRecord);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord, subBizRecord});
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> updateCol = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> insertCol = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        String deliveryWay = tradebill.getString("deliveryway");
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            buyAmtDir = buyAmtDir.negate();
        }
        ArrayList<DynamicObject> buyCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "buy", buyCol, delCol, writeBackCol_buy, true);
        Date paydate = bill.getBoolean("isdaterange") ? bill.getDate("deydate_end") : bill.getDate("deliverydate");
        BigDecimal useRate = ForexCashFlowHelper.queryExRate((DynamicObject)tradebill, (Date)paydate);
        BigDecimal fixRate = bill.getBigDecimal("spotrate_dey");
        DynamicObject setttleCurrency = tradebill.getDynamicObject("settlecurrency");
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && tradebill.getDynamicObject("sellcurrency").getLong("id") == setttleCurrency.getLong("id")) {
            newCashflowBuy = null;
        } else {
            BigDecimal amt_new;
            BigDecimal principal;
            BigDecimal payAmt;
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                payAmt = bill.getBigDecimal("plamt").multiply(buyAmtDir);
                principal = bill.getBigDecimal("bizamt1");
                for (DynamicObject cashflow : writeBackCol_buy) {
                    amt_new = bill.getBigDecimal("restamt1");
                    ((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).set("cfuserate", (Object)ForexCashFlowHelper.queryExRate((DynamicObject)tradebill, (Date)cashflow.getDate("cfpaydate")));
                    cashflow.set("cfprincipal", (Object)amt_new);
                    cashflow.set("cfpayamount", (Object)ForexCashFlowHelper.calcPayAmount_fwd((DynamicObject)tradebill, (BigDecimal)amt_new, (BigDecimal)((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).getBigDecimal("cffixrate"), (BigDecimal)((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).getBigDecimal("cfuserate")));
                }
            } else {
                payAmt = bill.getBigDecimal("bizamt1").multiply(buyAmtDir);
                principal = BigDecimal.ZERO;
                for (DynamicObject cashflow : writeBackCol_buy) {
                    amt_new = bill.getBigDecimal("restamt1").multiply(buyAmtDir);
                    cashflow.set("cfpayamount", (Object)amt_new);
                }
            }
            newCashflowBuy = this.createCashFlow_Forex(tradebill, "buy", tradebill.getDynamicObject("currency"), payAmt, paydate, fixRate, useRate, Boolean.FALSE, subBizRecord.getLong("id"));
            newCashflowBuy.set("cfprincipal", (Object)principal);
            ((DynamicObject)newCashflowBuy.getDynamicObjectCollection("entrys").get(0)).set("cfratefixdate", (Object)this.calcRateFixDate(tradebill, paydate));
            if (DeliveryWayEnum.non_deliverable.getValue().equals(tradebill.getString("deliveryway"))) {
                newCashflowBuy.set("cfpayamount", (Object)ForexCashFlowHelper.calcPayAmount_fwd((DynamicObject)tradebill, (BigDecimal)principal, (BigDecimal)fixRate, (BigDecimal)useRate));
            }
            insertCol.add(newCashflowBuy);
            buyCol.add(newCashflowBuy);
            this.reSetCashFlowNo(buyCol);
            buyCol.remove(newCashflowBuy);
            updateCol.addAll(buyCol);
        }
        ArrayList<DynamicObject> sellCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "sell", sellCol, delCol, writeBackCol_sell, true);
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && tradebill.getDynamicObject("currency").getLong("id") == setttleCurrency.getLong("id")) {
            newCashflowSell = null;
        } else {
            BigDecimal principal;
            BigDecimal payAmt;
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                payAmt = bill.getBigDecimal("plamt").multiply(buyAmtDir.negate());
                principal = bill.getBigDecimal("bizamt1");
                for (DynamicObject cashflow : writeBackCol_sell) {
                    BigDecimal amt_new = bill.getBigDecimal("restamt1");
                    ((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).set("cfuserate", (Object)ForexCashFlowHelper.queryExRate((DynamicObject)tradebill, (Date)cashflow.getDate("cfpaydate")));
                    cashflow.set("cfprincipal", (Object)amt_new);
                    cashflow.set("cfpayamount", (Object)ForexCashFlowHelper.calcPayAmount_fwd((DynamicObject)tradebill, (BigDecimal)amt_new, (BigDecimal)((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).getBigDecimal("cffixrate"), (BigDecimal)((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).getBigDecimal("cfuserate")));
                }
            } else {
                payAmt = bill.getBigDecimal("bizamt2").multiply(buyAmtDir.negate());
                principal = BigDecimal.ZERO;
                for (DynamicObject cashflow : writeBackCol_sell) {
                    BigDecimal amt_new = bill.getBigDecimal("restamt2").multiply(buyAmtDir.negate());
                    cashflow.set("cfpayamount", (Object)amt_new);
                }
            }
            newCashflowSell = this.createCashFlow_Forex(tradebill, "sell", tradebill.getDynamicObject("sellcurrency"), payAmt, paydate, fixRate, useRate, Boolean.FALSE, subBizRecord.getLong("id"));
            newCashflowSell.set("cfprincipal", (Object)principal);
            ((DynamicObject)newCashflowSell.getDynamicObjectCollection("entrys").get(0)).set("cfratefixdate", (Object)this.calcRateFixDate(tradebill, paydate));
            if (DeliveryWayEnum.non_deliverable.getValue().equals(tradebill.getString("deliveryway"))) {
                newCashflowSell.set("cfpayamount", (Object)ForexCashFlowHelper.calcPayAmount_fwd((DynamicObject)tradebill, (BigDecimal)principal, (BigDecimal)fixRate, (BigDecimal)useRate));
            }
            insertCol.add(newCashflowSell);
            sellCol.add(newCashflowSell);
            this.reSetCashFlowNo(sellCol);
            sellCol.remove(newCashflowSell);
            updateCol.addAll(sellCol);
        }
        if (insertCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertCol.toArray(new DynamicObject[0]));
        }
        if (updateCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(bill.getString("exratecalmtd"))) {
            srcPlInfo = this.genPlBizRecord(tradebill, bill, bizRecord);
        } else {
            srcPlInfo = this.queryPlInfo(tradebill, bill);
            if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("restamt1")) == 0) {
                srcPlInfo.set("floatplamt", (Object)BigDecimal.ZERO);
                srcPlInfo.set("floatpllocalamt", (Object)BigDecimal.ZERO);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcPlInfo});
        }
        DynamicObject newPlInfo = this.genNewPlInfo(tradebill, bill, srcPlInfo, subBizRecord);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newPlInfo});
        this.dealTradeBill_Forex(tradebill, bill, deferOrMaudate.getValue(), bizRecord);
    }

    private Date calcRateFixDate(DynamicObject tradebill, Date paydate) {
        DynamicObjectCollection wc = tradebill.getDynamicObjectCollection("workcalendar");
        int offset = tradebill.getInt("settledelay");
        return TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)paydate, (int)(-offset));
    }
}

