/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill.forex;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.tm.business.service.bizbill.AbstractBizBillAuditService;
import kd.tmc.tm.common.enums.BizBillTypeEnum;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.helper.CashFlowHelper;
import kd.tmc.tm.common.helper.ForexCashFlowHelper;
import kd.tmc.tm.common.helper.ForexOptionsHelper;
import kd.tmc.tm.common.helper.OptionCombBillWriteBackHelper;

public class ForexOptionsBizBillAuditService
extends AbstractBizBillAuditService {
    private String entityName = "tm_forex_options";

    @Override
    public String getBizBillTypeId(String op) {
        if (BizOperateEnum.flat.getValue().equals(op)) {
            return BizBillTypeEnum.flat.getId();
        }
        if (BizOperateEnum.exercise.getValue().equals(op)) {
            return BizBillTypeEnum.exercise.getId();
        }
        if (BizOperateEnum.giveup.getValue().equals(op)) {
            return BizBillTypeEnum.giveup.getId();
        }
        return null;
    }

    @Override
    public Map<String, Object> verifyBeforeDo(Long id, String op) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)id, (String)this.entityName, (String)"billstatus");
        String billstatus = bill.getString("billstatus");
        if ((BizOperateEnum.flat.getValue().equals(op) || BizOperateEnum.exercise.getValue().equals(op) || BizOperateEnum.giveup.getValue().equals(op)) && !TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) {
            result.put("flag", Boolean.FALSE);
            result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
            return result;
        }
        this.checkUnAuditDownBizBill(this.entityName, id, result);
        return result;
    }

    @Override
    public void auditBusinessBill(DynamicObject tradebill, DynamicObject bill) {
        String operate = bill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case exercise: {
                this.ex_forexOptions(tradebill, bill);
                break;
            }
            case giveup: {
                this.giveup_forexOptions(tradebill, bill);
                break;
            }
            case flat: {
                this.flat_forexOptions(tradebill, bill);
            }
        }
    }

    protected void ex_forexOptions(DynamicObject tradebill, DynamicObject bill) {
        DynamicObject bizRecord = this.genBizRecord(bill, BizOperateEnum.exercise.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> updateCol = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> insertCol = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        DynamicObject setttleCurrency = tradebill.getDynamicObject("settlecurrency");
        String dir = tradebill.getString("tradedirect");
        String tradeType = tradebill.getString("tradetype");
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (ForexOptionsHelper.callAndSellORPutAndBuy((String)dir, (String)tradeType)) {
            buyAmtDir = buyAmtDir.negate();
        }
        ArrayList<DynamicObject> buyCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "buy", buyCol, delCol, writeBackCol_buy, true);
        Date expireDate = tradebill.getDate("adjexpiredate");
        String deliveryWay = tradebill.getString("deliveryway");
        BigDecimal fixRate = bizRecord.getBigDecimal("exrate");
        if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) || DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && tradebill.getString("pair").split("/")[0].equals(setttleCurrency.getString("number"))) {
            BigDecimal principal;
            BigDecimal payAmt;
            Date paydate = bill.getDate("deliverydate");
            BigDecimal useRate = bill.getBigDecimal("execexrate");
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                payAmt = bill.getBigDecimal("settleamount");
                principal = bill.getBigDecimal("restamt1");
                BigDecimal payAmount = ForexCashFlowHelper.calPayAmt_ForexOption((DynamicObject)tradebill, (BigDecimal)principal);
                for (DynamicObject cashflow : writeBackCol_buy) {
                    cashflow.set("cfprincipal", (Object)principal);
                    cashflow.set("cfpayamount", (Object)payAmount);
                }
                principal = bill.getBigDecimal("bizamt1");
            } else {
                payAmt = bill.getBigDecimal("bizamt1").multiply(buyAmtDir);
                principal = BigDecimal.ZERO;
                for (DynamicObject cashflow : writeBackCol_buy) {
                    BigDecimal amt_new = bill.getBigDecimal("restamt1").multiply(buyAmtDir);
                    cashflow.set("cfpayamount", (Object)amt_new);
                }
            }
            DynamicObject newCashflowBuy = this.createCashFlow_ForexOption(tradebill, "buy", DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) ? bill.getDynamicObject("plcurrency") : tradebill.getDynamicObject("currency"), payAmt, paydate, fixRate, useRate, bill.getDate("bizdate"), Boolean.TRUE, null);
            newCashflowBuy.set("cfprincipal", (Object)principal);
            insertCol.add(newCashflowBuy);
            buyCol.add(newCashflowBuy);
            this.reSetCashFlowNo(buyCol);
            buyCol.remove(newCashflowBuy);
            updateCol.addAll(buyCol);
        }
        ArrayList<DynamicObject> sellCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "sell", sellCol, delCol, writeBackCol_sell, true);
        if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) || DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && tradebill.getString("pair").split("/")[1].equals(setttleCurrency.getString("number"))) {
            BigDecimal principal;
            BigDecimal payAmt;
            Date paydate = bill.getDate("deliverydate");
            BigDecimal useRate = bill.getBigDecimal("execexrate");
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                payAmt = bill.getBigDecimal("settleamount");
                principal = bill.getBigDecimal("restamt1");
                BigDecimal payAmount = ForexCashFlowHelper.calPayAmt_ForexOption((DynamicObject)tradebill, (BigDecimal)principal);
                for (DynamicObject cashflow : writeBackCol_sell) {
                    cashflow.set("cfprincipal", (Object)principal);
                    cashflow.set("cfpayamount", (Object)payAmount);
                }
                principal = bill.getBigDecimal("bizamt1");
            } else {
                payAmt = bill.getBigDecimal("bizamt2").multiply(buyAmtDir.negate());
                principal = BigDecimal.ZERO;
                for (DynamicObject cashflow : writeBackCol_sell) {
                    BigDecimal amt_new = bill.getBigDecimal("restamt2").multiply(buyAmtDir.negate());
                    cashflow.set("cfpayamount", (Object)amt_new);
                }
            }
            DynamicObject newCashflowSell = this.createCashFlow_ForexOption(tradebill, "sell", DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) ? bill.getDynamicObject("plcurrency") : tradebill.getDynamicObject("sellcurrency"), payAmt, paydate, fixRate, useRate, bill.getDate("bizdate"), Boolean.TRUE, null);
            newCashflowSell.set("cfprincipal", (Object)principal);
            insertCol.add(newCashflowSell);
            sellCol.add(newCashflowSell);
            this.reSetCashFlowNo(sellCol);
            sellCol.remove(newCashflowSell);
            updateCol.addAll(sellCol);
        }
        if (insertCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertCol.toArray(new DynamicObject[0]));
        }
        if (updateCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        this.genPlBizRecord(tradebill, bill, bizRecord);
        this.dealTradeBill_Forex(tradebill, bill, BizOperateEnum.exercise.getValue(), bizRecord);
        if (tradebill.getString("billstatus").equals(TcBillStatusEnum.FINISH.getValue())) {
            OptionCombBillWriteBackHelper.finishWriteBack((DynamicObject[])new DynamicObject[]{tradebill});
        }
    }

    private DynamicObject createCashFlow_ForexOption(DynamicObject tradeBill, String dir, DynamicObject currency, BigDecimal payAmount, Date paydate, BigDecimal fixRate, BigDecimal useRate, Date expireDate, Boolean isHis, Long bizRecordId) {
        DynamicObject cashflow = TmcDataServiceHelper.newDynamicObject((String)"tm_cashflow");
        cashflow.set("id", (Object)DBServiceHelper.genGlobalLongId());
        cashflow.set("billnumber", (Object)tradeBill.getString("billno"));
        cashflow.set("org", (Object)tradeBill.getDynamicObject("org"));
        cashflow.set("billid", (Object)tradeBill.getLong("id"));
        String deliveryWay = tradeBill.getString("deliveryway");
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
            cashflow.set("cftype", (Object)CashFlowTypeEnum.pl.getValue());
        } else {
            cashflow.set("cftype", (Object)CashFlowTypeEnum.capital.getValue());
        }
        cashflow.set("cfdirection", (Object)dir);
        cashflow.set("cfcurrency", (Object)currency);
        cashflow.set("cfpayamount", (Object)payAmount);
        cashflow.set("cfpaydate", (Object)paydate);
        cashflow.set("cfishis", (Object)isHis);
        cashflow.set("cfbizrecordid", (Object)bizRecordId);
        DynamicObject resetRow = cashflow.getDynamicObjectCollection("entrys").addNew();
        resetRow.set("cffixrate", (Object)fixRate);
        resetRow.set("cfuserate", (Object)useRate);
        resetRow.set("cfratefixdate", (Object)expireDate);
        return cashflow;
    }

    protected void giveup_forexOptions(DynamicObject tradebill, DynamicObject bill) {
        BigDecimal amt_new;
        DynamicObject bizRecord = this.genBizRecord(bill, BizOperateEnum.giveup.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> saveCol = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        String dir = tradebill.getString("tradedirect");
        String tradeType = tradebill.getString("tradetype");
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (ForexOptionsHelper.callAndSellORPutAndBuy((String)dir, (String)tradeType)) {
            buyAmtDir = buyAmtDir.negate();
        }
        DynamicObject setttleCurrency = tradebill.getDynamicObject("settlecurrency");
        String deliveryWay = tradebill.getString("deliveryway");
        if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) || DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && tradebill.getString("pair").split("/")[0].equals(setttleCurrency.getString("number"))) {
            this.splitCashFlow(tradebill, bill, "buy", saveCol, delCol, writeBackCol_buy, true);
            for (DynamicObject cashflow : writeBackCol_buy) {
                amt_new = bill.getBigDecimal("restamt1");
                if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                    cashflow.set("cfpayamount", (Object)amt_new.multiply(buyAmtDir));
                    continue;
                }
                cashflow.set("cfprincipal", (Object)amt_new);
                BigDecimal payAmount = ForexCashFlowHelper.calPayAmt_ForexOption((DynamicObject)tradebill, (BigDecimal)amt_new);
                cashflow.set("cfpayamount", (Object)payAmount);
            }
        }
        if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) || DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && tradebill.getString("pair").split("/")[1].equals(setttleCurrency.getString("number"))) {
            this.splitCashFlow(tradebill, bill, "sell", saveCol, delCol, writeBackCol_sell, true);
            for (DynamicObject cashflow : writeBackCol_sell) {
                amt_new = bill.getBigDecimal("restamt2").multiply(buyAmtDir.negate());
                if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                    cashflow.set("cfpayamount", (Object)amt_new);
                    continue;
                }
                BigDecimal restamt1 = bill.getBigDecimal("restamt1");
                cashflow.set("cfprincipal", (Object)restamt1);
                BigDecimal payAmount = ForexCashFlowHelper.calPayAmt_ForexOption((DynamicObject)tradebill, (BigDecimal)restamt1);
                cashflow.set("cfpayamount", (Object)payAmount);
            }
        }
        if (saveCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        this.genPlBizRecord(tradebill, bill, bizRecord);
        this.dealTradeBill_Forex(tradebill, bill, BizOperateEnum.giveup.getValue(), bizRecord);
        if (tradebill.getString("billstatus").equals(TcBillStatusEnum.FINISH.getValue())) {
            OptionCombBillWriteBackHelper.finishWriteBack((DynamicObject[])new DynamicObject[]{tradebill});
        }
    }

    protected void flat_forexOptions(DynamicObject tradebill, DynamicObject bill) {
        BigDecimal amt_new;
        DynamicObject bizRecord = this.genBizRecord(bill, BizOperateEnum.flat.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> saveCol = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        String dir = tradebill.getString("tradedirect");
        String tradeType = tradebill.getString("tradetype");
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (ForexOptionsHelper.callAndSellORPutAndBuy((String)dir, (String)tradeType)) {
            buyAmtDir = buyAmtDir.negate();
        }
        DynamicObject setttleCurrency = tradebill.getDynamicObject("settlecurrency");
        String deliveryWay = tradebill.getString("deliveryway");
        if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) || DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && tradebill.getString("pair").split("/")[0].equals(setttleCurrency.getString("number"))) {
            this.splitCashFlow(tradebill, bill, "buy", saveCol, delCol, writeBackCol_buy, true);
            for (DynamicObject cashflow : writeBackCol_buy) {
                amt_new = bill.getBigDecimal("restamt1");
                if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                    cashflow.set("cfpayamount", (Object)amt_new.multiply(buyAmtDir));
                    continue;
                }
                cashflow.set("cfprincipal", (Object)amt_new);
                BigDecimal payAmount = ForexCashFlowHelper.calPayAmt_ForexOption((DynamicObject)tradebill, (BigDecimal)amt_new);
                cashflow.set("cfpayamount", (Object)payAmount);
            }
        }
        if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) || DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && tradebill.getString("pair").split("/")[1].equals(setttleCurrency.getString("number"))) {
            this.splitCashFlow(tradebill, bill, "sell", saveCol, delCol, writeBackCol_sell, true);
            for (DynamicObject cashflow : writeBackCol_sell) {
                amt_new = bill.getBigDecimal("restamt2").multiply(buyAmtDir.negate());
                if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                    cashflow.set("cfpayamount", (Object)amt_new);
                    continue;
                }
                BigDecimal restamt1 = bill.getBigDecimal("restamt1");
                cashflow.set("cfprincipal", (Object)restamt1);
                BigDecimal payAmount = ForexCashFlowHelper.calPayAmt_ForexOption((DynamicObject)tradebill, (BigDecimal)restamt1);
                cashflow.set("cfpayamount", (Object)payAmount);
            }
        }
        if (saveCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        this.genPlBizRecord(tradebill, bill, bizRecord);
        this.dealTradeBill_Forex(tradebill, bill, BizOperateEnum.flat.getValue(), bizRecord);
        if (tradebill.getString("billstatus").equals(TcBillStatusEnum.FINISH.getValue())) {
            OptionCombBillWriteBackHelper.finishWriteBack((DynamicObject[])new DynamicObject[]{tradebill});
        }
    }
}

