/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill.forex;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.bizbill.AbstractBizBillAuditService;
import kd.tmc.tm.common.enums.BizBillTypeEnum;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;
import kd.tmc.tm.common.helper.CashFlowHelper;
import kd.tmc.tm.common.helper.ForexCashFlowHelper;

public class ForexSwapBizBillAuditService
extends AbstractBizBillAuditService {
    private static final Log logger = LogFactory.getLog(ForexSwapBizBillAuditService.class);
    private String entityName = "tm_forex_swaps";

    @Override
    public String getBizBillTypeId(String op) {
        String billTypeId;
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)op);
        switch (bizOp) {
            case expiredey_f: 
            case expiredey_n: {
                billTypeId = BizBillTypeEnum.expiredey.getId();
                break;
            }
            case bdelivery_f: 
            case bdelivery_n: {
                billTypeId = BizBillTypeEnum.bdelivery.getId();
                break;
            }
            case flat_f: 
            case flat_n: {
                billTypeId = BizBillTypeEnum.f_flat.getId();
                break;
            }
            case defer_f: 
            case defer_n: {
                billTypeId = BizBillTypeEnum.defer.getId();
                break;
            }
            case maudate_f: 
            case maudate_n: {
                billTypeId = BizBillTypeEnum.maudate.getId();
                break;
            }
            default: {
                billTypeId = null;
            }
        }
        return billTypeId;
    }

    @Override
    public Map<String, Object> verifyBeforeDo(Long id, String op) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)id, (String)this.entityName, (String)"billstatus,deliveryway,source,isneardey,swaptype,bizrestamt,farbizrestamt");
        String billstatus = bill.getString("billstatus");
        String swaptype = bill.getString("swaptype");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)op);
        switch (bizOp) {
            case expiredey_f: 
            case expiredey_n: 
            case flat_f: 
            case flat_n: {
                if (TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) break;
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
            case bdelivery_f: 
            case defer_f: 
            case maudate_f: {
                if (!TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) {
                    result.put("flag", Boolean.FALSE);
                    result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
                    return result;
                }
                if (ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(swaptype) || ForexSwapsTypeEnum.FWDTOFWD.getValue().equals(swaptype)) break;
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u6240\u9009\u4ea4\u6613\u8fdc\u7aef\u4e0d\u652f\u6301\u8be5\u751f\u547d\u5468\u671f\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_ForexSwapFarType_2", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
            case bdelivery_n: 
            case defer_n: 
            case maudate_n: {
                if (!TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) {
                    result.put("flag", Boolean.FALSE);
                    result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
                    return result;
                }
                if (ForexSwapsTypeEnum.FWDTOFWD.getValue().equals(swaptype)) break;
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u6240\u9009\u4ea4\u6613\u8fd1\u7aef\u4e0d\u652f\u6301\u8be5\u751f\u547d\u5468\u671f\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_ForexSwapType", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
        }
        if (op.indexOf("_n") > 0 && BigDecimal.ZERO.compareTo(bill.getBigDecimal("bizrestamt")) == 0) {
            result.put("flag", Boolean.FALSE);
            result.put("tip", ResManager.loadKDString((String)"\u8fd1\u7aef\u6301\u4ed3\u91d1\u989d\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u751f\u547d\u5468\u671f\u64cd\u4f5c\u3002", (String)"Check_ForexSwapBizRestAmt", (String)"tmc-tm-business", (Object[])new Object[0]));
            return result;
        }
        if (op.indexOf("_f") > 0 && BigDecimal.ZERO.compareTo(bill.getBigDecimal("farbizrestamt")) == 0) {
            result.put("flag", Boolean.FALSE);
            result.put("tip", ResManager.loadKDString((String)"\u8fdc\u7aef\u6301\u4ed3\u91d1\u989d\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u751f\u547d\u5468\u671f\u64cd\u4f5c\u3002", (String)"Check_ForexSwapFarBizRestAmt", (String)"tmc-tm-business", (Object[])new Object[0]));
            return result;
        }
        this.checkUnAuditDownBizBill(this.entityName, id, result);
        return result;
    }

    @Override
    public void auditBusinessBill(DynamicObject tradebill, DynamicObject bill) {
        String operate = bill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case expiredey_f: 
            case expiredey_n: {
                this.expiredDey_ForexSwap(tradebill, bill, bizOp);
                break;
            }
            case flat_f: 
            case flat_n: {
                this.flat_ForexSwap(tradebill, bill, bizOp);
                break;
            }
            case bdelivery_f: 
            case bdelivery_n: {
                this.beDey_forexSwap(tradebill, bill, bizOp);
                break;
            }
            case defer_f: 
            case defer_n: 
            case maudate_f: 
            case maudate_n: {
                this.deferOrMaudate_ForexSwap(tradebill, bill, bizOp);
            }
        }
    }

    protected void beDey_forexSwap(DynamicObject tradebill, DynamicObject bill, BizOperateEnum bizOp) {
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> updateCol = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> insertCol = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            buyAmtDir = buyAmtDir.negate();
        }
        if (bizOp.getValue().indexOf("_f") > 0) {
            buyAmtDir = buyAmtDir.negate();
        }
        String exrateCalMtd = bill.getString("exratecalmtd");
        BigDecimal useRate = ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(exrateCalMtd) ? bill.getBigDecimal("execexrate") : bill.getBigDecimal("spotrate_dey");
        ArrayList<DynamicObject> buyCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "buy", buyCol, delCol, writeBackCol_buy, true);
        for (DynamicObject cashflow : writeBackCol_buy) {
            BigDecimal amt_new = bill.getBigDecimal("restamt1").multiply(buyAmtDir);
            cashflow.set("cfpayamount", (Object)amt_new);
        }
        DynamicObject newCashflowBuy = this.createCashFlow_Forex(tradebill, "buy", tradebill.getDynamicObject("currency"), bill.getBigDecimal("bizamt1").multiply(buyAmtDir), bill.getDate("deliverydate"), bill.getBigDecimal("spotrate_dey"), useRate, Boolean.TRUE, null);
        insertCol.add(newCashflowBuy);
        buyCol.add(newCashflowBuy);
        this.reSetCashFlowNo(buyCol);
        buyCol.remove(newCashflowBuy);
        updateCol.addAll(buyCol);
        ArrayList<DynamicObject> sellCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "sell", sellCol, delCol, writeBackCol_sell, true);
        for (DynamicObject cashflow : writeBackCol_sell) {
            BigDecimal amt_new = bill.getBigDecimal("restamt2").multiply(buyAmtDir.negate());
            cashflow.set("cfpayamount", (Object)amt_new);
        }
        DynamicObject newCashflowSell = this.createCashFlow_Forex(tradebill, "sell", tradebill.getDynamicObject("sellcurrency"), bill.getBigDecimal("bizamt2").multiply(buyAmtDir.negate()), bill.getDate("deliverydate"), bill.getBigDecimal("spotrate_dey"), useRate, Boolean.TRUE, null);
        insertCol.add(newCashflowSell);
        sellCol.add(newCashflowSell);
        this.reSetCashFlowNo(sellCol);
        sellCol.remove(newCashflowSell);
        updateCol.addAll(sellCol);
        if (insertCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertCol.toArray(new DynamicObject[0]));
        }
        if (updateCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        DynamicObject bizRecord = this.genBizRecord(bill, bizOp.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        this.genPlBizRecord(tradebill, bill, bizRecord);
        this.dealTradeBill_Forex(tradebill, bill, bizOp.getValue(), bizRecord);
    }

    protected void deferOrMaudate_ForexSwap(DynamicObject tradebill, DynamicObject bill, BizOperateEnum bizOp) {
        DynamicObject srcPlInfo;
        boolean isNear;
        String swapDir;
        DynamicObject bizRecord = this.genBizRecord(bill, bizOp.getValue());
        DynamicObject subBizRecord = this.genSubBizRecord(tradebill, bill, bizRecord);
        if (bizOp.getValue().indexOf("_n") > 0) {
            swapDir = "isnear";
            isNear = true;
        } else {
            swapDir = "isfar";
            isNear = false;
        }
        subBizRecord.set("swapdir", (Object)swapDir);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord, subBizRecord});
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> updateCol = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> insertCol = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            buyAmtDir = buyAmtDir.negate();
        }
        if (bizOp.getValue().indexOf("_f") > 0) {
            buyAmtDir = buyAmtDir.negate();
        }
        Date deydate = bill.getDate("deliverydate");
        BigDecimal useRate = this.calUseRate_ForexSwap(tradebill, isNear, deydate);
        BigDecimal fixRate = bill.getBigDecimal("spotrate_dey");
        ArrayList<DynamicObject> buyCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "buy", buyCol, delCol, writeBackCol_buy, true);
        for (DynamicObject cashflow : writeBackCol_buy) {
            BigDecimal amt_new = bill.getBigDecimal("restamt1").multiply(buyAmtDir);
            cashflow.set("cfpayamount", (Object)amt_new);
        }
        DynamicObject newCashflowBuy = this.createCashFlow_Forex(tradebill, "buy", tradebill.getDynamicObject("currency"), bill.getBigDecimal("bizamt1").multiply(buyAmtDir), deydate, fixRate, useRate, Boolean.FALSE, subBizRecord.getLong("id"));
        insertCol.add(newCashflowBuy);
        buyCol.add(newCashflowBuy);
        this.reSetCashFlowNo(buyCol);
        buyCol.remove(newCashflowBuy);
        updateCol.addAll(buyCol);
        ArrayList<DynamicObject> sellCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "sell", sellCol, delCol, writeBackCol_sell, true);
        for (DynamicObject cashflow : writeBackCol_sell) {
            BigDecimal amt_new = bill.getBigDecimal("restamt2").multiply(buyAmtDir.negate());
            cashflow.set("cfpayamount", (Object)amt_new);
        }
        DynamicObject newCashflowSell = this.createCashFlow_Forex(tradebill, "sell", tradebill.getDynamicObject("sellcurrency"), bill.getBigDecimal("bizamt2").multiply(buyAmtDir.negate()), deydate, fixRate, useRate, Boolean.FALSE, subBizRecord.getLong("id"));
        insertCol.add(newCashflowSell);
        sellCol.add(newCashflowSell);
        this.reSetCashFlowNo(sellCol);
        sellCol.remove(newCashflowSell);
        updateCol.addAll(sellCol);
        if (insertCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertCol.toArray(new DynamicObject[0]));
        }
        if (updateCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(bill.getString("exratecalmtd"))) {
            srcPlInfo = this.genPlBizRecord(tradebill, bill, bizRecord);
        } else {
            srcPlInfo = this.queryPlInfo(tradebill, bill);
            this.clearFloatPlAmt(tradebill, bill, srcPlInfo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcPlInfo});
        }
        DynamicObject newPlInfo = this.genNewPlInfo(tradebill, bill, srcPlInfo, subBizRecord);
        newPlInfo.set("swapdir", (Object)swapDir);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newPlInfo});
        this.dealTradeBill_Forex(tradebill, bill, bizOp.getValue(), bizRecord);
    }

    private void clearFloatPlAmt(DynamicObject tradebill, DynamicObject bill, DynamicObject plInfo) {
        String operate = bill.getString("operate");
        String swapType = tradebill.getString("swaptype");
        if (ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(swapType) && operate.indexOf("_f") > 0 && BigDecimal.ZERO.compareTo(bill.getBigDecimal("restamt1")) == 0) {
            plInfo.set("floatplamt", (Object)BigDecimal.ZERO);
            plInfo.set("floatpllocalamt", (Object)BigDecimal.ZERO);
        }
        if (ForexSwapsTypeEnum.FWDTOFWD.getValue().equals(swapType) && BigDecimal.ZERO.compareTo(bill.getBigDecimal("restamt1")) == 0) {
            plInfo.set("floatplamt", (Object)BigDecimal.ZERO);
            plInfo.set("floatpllocalamt", (Object)BigDecimal.ZERO);
        }
    }

    private BigDecimal calUseRate_ForexSwap(DynamicObject tradebill, Boolean isNear, Date deyDate) {
        BigDecimal useRate;
        ForexQuoteInfo fxInfo;
        Long fqId = tradebill.getDynamicObject("pricerule").getDynamicObject("forexquote").getLong("id");
        String fxQuote = tradebill.getString("fxquote");
        String pair = tradebill.getString("pair");
        String dir = tradebill.getString("tradedirect");
        if (isNear.booleanValue()) {
            fxInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, (Date)deyDate);
            useRate = TradeDirectionEnum.buy.getValue().equals(dir) && pair.equals(fxInfo.getFxquote()) || TradeDirectionEnum.sell.getValue().equals(dir) && !pair.equals(fxInfo.getFxquote()) ? fxInfo.getSellPrice() : fxInfo.getBuyPrice();
        } else {
            fxInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, (Date)deyDate);
            useRate = TradeDirectionEnum.sell.getValue().equals(dir) && pair.equals(fxInfo.getFxquote()) || TradeDirectionEnum.buy.getValue().equals(dir) && !pair.equals(fxInfo.getFxquote()) ? fxInfo.getSellPrice() : fxInfo.getBuyPrice();
        }
        String fq = fxInfo.getFxquote();
        if (!fq.equals(fxQuote)) {
            BigDecimal newExRate = BigDecimal.ONE.divide(useRate, 10, RoundingMode.HALF_UP);
            logger.info("\u53d6\u5230\u7684\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)useRate, (Object)newExRate);
            return newExRate;
        }
        logger.info("\u53d6\u5230\u7684\u6c47\u7387{}", (Object)useRate);
        return useRate;
    }

    protected void flat_ForexSwap(DynamicObject tradebill, DynamicObject bill, BizOperateEnum bizOp) {
        Object[] sellCashFlowCol;
        BigDecimal amt_new;
        BigDecimal marketRate;
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        ArrayList<DynamicObject> saveCol = new ArrayList<DynamicObject>(2);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            buyAmtDir = buyAmtDir.negate();
        }
        if (bizOp.getValue().indexOf("_f") > 0) {
            buyAmtDir = buyAmtDir.negate();
        }
        this.splitCashFlow(tradebill, bill, "buy", saveCol, delCol, writeBackCol_buy, false);
        this.splitCashFlow(tradebill, bill, "sell", saveCol, delCol, writeBackCol_sell, false);
        if (BizOperateEnum.flat_f == bizOp) {
            DynamicObject copyTradeBill = (DynamicObject)OrmUtils.clone((Object)tradebill, (IDataEntityType)tradebill.getDataEntityType(), (boolean)true, (boolean)true);
            copyTradeBill.set("tradedirect", (Object)(TradeDirectionEnum.buy.getValue().equals(tradebill.getString("tradedirect")) ? TradeDirectionEnum.sell.getValue() : TradeDirectionEnum.buy.getValue()));
            marketRate = ForexCashFlowHelper.queryExRate((DynamicObject)copyTradeBill, (Date)tradebill.getDate("adjustsettledate_far"));
        } else {
            marketRate = ForexCashFlowHelper.queryExRate((DynamicObject)tradebill, (Date)tradebill.getDate("adjustsettledate"));
        }
        for (DynamicObject cashflow : writeBackCol_buy) {
            amt_new = bill.getBigDecimal("restamt1").multiply(buyAmtDir);
            cashflow.set("cfpayamount", (Object)amt_new);
            ((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).set("cfuserate", (Object)marketRate);
        }
        if (EmptyUtil.isNoEmpty(writeBackCol_sell)) {
            for (DynamicObject cashflow : writeBackCol_sell) {
                amt_new = bill.getBigDecimal("restamt2").multiply(buyAmtDir.negate());
                cashflow.set("cfpayamount", (Object)amt_new);
                ((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).set("cfuserate", (Object)marketRate);
            }
        }
        if (saveCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        DynamicObject bizRecord = this.genBizRecord(bill, bizOp.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        this.genPlBizRecord(tradebill, bill, bizRecord);
        this.dealTradeBill_Forex(tradebill, bill, bizOp.getValue(), bizRecord);
        Object[] buyCashFlowCol = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfbizrecordid,cfishis,cfpaydate,cfcurrency,cfpayamount,cfprincipal,no,cffixrate,cfuserate", (QFilter[])new QFilter[]{filter_cashflow, new QFilter("cfdirection", "=", (Object)"buy")});
        if (EmptyUtil.isNoEmpty((Object[])buyCashFlowCol)) {
            List<DynamicObject> list = Arrays.stream(buyCashFlowCol).collect(Collectors.toList());
            this.reSetCashFlowNo(list);
            SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
        if (EmptyUtil.isNoEmpty((Object[])(sellCashFlowCol = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfbizrecordid,cfishis,cfpaydate,cfcurrency,cfpayamount,cfprincipal,no,cffixrate,cfuserate", (QFilter[])new QFilter[]{filter_cashflow, new QFilter("cfdirection", "=", (Object)"sell")})))) {
            List<DynamicObject> list = Arrays.stream(sellCashFlowCol).collect(Collectors.toList());
            this.reSetCashFlowNo(list);
            SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    protected void expiredDey_ForexSwap(DynamicObject tradebill, DynamicObject bill, BizOperateEnum bizOp) {
        DynamicObject bizRecord = this.genBizRecord(bill, bizOp.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> updateCol = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> insertCol = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            buyAmtDir = buyAmtDir.negate();
        }
        if (bizOp.getValue().indexOf("_f") > 0) {
            buyAmtDir = buyAmtDir.negate();
        }
        ArrayList<DynamicObject> buyCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "buy", buyCol, delCol, writeBackCol_buy, true);
        for (DynamicObject cashflow : writeBackCol_buy) {
            BigDecimal amt_new = bill.getBigDecimal("restamt1").multiply(buyAmtDir);
            cashflow.set("cfpayamount", (Object)amt_new);
        }
        BigDecimal useRate = bill.getBigDecimal("execexrate");
        BigDecimal fixRate = bizRecord.getBigDecimal("exrate");
        DynamicObject newCashflowBuy = this.createCashFlow_Forex(tradebill, "buy", tradebill.getDynamicObject("currency"), bill.getBigDecimal("bizamt1").multiply(buyAmtDir), bill.getDate("deliverydate"), fixRate, useRate, Boolean.TRUE, null);
        insertCol.add(newCashflowBuy);
        buyCol.add(newCashflowBuy);
        this.reSetCashFlowNo(buyCol);
        buyCol.remove(newCashflowBuy);
        updateCol.addAll(buyCol);
        ArrayList<DynamicObject> sellCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "sell", sellCol, delCol, writeBackCol_sell, true);
        for (DynamicObject cashflow : writeBackCol_sell) {
            BigDecimal amt_new = bill.getBigDecimal("restamt2").multiply(buyAmtDir.negate());
            cashflow.set("cfpayamount", (Object)amt_new);
        }
        DynamicObject newCashflowSell = this.createCashFlow_Forex(tradebill, "sell", tradebill.getDynamicObject("sellcurrency"), bill.getBigDecimal("bizamt2").multiply(buyAmtDir.negate()), bill.getDate("deliverydate"), fixRate, useRate, Boolean.TRUE, null);
        insertCol.add(newCashflowSell);
        sellCol.add(newCashflowSell);
        this.reSetCashFlowNo(sellCol);
        sellCol.remove(newCashflowSell);
        updateCol.addAll(sellCol);
        if (insertCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertCol.toArray(new DynamicObject[0]));
        }
        if (updateCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        this.genPlBizRecord(tradebill, bill, bizRecord);
        this.dealTradeBill_Forex(tradebill, bill, bizOp.getValue(), bizRecord);
    }
}

