/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill.rate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.business.service.bizbill.AbstractBizBillAuditService;
import kd.tmc.tm.common.enums.BizBillTypeEnum;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.helper.CashFlowHelper;
import kd.tmc.tm.common.helper.ForwRateAgreeCFBizHelper;

public class ForwRateAgreeBizBillAuditService
extends AbstractBizBillAuditService {
    private String entityName = "tm_forwrateagree";

    @Override
    public String getBizBillTypeId(String op) {
        if (BizOperateEnum.ratecfg.getValue().equals(op)) {
            return BizBillTypeEnum.forwrateagree_rate.getId();
        }
        if (BizOperateEnum.interestpay.getValue().equals(op)) {
            return BizBillTypeEnum.forwrateagree_pay.getId();
        }
        return null;
    }

    @Override
    public Map<String, Object> verifyBeforeDo(Long id, String op) {
        DynamicObject cashflow;
        QFilter filter_cashflow;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)id, (String)this.entityName, (String)"billstatus");
        String billstatus = bill.getString("billstatus");
        if (BizOperateEnum.ratecfg.getValue().equals(op)) {
            if (!TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
            filter_cashflow = new QFilter("billid", "=", bill.getPkValue());
            cashflow = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"entrys.cfisratecfg", (QFilter[])new QFilter[]{filter_cashflow});
            if (EmptyUtil.isNoEmpty((DynamicObject)cashflow) && ((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).getBoolean("cfisratecfg")) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u8be5\u4ea4\u6613\u5f53\u524d\u65e0\u9700\u5229\u7387\u786e\u8ba4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ForwRateAgreeBizFactory_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
        }
        if (BizOperateEnum.interestpay.getValue().equals(op)) {
            if (!TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
            filter_cashflow = new QFilter("billid", "=", bill.getPkValue());
            cashflow = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"entrys.cfisratecfg", (QFilter[])new QFilter[]{filter_cashflow});
            if (EmptyUtil.isNoEmpty((DynamicObject)cashflow) && !((DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0)).getBoolean("cfisratecfg")) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5229\u7387\u786e\u8ba4\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5355\u636e\u3002", (String)"Check_RateCfg", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
        }
        this.checkUnAuditDownBizBill(this.entityName, id, result);
        return result;
    }

    @Override
    public void auditBusinessBill(DynamicObject tradebill, DynamicObject bill) {
        String operate = bill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case ratecfg: {
                this.rateCfg_forwRateAgree(tradebill, bill);
                break;
            }
            case interestpay: {
                this.pay_forwRateAgree(tradebill, bill);
            }
        }
    }

    protected void rateCfg_forwRateAgree(DynamicObject tradebill, DynamicObject bill) {
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        DynamicObject[] cashflowCol = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cfpaydate,cfpayamount,cftheta,cfdiscfactor,cfpv,entrys.cfpaydate,entrys.cfisratecfg,entrys.cfratefixdate,entrys.cffixrate,entrys.cfuserate,cfamount", (QFilter[])new QFilter[]{filter_cashflow});
        BigDecimal fixRate = bill.getBigDecimal("fixedrate_pay");
        for (DynamicObject cashflow : cashflowCol) {
            BigDecimal payAmount = ForwRateAgreeCFBizHelper.getPayAmount((BigDecimal)fixRate, (ModelAgent)new ModelAgent((Object)tradebill));
            cashflow.set("cfpayamount", (Object)payAmount);
            Date paydate = cashflow.getDate("cfpaydate");
            Date lastPaydate = TcDateUtils.getLastDay((Date)paydate, (int)1);
            Map DFs = ForwRateAgreeCFBizHelper.getDFs(null, (ModelAgent)new ModelAgent((Object)tradebill), (Date)paydate, (Date)lastPaydate);
            cashflow.set("cftheta", (Object)((BigDecimal)DFs.get(paydate)).subtract((BigDecimal)DFs.get(lastPaydate)).multiply(payAmount).negate());
            cashflow.set("cfdiscfactor", DFs.get(paydate));
            cashflow.set("cfpv", (Object)((BigDecimal)DFs.get(paydate)).multiply(payAmount));
            DynamicObject resetRow = (DynamicObject)cashflow.getDynamicObjectCollection("entrys").get(0);
            resetRow.set("cfisratecfg", (Object)Boolean.TRUE);
            resetRow.set("cfratefixdate", bill.get("ratefixdate_pay"));
            resetRow.set("cffixrate", (Object)fixRate);
            resetRow.set("cfuserate", (Object)fixRate);
        }
        SaveServiceHelper.save((DynamicObject[])cashflowCol);
        Long bizRecordId = bill.getLong("bizrecordid");
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((Object)bizRecordId, (String)"tm_bizrecord");
        bizRecord.set("bizdate", tradebill.get("adjustsettledate"));
        DynamicObjectCollection entryEntity = (DynamicObjectCollection)bizRecord.get("entryentity");
        int seq = entryEntity.size() + 1;
        DynamicObject rowEntry = entryEntity.addNew();
        rowEntry.set("seq", (Object)seq);
        rowEntry.set("bizop", (Object)BizOperateEnum.ratecfg.getValue());
        rowEntry.set("bizbillid", (Object)bill.getLong("id"));
        rowEntry.set("opdate", bill.get("bizdate"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        tradebill.set("bizop", (Object)BizOperateEnum.ratecfg.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tradebill});
    }

    protected void pay_forwRateAgree(DynamicObject tradebill, DynamicObject bill) {
        DynamicObject[] cashflowCol;
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        for (DynamicObject cashflow : cashflowCol = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cfishis,cfispay,cfpaydate,cfcurrency,cfpayamount,cfexchangerate,cftheta,cfdiscfactor,cfpv", (QFilter[])new QFilter[]{filter_cashflow})) {
            BigDecimal payamount = bill.getBigDecimal("plamt");
            cashflow.set("cfispay", (Object)Boolean.TRUE);
            cashflow.set("cfpaydate", bill.get("plsettledate"));
            cashflow.set("cfcurrency", bill.get("plcurrency"));
            cashflow.set("cfpayamount", (Object)payamount);
            cashflow.set("cfishis", (Object)Boolean.TRUE);
            Date paydate = cashflow.getDate("cfpaydate");
            Date lastPaydate = TcDateUtils.getLastDay((Date)paydate, (int)1);
            Map DFs = ForwRateAgreeCFBizHelper.getDFs(null, (ModelAgent)new ModelAgent((Object)tradebill), (Date)paydate, (Date)lastPaydate);
            cashflow.set("cftheta", (Object)((BigDecimal)DFs.get(paydate)).subtract((BigDecimal)DFs.get(lastPaydate)).multiply(payamount).negate());
            cashflow.set("cfdiscfactor", DFs.get(paydate));
            cashflow.set("cfpv", (Object)((BigDecimal)DFs.get(paydate)).multiply(payamount));
        }
        SaveServiceHelper.save((DynamicObject[])cashflowCol);
        tradebill.set("bizop", (Object)BizOperateEnum.interestpay.getValue());
        tradebill.set("bizrestamt", (Object)BigDecimal.ZERO);
        tradebill.set("billstatus", (Object)TcBillStatusEnum.FINISH.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tradebill});
        Object bizdate = bill.get("bizdate");
        Long bizRecordId = bill.getLong("bizrecordid");
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((Object)bizRecordId, (String)"tm_bizrecord");
        bizRecord.set("restamt", (Object)BigDecimal.ZERO);
        DynamicObjectCollection entryEntity = (DynamicObjectCollection)bizRecord.get("entryentity");
        int seq = entryEntity.size() + 1;
        DynamicObject rowEntry = entryEntity.addNew();
        rowEntry.set("seq", (Object)seq);
        rowEntry.set("bizop", (Object)BizOperateEnum.interestpay.getValue());
        rowEntry.set("bizbillid", (Object)bill.getLong("id"));
        rowEntry.set("opdate", bizdate);
        rowEntry.set("amount", bill.get("plamt"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        QFilter filterPlInfo = new QFilter("tradebill", "=", tradebill.getPkValue());
        DynamicObject plInfo = BusinessDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"id,floatplamt,floatpllocalamt,entrys.bizbillid,entrys.biztype,entrys.bizdate,plamt_sum,pllocalamt_sum,entrys.settledate,entrys.bizbillplcurrency,entrys.plamt,entrys.pllocalamt,yieldcurve", (QFilter[])new QFilter[]{filterPlInfo});
        DynamicObjectCollection entrys = (DynamicObjectCollection)plInfo.get("entrys");
        DynamicObject plInfoEntryRow = entrys.addNew();
        plInfoEntryRow.set("bizbillid", (Object)bill.getLong("id"));
        plInfoEntryRow.set("biztype", (Object)BizOperateEnum.interestpay.getValue());
        plInfoEntryRow.set("bizdate", bizdate);
        plInfoEntryRow.set("settledate", bill.get("plsettledate"));
        plInfoEntryRow.set("plamt", bill.get("plamt"));
        plInfoEntryRow.set("bizbillplcurrency", bill.get("plcurrency"));
        DynamicObject baseCurrency = bill.getDynamicObject("basecurrency");
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        if (baseCurrency != null && plCurrency != null && baseCurrency.getString("number").equals(plCurrency.getString("number"))) {
            plInfoEntryRow.set("pllocalamt", (Object)bill.getBigDecimal("plamt"));
        } else {
            plInfoEntryRow.set("pllocalamt", (Object)bill.getBigDecimal("baseplamt"));
        }
        plInfo.set("yieldcurve", null);
        plInfo.set("floatplamt", (Object)BigDecimal.ZERO);
        plInfo.set("floatpllocalamt", (Object)BigDecimal.ZERO);
        plInfo.set("pllocalamt_sum", plInfoEntryRow.get("pllocalamt"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plInfo});
    }
}

