/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill.rate;

import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.bizbill.AbstractBizBillSettleService;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.SettleSettingEnum;
import kd.tmc.tm.common.enums.SettleSettingModuleEnum;
import kd.tmc.tm.common.enums.SettleSettingOpEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;

public class RateSwapBizBillSettleService
extends AbstractBizBillSettleService {
    @Override
    public void settle(DynamicObject bizBill, Map<Long, DynamicObject> settlementSettingCache) throws KDException {
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        String operate = bizBill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case interestpay: {
                Long cashFlow_pay = bizBill.getLong("cashflow_pay");
                Long cashFlow_rec = bizBill.getLong("cashflow_rec");
                if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{cashFlow_pay, cashFlow_rec})) {
                    String swapType = tradeBill.getString("rateswaptype");
                    if (SwapTypeEnum.rate.getValue().equals(swapType)) {
                        this.genPayOrRecBill_bySettleAmount(bizBill);
                    }
                    if (!SwapTypeEnum.currency.getValue().equals(swapType)) break;
                    if (this.isGenExchangeBill(bizBill, settlementSettingCache, SettleSettingOpEnum.INTEREST_PAY)) {
                        this.genExchangeBill(bizBill);
                        break;
                    }
                    this.genRecBill(bizBill, null);
                    this.genPayBill(bizBill, null);
                    break;
                }
                if (EmptyUtil.isNoEmpty((Long)cashFlow_pay)) {
                    this.genPayBill(bizBill, null);
                    break;
                }
                if (!EmptyUtil.isNoEmpty((Long)cashFlow_rec)) break;
                this.genRecBill(bizBill, null);
                break;
            }
            case capitalpay: {
                if (SwapTypeEnum.currency.getValue().equals(tradeBill.get("rateswaptype"))) {
                    if (this.isGenExchangeBill(bizBill, settlementSettingCache, SettleSettingOpEnum.CAPITAL_PAY)) {
                        this.genExchangeBill(bizBill);
                        break;
                    }
                    this.genRecBill(bizBill, null);
                    this.genPayBill(bizBill, null);
                    break;
                }
                this.genRecBill(bizBill, null);
                this.genPayBill(bizBill, null);
                break;
            }
        }
    }

    private boolean isGenExchangeBill(DynamicObject bizBill, Map<Long, DynamicObject> settlementSettingCache, SettleSettingOpEnum settleSettingOpEnum) {
        Optional<DynamicObject> settleSetOptional;
        boolean isGenExchangeBill = false;
        DynamicObject settleSetBill = this.querySettlementSetting(settlementSettingCache, bizBill.getDynamicObject("org").getLong("id"));
        if (settleSetBill != null && (settleSetOptional = settleSetBill.getDynamicObjectCollection("ratesetting").stream().filter(o -> SettleSettingModuleEnum.BIZBILL_CURRENCYSWAP.getValue().equals(o.get("rate_module")) && settleSettingOpEnum.getValue().equals(o.get("rate_op"))).findAny()).isPresent() && SettleSettingEnum.EXCHANGE_BILL.getValue().equals(settleSetOptional.get().getString("rate_setting"))) {
            isGenExchangeBill = true;
        }
        return isGenExchangeBill;
    }
}

