/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.forex;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.business.service.builder.AbstractCashFlowBuilder;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.helper.ForexCashFlowHelper;

public abstract class AbstractForexCashFlowBuilder
extends AbstractCashFlowBuilder {
    private static final Log logger = LogFactory.getLog(AbstractForexCashFlowBuilder.class);

    @Override
    protected List<Map<String, Object>> bulidCashFlow() {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        int index = 1;
        Map<String, Object> cashFlow = this.createCashFlowData(index);
        datas.add(cashFlow);
        if (this.model.getModel() instanceof IDataModel) {
            Map<String, Object> resetCashFlow;
            IDataModel dataModel = (IDataModel)this.model.getModel();
            if ("tm_forex".equals(dataModel.getDataEntityType().getName())) {
                resetCashFlow = this.createResetCashFlowData(cashFlow);
                datas.add(resetCashFlow);
            }
            if ("tm_forex_forward".equals(dataModel.getDataEntityType().getName())) {
                resetCashFlow = this.createResetCashFlowData_FWD(cashFlow);
                datas.add(resetCashFlow);
            }
        } else if (this.model.getModel() instanceof DynamicObject) {
            Map<String, Object> resetCashFlow;
            DynamicObject dataModel = (DynamicObject)this.model.getModel();
            if ("tm_forex".equals(dataModel.getDataEntityType().getName())) {
                resetCashFlow = this.createResetCashFlowData(cashFlow);
                datas.add(resetCashFlow);
            }
            if ("tm_forex_forward".equals(dataModel.getDataEntityType().getName())) {
                resetCashFlow = this.createResetCashFlowData_FWD(cashFlow);
                datas.add(resetCashFlow);
            }
        }
        return datas;
    }

    protected Map<String, Object> createCashFlowData(int index) {
        String deliveryWay = null;
        if (this.model.getModel() instanceof IDataModel) {
            IDataModel dataModel = (IDataModel)this.model.getModel();
            deliveryWay = (String)dataModel.getValue("deliveryway");
        } else if (this.model.getModel() instanceof DynamicObject) {
            DynamicObject bill = (DynamicObject)this.model.getModel();
            deliveryWay = bill.getString("deliveryway");
        }
        Map<String, Object> cashFlow = new HashMap<String, Object>();
        cashFlow.put("id", DBServiceHelper.genGlobalLongId());
        cashFlow.put("no", String.valueOf(index));
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
            cashFlow.put("cftype", CashFlowTypeEnum.pl);
        } else {
            cashFlow.put("cftype", CashFlowTypeEnum.capital);
        }
        cashFlow.put("cfishis", Boolean.FALSE);
        this.initPayDate(cashFlow);
        this.initCurrency(cashFlow);
        this.initPayAmount(cashFlow);
        this.initOtherData(cashFlow);
        cashFlow = this.buildBillUpdateData(cashFlow);
        cashFlow.put("cfdealrival", this.model.getValue("counterparty"));
        return cashFlow;
    }

    @Override
    protected Map<String, Object> initCashFlow(DynamicObject bill) {
        HashMap<String, Object> cashFlow = new HashMap<String, Object>();
        cashFlow.put("no", bill.getString("billno"));
        cashFlow.put("cfpaydate", bill.getDate("cfpaydate"));
        cashFlow.put("cfcurrency", bill.getDynamicObject("cfcurrency"));
        cashFlow.put("cfpayamount", bill.getBigDecimal("cfpayamount"));
        cashFlow.put("cfamount", bill.get("cfamount"));
        cashFlow.put("cfpv", bill.get("cfpv"));
        cashFlow.put("cftheta", bill.get("cftheta"));
        cashFlow.put("cfdiscfactor", bill.get("cfdiscfactor"));
        cashFlow.put("cfdealrival", bill.get("cfdealrival"));
        cashFlow.put("cfishis", bill.get("cfishis"));
        return cashFlow;
    }

    @Override
    protected Map<String, Object> buildBillUpdateData(Map<String, Object> cashFlow) {
        if (((Boolean)cashFlow.get("cfishis")).booleanValue()) {
            return cashFlow;
        }
        this.initPayAmount(cashFlow);
        return cashFlow;
    }

    protected Map<String, Object> createResetCashFlowData(Map<String, Object> cashFlow) {
        HashMap<String, Object> resetRow = new HashMap<String, Object>();
        resetRow.put("id", DBServiceHelper.genGlobalLongId());
        resetRow.put("pid", cashFlow.get("id"));
        resetRow.put("no", cashFlow.get("no") + ".1");
        resetRow.put("cftype", "");
        resetRow.put("cfratefixdate", this.model.getValue("bizdate"));
        resetRow.put("cffixrate", this.model.getValue("spotrate"));
        Long fqId = ((DynamicObject)this.model.getValue("pricerule")).getDynamicObject("forexquote").getLong("id");
        String fxQuote = (String)this.model.getValue("fxquote");
        ForexQuoteInfo preExrateInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, (Date)((Date)this.model.getValue("settledate")));
        String dir = (String)this.model.getValue("tradedirect");
        String pair = (String)this.model.getValue("pair");
        BigDecimal preExrate = dir.equals(TradeDirectionEnum.buy.getValue()) && pair.equals(preExrateInfo.getFxquote()) || dir.equals(TradeDirectionEnum.sell.getValue()) && !pair.equals(preExrateInfo.getFxquote()) ? preExrateInfo.getSellPrice() : preExrateInfo.getBuyPrice();
        String fq = preExrateInfo.getFxquote();
        if (!fq.equals(fxQuote)) {
            BigDecimal newExRate = BigDecimal.ONE.divide(preExrate, 10, RoundingMode.HALF_UP);
            logger.info("\u53d6\u5230\u7684\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)preExrate, (Object)newExRate);
            preExrate = newExRate;
        }
        resetRow.put("cfuserate", preExrate);
        return resetRow;
    }

    protected Map<String, Object> createResetCashFlowData_FWD(Map<String, Object> cashFlow) {
        HashMap<String, Object> resetRow = new HashMap<String, Object>();
        resetRow.put("id", DBServiceHelper.genGlobalLongId());
        resetRow.put("pid", cashFlow.get("id"));
        resetRow.put("no", cashFlow.get("no") + ".1");
        resetRow.put("cftype", "");
        Date paydate = (Date)cashFlow.get("cfpaydate");
        Long fqId = ((DynamicObject)this.model.getValue("pricerule")).getDynamicObject("forexquote").getLong("id");
        String fxQuote = (String)this.model.getValue("fxquote");
        ForexQuoteInfo preExrateInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, (Date)paydate);
        String dir = (String)this.model.getValue("tradedirect");
        String pair = (String)this.model.getValue("pair");
        BigDecimal preExrate = dir.equals(TradeDirectionEnum.buy.getValue()) && pair.equals(preExrateInfo.getFxquote()) || dir.equals(TradeDirectionEnum.sell.getValue()) && !pair.equals(preExrateInfo.getFxquote()) ? preExrateInfo.getSellPrice() : preExrateInfo.getBuyPrice();
        String fq = preExrateInfo.getFxquote();
        if (!fq.equals(fxQuote)) {
            BigDecimal newExRate = BigDecimal.ONE.divide(preExrate, 10, RoundingMode.HALF_UP);
            logger.info("\u53d6\u5230\u7684\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)preExrate, (Object)newExRate);
            preExrate = newExRate;
        }
        resetRow.put("cffixrate", this.model.getValue("spotrate"));
        resetRow.put("cfuserate", preExrate);
        String deliverWay = (String)this.model.getValue("deliveryway");
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliverWay)) {
            DynamicObjectCollection wc = (DynamicObjectCollection)this.model.getValue("workcalendar");
            int offset = (Integer)this.model.getValue("settledelay");
            resetRow.put("cfratefixdate", TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)paydate, (int)(-offset)));
        }
        return resetRow;
    }

    protected abstract void initPayDate(Map<String, Object> var1);

    protected abstract void initCurrency(Map<String, Object> var1);

    protected abstract void initPayAmount(Map<String, Object> var1);

    protected void initOtherData(Map<String, Object> cashFlow) {
    }

    @Override
    protected List<String> getTradeBillSelector() {
        List<String> sic = super.getTradeBillSelector();
        sic.add("buymarket");
        sic.add("sellmarket");
        sic.add("settleamt");
        sic.add("settlecurrency");
        sic.add("deliveryway");
        sic.add("amount");
        sic.add("sellamount");
        sic.add("currency");
        sic.add("sellcurrency");
        sic.add("isdaterange");
        sic.add("adjsettledate_end");
        sic.add("adjustsettledate");
        sic.add("fxquote");
        sic.add("pair");
        sic.add("spotrate");
        return sic;
    }

    @Override
    protected Date[] getIntDate(Map<String, Object> cashFlow, ModelAgent model) {
        Date payDate = (Date)cashFlow.get("cfpaydate");
        return new Date[]{payDate, TcDateUtils.getLastDay((Date)payDate, (int)1)};
    }

    protected boolean isSameFx(DynamicObject tradebill) {
        String pair = tradebill.getString("pair");
        String fxquote = tradebill.getString("fxquote");
        return !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, fxquote}) && pair.equals(fxquote);
    }

    @Override
    public DynamicObject[] refresh(ModelAgent model) {
        DynamicObject[] cashFlows;
        DynamicObject tradeBill = (DynamicObject)model.getModel();
        Long id = tradeBill.getLong("id");
        QFilter filter = new QFilter("billid", "=", (Object)id);
        String direction = this.getFilter();
        if (EmptyUtil.isNoEmpty((String)direction)) {
            filter.and("cfdirection", "=", (Object)this.getFilter()).and("cfIsHis", "=", (Object)false);
        }
        if (!this.isRefresh(model, cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cfPayDate,cfCurrency,cfPayAmount,cfPrincipal,cfFixRate,cfUseRate", (QFilter[])filter.toArray()))) {
            return null;
        }
        for (DynamicObject cashFlow : cashFlows) {
            DynamicObjectCollection entrys = cashFlow.getDynamicObjectCollection("entrys");
            if (entrys.size() == 0) continue;
            DynamicObject subRow = (DynamicObject)entrys.get(0);
            Date cfPayDate = cashFlow.getDate("cfPayDate");
            BigDecimal exRate = ForexCashFlowHelper.queryExRate((DynamicObject)tradeBill, (Date)cfPayDate);
            subRow.set("cfuserate", (Object)exRate);
            String deliveryWay = tradeBill.getString("deliveryway");
            if (!DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) continue;
            BigDecimal cfPrincipal = cashFlow.getBigDecimal("cfPrincipal");
            BigDecimal cfFixRate = subRow.getBigDecimal("cfFixRate");
            BigDecimal cfPayAmount = ForexCashFlowHelper.calcPayAmount_fwd((DynamicObject)tradeBill, (BigDecimal)cfPrincipal, (BigDecimal)cfFixRate, (BigDecimal)exRate);
            cashFlow.set("cfpayamount", (Object)cfPayAmount);
        }
        return cashFlows;
    }
}

