/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.forex;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.tm.business.service.builder.forex.AbstractForexCashFlowBuilder;
import kd.tmc.tm.common.enums.DeliveryWayEnum;

public class ForexSellCashFlowBuilder
extends AbstractForexCashFlowBuilder {
    private static final Log logger = LogFactory.getLog(ForexSellCashFlowBuilder.class);

    @Override
    protected void initPayDate(Map<String, Object> cashFlow) {
        cashFlow.put("cfpaydate", this.model.getValue("settledate"));
        if ("tm_forex_forward".equals(this.model.getDynamicObject().getDataEntityType().getName())) {
            boolean isDataRange = (Boolean)this.model.getValue("isdaterange");
            if (isDataRange) {
                cashFlow.put("cfpaydate", this.model.getValue("adjsettledate_end"));
            } else {
                cashFlow.put("cfpaydate", this.model.getValue("adjustsettledate"));
            }
        }
    }

    @Override
    protected void initCurrency(Map<String, Object> cashFlow) {
        cashFlow.put("cfcurrency", this.model.getValue("sellcurrency"));
    }

    @Override
    protected void initPayAmount(Map<String, Object> cashFlow) {
        String tradeDir = (String)this.model.getValue("tradedirect");
        BigDecimal payAmount = (BigDecimal)this.model.getValue("sellamount");
        String deliverWay = (String)this.model.getValue("deliveryway");
        if ("tm_forex_forward".equals(this.model.getDynamicObject().getDataEntityType().getName())) {
            DynamicObject sellCurrency = (DynamicObject)this.model.getValue("sellcurrency");
            DynamicObject settleCurrency = (DynamicObject)this.model.getValue("settlecurrency");
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliverWay) && sellCurrency.getLong("id") == settleCurrency.getLong("id")) {
                BigDecimal preExrate;
                BigDecimal principal = (BigDecimal)this.model.getValue("amount");
                BigDecimal fwdExrate = (BigDecimal)this.model.getValue("spotrate");
                Long fqId = ((DynamicObject)this.model.getValue("pricerule")).getDynamicObject("forexquote").getLong("id");
                String fxQuote = (String)this.model.getValue("fxquote");
                Date adjDate = (Boolean)this.model.getValue("isdaterange") != false ? (Date)this.model.getValue("adjsettledate_end") : (Date)this.model.getValue("adjustsettledate");
                ForexQuoteInfo preExrateInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, (Date)adjDate);
                String pair = (String)this.model.getValue("pair");
                String fq = preExrateInfo.getFxquote();
                boolean isSame = pair.equals(fq);
                BigDecimal bigDecimal = preExrate = isSame && TradeDirectionEnum.buy.getValue().equals(tradeDir) || !isSame && TradeDirectionEnum.sell.getValue().equals(tradeDir) ? preExrateInfo.getSellPrice() : preExrateInfo.getBuyPrice();
                if (!fq.equals(fxQuote)) {
                    BigDecimal newExRate = BigDecimal.ONE.divide(preExrate, 10, RoundingMode.HALF_UP);
                    logger.info("\u53d6\u5230\u7684\u9884\u4f30\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)preExrate, (Object)newExRate);
                    preExrate = newExRate;
                }
                payAmount = this.isSameFx(this.model.getDynamicObject()) ? preExrate.subtract(fwdExrate).multiply(principal) : BigDecimal.ONE.divide(preExrate, 10, 4).subtract(BigDecimal.ONE.divide(fwdExrate, 10, 4)).multiply(principal);
            }
        }
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliverWay)) {
            if (TradeDirectionEnum.sell.getValue().equals(tradeDir)) {
                payAmount = payAmount.negate();
            }
        } else if (TradeDirectionEnum.buy.getValue().equals(tradeDir)) {
            payAmount = payAmount.negate();
        }
        cashFlow.put("cfpayamount", payAmount);
    }

    @Override
    protected void initOtherData(Map<String, Object> cashFlow) {
        cashFlow.put("cfdirection", TradeDirectionEnum.sell);
        if ("tm_forex_forward".equals(this.model.getDynamicObject().getDataEntityType().getName())) {
            String deliverWay = (String)this.model.getValue("deliveryway");
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliverWay)) {
                cashFlow.put("cfprincipal", this.model.getValue("amount"));
            }
        }
    }

    @Override
    protected Long[] getMarket(ModelAgent model) {
        Long sellMarketId = ((DynamicObject)model.getValue("sellmarket")).getLong("id");
        return new Long[]{sellMarketId};
    }

    @Override
    protected String getFilter() {
        return TradeDirectionEnum.sell.getValue();
    }
}

