/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.rate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.business.service.builder.AbstractCashFlowBuilder;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.helper.ForwRateAgreeCFBizHelper;

public class ForwRateAgreeCashFlowBuiler
extends AbstractCashFlowBuilder {
    @Override
    protected List<Map<String, Object>> bulidCashFlow() {
        ArrayList<Map<String, Object>> datas = new ArrayList();
        DynamicObject priceRule = (DynamicObject)this.model.getValue("pricerule");
        if (EmptyUtil.isEmpty((DynamicObject)priceRule)) {
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u5b9a\u4ef7\u89c4\u5219\u672a\u586b\u5199\u3002", (String)"ForwRateAgreeCashFlowBuiler_0", (String)"tmc-tm-business", (Object[])new Object[0]));
            return datas;
        }
        datas = this.getRowList();
        return datas;
    }

    protected List<Map<String, Object>> getRowList() {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("no", 1);
        row.put("id", DBServiceHelper.genGlobalLongId());
        row.put("cftype", CashFlowTypeEnum.floatrate.getValue());
        String payRule = (String)this.model.getValue("payrule");
        Date adjSettledate = (Date)this.model.getValue("adjustsettledate");
        String basis = (String)this.model.getValue("basis");
        Date paydate = payRule.equals("advance") ? adjSettledate : (Date)this.model.getValue("adjustenddate");
        row.put("cfpaydate", paydate);
        row.put("cfcurrency", (DynamicObject)this.model.getValue("currency"));
        rowList.add(row);
        HashMap<String, Object> resetRow = new HashMap<String, Object>(2);
        resetRow.put("no", 1.1);
        resetRow.put("pid", row.get("id"));
        DynamicObjectCollection workCalendars = (DynamicObjectCollection)this.model.getValue("indexcalendar");
        int offset = (Integer)this.model.getValue("rateresetoffset");
        Date rateFixdate = WorkCalendarHelper.getLastWorkDate((DynamicObjectCollection)workCalendars, (Date)adjSettledate, (int)offset);
        resetRow.put("cfratefixdate", rateFixdate);
        resetRow.put("cfresetpaydate", paydate);
        resetRow.put("cfunadjstartdate", (Date)this.model.getValue("settledate"));
        resetRow.put("cfadjstartdate", (Date)this.model.getValue("adjustsettledate"));
        resetRow.put("cfunadjenddate", (Date)this.model.getValue("enddate"));
        resetRow.put("cfadjenddate", (Date)this.model.getValue("adjustenddate"));
        AdjustMethodEnum adjustmethod = AdjustMethodEnum.valueOf((String)((String)this.model.getValue("dateadjustmethod")));
        boolean isAdj = !adjustmethod.equals((Object)AdjustMethodEnum.no_adjust);
        resetRow.put("cfisadjust", isAdj);
        resetRow.put("cfperioddays", this.getPeriodDays());
        resetRow.put("cfbasis", basis);
        DynamicObject referIndex = (DynamicObject)this.model.getValue("referindex");
        resetRow.put("cfratefixindex", referIndex);
        resetRow.put("cfreferindexfreq", EmptyUtil.isNoEmpty((DynamicObject)referIndex) ? referIndex.getString("term") : null);
        resetRow.put("cfindexbasis", basis);
        BigDecimal rate = this.getResetPredictRate(resetRow);
        resetRow.put("cfresetpredictrate", rate);
        resetRow.put("cfuserate", resetRow.get("cfresetpredictrate"));
        rowList.add(resetRow);
        BigDecimal useRate = (BigDecimal)resetRow.get("cfuserate");
        BigDecimal payAmount = ForwRateAgreeCFBizHelper.getPayAmount((BigDecimal)useRate, (ModelAgent)this.model);
        row.put("cfpayamount", payAmount);
        row.put("cfamount", payAmount);
        row.put("cfexchangerate", Constants.ONE);
        PriceRuleInfo info = this.getDiscfactor(row, this.model);
        Date payDate = (Date)row.get("cfpaydate");
        BigDecimal dfs = (BigDecimal)info.getYieldCurve()[0].getDfMap().get(payDate);
        BigDecimal nextDfs = (BigDecimal)info.getYieldCurve()[0].getDfMap().get(TcDateUtils.getLastDay((Date)payDate, (int)1));
        row.put("cfdiscfactor", dfs);
        row.put("cfpv", dfs.multiply(payAmount));
        row.put("cftheta", dfs.subtract(nextDfs).multiply(payAmount).negate());
        if (this.model instanceof IDataModel) {
            ((IDataModel)this.model).setValue("fraprice", resetRow.get("cfuserate"));
            ((IDataModel)this.model).setValue("pv", row.get("cfpv"));
        }
        return rowList;
    }

    @Override
    protected Map<String, Object> buildBillUpdateData(Map<String, Object> cashFlow) {
        PriceRuleInfo info = this.getDiscfactor(cashFlow, this.model);
        Date payDate = (Date)cashFlow.get("cfpaydate");
        BigDecimal dfs = (BigDecimal)info.getYieldCurve()[0].getDfMap().get(payDate);
        BigDecimal nextDfs = (BigDecimal)info.getYieldCurve()[0].getDfMap().get(TcDateUtils.getLastDay((Date)payDate, (int)1));
        cashFlow.put("cfdiscfactor", dfs);
        BigDecimal payAmount = (BigDecimal)cashFlow.get("cfpayamount");
        Boolean isRatecFg = (Boolean)cashFlow.get("cfisratecfg");
        if (isRatecFg.booleanValue()) {
            BigDecimal rate = this.getResetPredictRate(cashFlow);
            cashFlow.put("cfresetpredictrate", rate);
            cashFlow.put("cfuserate", rate);
            payAmount = ForwRateAgreeCFBizHelper.getPayAmount((BigDecimal)rate, (ModelAgent)this.model);
            cashFlow.put("cfpayamount", payAmount);
            cashFlow.put("cfamount", payAmount);
        }
        cashFlow.put("cfpv", dfs.multiply(payAmount));
        cashFlow.put("cftheta", dfs.subtract(nextDfs).multiply(payAmount).negate());
        return cashFlow;
    }

    @Override
    protected Map<String, Object> initCashFlow(DynamicObject info) {
        Map<String, Object> cashFlow = super.initCashFlow(info);
        if (info.getDynamicObjectCollection("entrys").size() > 0) {
            DynamicObject entry = (DynamicObject)info.getDynamicObjectCollection("entrys").get(0);
            cashFlow.put("cfisratecfg", entry.getBoolean("cfisratecfg"));
            cashFlow.put("cfresetpredictrate", entry.getBigDecimal("cfresetpredictrate"));
            cashFlow.put("cfratefixdate", entry.getDate("cfratefixdate"));
            cashFlow.put("cfratefixindex", entry.get("cfratefixindex"));
        }
        return cashFlow;
    }

    protected int getPeriodDays() {
        BasisEnum basis = BasisEnum.valueOf((String)((String)this.model.getValue("basis")));
        Object[] calendars = new DynamicObject[]{};
        DynamicObjectCollection workCalendars = (DynamicObjectCollection)this.model.getValue("indexcalendar");
        int periodDays = TradeBusinessHelper.getBasis_BetweenDay((Date)((Date)this.model.getValue("adjustsettledate")), (Date)((Date)this.model.getValue("adjustenddate")), (BasisEnum)basis, (DynamicObject[])((DynamicObject[])workCalendars.toArray(calendars)));
        return periodDays;
    }

    protected BigDecimal getResetPredictRate(Map<String, Object> resetRow) {
        Date referdate = this.getReferDate();
        Date rateFixdate = (Date)resetRow.get("cfratefixdate");
        DynamicObject refIndex = (DynamicObject)resetRow.get("cfratefixindex");
        if (EmptyUtil.isEmpty((DynamicObject)refIndex)) {
            return Constants.ZERO;
        }
        refIndex = TmcDataServiceHelper.loadSingle((Object)refIndex.getPkValue(), (String)"tbd_referrate");
        if (referdate.before(rateFixdate)) {
            DynamicObject priceRule = (DynamicObject)this.model.getValue("pricerule");
            DynamicObject market = (DynamicObject)this.model.getValue("market");
            PayFrequeEnum refFreq = PayFrequeEnum.valueOf((String)refIndex.getString("term"));
            Date indexDate = PayFrequeEnum.getNextDateByPayfreq((Date)rateFixdate, (PayFrequeEnum)refFreq);
            BigDecimal rate = (BigDecimal)MarketDataHelper.getFurRateByYieldCurve((IFormView)this.view, (YieldTypeEnum)YieldTypeEnum.ref, (DynamicObject)priceRule, (Long)market.getLong("id"), (Date)referdate, (Date)rateFixdate, (Date[])new Date[]{indexDate}).get(indexDate);
            return rate;
        }
        DynamicObject priceRule = (DynamicObject)this.model.getValue("pricerule");
        DynamicObject market = (DynamicObject)this.model.getValue("market");
        PayFrequeEnum refFreq = PayFrequeEnum.valueOf((String)refIndex.getString("term"));
        Date indexDate = PayFrequeEnum.getNextDateByPayfreq((Date)referdate, (PayFrequeEnum)refFreq);
        BigDecimal rate = (BigDecimal)MarketDataHelper.getRateByYieldCurve((IFormView)this.view, (YieldTypeEnum)YieldTypeEnum.ref, (DynamicObject)priceRule, (Long)market.getLong("id"), (Date)referdate, (Date[])new Date[]{indexDate}).get(indexDate);
        return rate;
    }

    @Override
    protected Long[] getMarket(ModelAgent model) {
        Long marketId = ((DynamicObject)model.getValue("market")).getLong("id");
        return new Long[]{marketId};
    }

    @Override
    protected Date[] getIntDate(Map<String, Object> cashFlow, ModelAgent model) {
        Date adjSettledate = (Date)model.getValue("adjustsettledate");
        Date adjEnddate = (Date)model.getValue("adjustenddate");
        Date[] queryList = new Date[]{adjSettledate, TcDateUtils.getLastDay((Date)adjSettledate, (int)1), adjEnddate, TcDateUtils.getLastDay((Date)adjEnddate, (int)1)};
        return queryList;
    }

    @Override
    protected String getFilter() {
        return null;
    }

    @Override
    protected List<String> getTradeBillSelector() {
        List<String> billSelector = super.getTradeBillSelector();
        billSelector.add("adjustsettledate");
        billSelector.add("adjustenddate");
        billSelector.add("payrule");
        billSelector.add("tradedirect");
        billSelector.add("indexcalendar");
        billSelector.add("contractrate");
        billSelector.add("billstatus");
        return billSelector;
    }

    @Override
    protected List<String> getCashFlowSelector() {
        List<String> cashFlowSelector = super.getCashFlowSelector();
        cashFlowSelector.add("cfratefixindex");
        cashFlowSelector.add("cfratefixindex.term");
        return cashFlowSelector;
    }

    @Override
    protected boolean isRefresh(ModelAgent bill, DynamicObject[] cashFlows) {
        String billStatus = (String)bill.getValue("billstatus");
        return !TcBillStatusEnum.FINISH.getValue().equals(billStatus);
    }
}

