/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.swap;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.tm.business.service.builder.swap.AbstractForexSwapsCashFlowBuilder;

public class ForexSwapsBuyCashFlowBuilder
extends AbstractForexSwapsCashFlowBuilder {
    @Override
    protected void initPayAmount(Map<String, Object> cashFlow) {
        BigDecimal dir = BigDecimal.ONE;
        String direction = (String)this.model.getValue("tradedirect");
        if (TradeDirectionEnum.sell.getValue().equals(direction)) {
            dir = dir.negate();
        }
        BigDecimal amt = cashFlow.get("no").equals("1") ? ((BigDecimal)this.model.getValue("amount")).multiply(dir) : ((BigDecimal)this.model.getValue("buyamount_far")).multiply(dir.negate());
        cashFlow.put("cfpayamount", amt);
    }

    @Override
    protected void initCurrency(Map<String, Object> cashFlow) {
        cashFlow.put("cfcurrency", this.model.getValue("currency"));
    }

    @Override
    protected void initOtherData(Map<String, Object> cashFlow) {
        cashFlow.put("cfdirection", TradeDirectionEnum.buy);
    }

    @Override
    protected Long[] getMarket(ModelAgent model) {
        Long buyMarketId = ((DynamicObject)model.getValue("buymarket")).getLong("id");
        return new Long[]{buyMarketId};
    }

    @Override
    protected String getFilter() {
        return TradeDirectionEnum.buy.getValue();
    }
}

