/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.tm.business.service.factory.IBondBizServiceFacade;
import kd.tmc.tm.common.enums.BondBizTypeEnum;
import kd.tmc.tm.common.helper.BondBizHelper;
import kd.tmc.tm.common.helper.CashFlowHelper;
import org.apache.commons.math3.util.Pair;

public class BondBizServiceFacadeImpl
implements IBondBizServiceFacade {
    @Override
    public Map<String, BigDecimal> getATMValue(Long bondIssueId, Date referdate, Long priceRuleId, Date settledate) {
        BigDecimal CP_Theory;
        BigDecimal accrual_Theory;
        BigDecimal accrual;
        DynamicObject bondIssue = TmcDataServiceHelper.loadSingle((Object)bondIssueId, (String)"tm_bondissue");
        DynamicObjectCollection cashFlowList = CashFlowHelper.queryCashFlow((Long)bondIssue.getLong("id"));
        BigDecimal totalAmt = bondIssue.getBigDecimal("totalissueamt");
        String biBizType = bondIssue.getString("biztype");
        if (BondBizTypeEnum.zeroBond.getValue().equals(biBizType)) {
            accrual = BondBizHelper.getAccrual_Zero();
            accrual_Theory = BondBizHelper.getAccrual_Theory_Zero();
            BigDecimal maturityDF = ((DynamicObject)cashFlowList.get(cashFlowList.size() - 1)).getBigDecimal("cfdiscfactor");
            BigDecimal DP_Theory = BondBizHelper.getDP_Theory_Zero((BigDecimal)maturityDF);
            CP_Theory = BondBizHelper.getCP_Theory_Zero((BigDecimal)maturityDF);
        } else {
            Date accrueFrom = bondIssue.getDate("accruefrom");
            Pair param_calAccrual = CashFlowHelper.getParam_CalAccrual((DynamicObjectCollection)cashFlowList, (Date)settledate, (Date)accrueFrom);
            DynamicObject nextPayRow_options = (DynamicObject)param_calAccrual.getSecond();
            Date lastPaydate_options = (Date)param_calAccrual.getFirst();
            Date nextPaydate_options = nextPayRow_options.getDate("cfpaydate");
            BigDecimal nextPayAmount_options = (BigDecimal)nextPayRow_options.get("cfpayamount");
            accrual = BondBizHelper.getAccrual_FixAndFloat((DynamicObject)bondIssue, (String)"buy", (Date)settledate, (Date)lastPaydate_options, (Date)nextPaydate_options, (BigDecimal)nextPayAmount_options);
            Pair payRows_refer = CashFlowHelper.getParam_CalAccrual((DynamicObjectCollection)cashFlowList, (Date)referdate, (Date)accrueFrom);
            DynamicObject nextPayRow_refer = (DynamicObject)payRows_refer.getSecond();
            Date lastPaydate_refer = (Date)payRows_refer.getFirst();
            Date nextPaydate_refer = nextPayRow_refer.getDate("cfpaydate");
            BigDecimal nextPayAmount_refer = (BigDecimal)nextPayRow_refer.get("cfpayamount");
            accrual_Theory = BondBizHelper.getAccrual_Theory_FixAndFloat((DynamicObject)bondIssue, (String)"buy", (Date)referdate, (Date)lastPaydate_refer, (Date)nextPaydate_refer, (BigDecimal)nextPayAmount_refer);
            boolean isAfter_refer = BondBizHelper.isAfter((DynamicObject)bondIssue, (Date)referdate, (Date)nextPaydate_refer);
            BigDecimal DP_Theory = BondBizHelper.getDP_Theory_FixAndFloat((DynamicObject)bondIssue, (String)"buy", (boolean)isAfter_refer, (Date)referdate, (BigDecimal)totalAmt, (DynamicObjectCollection)cashFlowList);
            CP_Theory = BondBizHelper.getCP_Theory_FixAndFloat((String)"buy", (BigDecimal)totalAmt, (BigDecimal)DP_Theory, (BigDecimal)accrual_Theory);
        }
        BigDecimal fundRate = BondBizHelper.getFundRate((DynamicObject)bondIssue, (Date)referdate, (Long)priceRuleId, (Date)settledate);
        BigDecimal ATM_DP = BondBizHelper.calFDP((DynamicObject)bondIssue, (Date)referdate, (Date)settledate, (DynamicObjectCollection)cashFlowList, (BigDecimal)accrual_Theory, (BigDecimal)CP_Theory, (BigDecimal)fundRate);
        BigDecimal ATM_CP = BondBizHelper.calFCP((BigDecimal)ATM_DP, (BigDecimal)accrual);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        result.put("ATM_DP", ATM_DP);
        result.put("ATM_CP", ATM_CP);
        return result;
    }

    @Override
    public BigDecimal getStrikeValue(Long bondIssueId, Date referdate, Long priceRuleId, String method, BigDecimal var) {
        if (method.equals("getStrikeCPByDP")) {
            return this.getStrikeCPByDP(bondIssueId, referdate, priceRuleId, var);
        }
        return this.getStrikeDPByCP(bondIssueId, referdate, priceRuleId, var);
    }

    protected BigDecimal getStrikeCPByDP(Long bondIssueId, Date referdate, Long priceRuleId, BigDecimal DP_Theory) {
        DynamicObject bondIssue = TmcDataServiceHelper.loadSingle((Object)bondIssueId, (String)"tm_bondissue");
        BigDecimal CP_Theory = BigDecimal.ZERO;
        String biztype = bondIssue.getString("biztype");
        if (BondBizTypeEnum.fixBond.getValue().equals(biztype) || BondBizTypeEnum.floatBond.getValue().equals(biztype)) {
            BigDecimal totalAmt = bondIssue.getBigDecimal("totalissueamt");
            DynamicObjectCollection cashFlowList = CashFlowHelper.queryCashFlow((Long)bondIssue.getLong("id"));
            Date accrueFrom = bondIssue.getDate("accruefrom");
            Pair param_calAccrual = CashFlowHelper.getParam_CalAccrual((DynamicObjectCollection)cashFlowList, (Date)referdate, (Date)accrueFrom);
            DynamicObject nextPayRow_refer = (DynamicObject)param_calAccrual.getSecond();
            Date lastPaydate_refer = (Date)param_calAccrual.getFirst();
            Date nextPaydate_refer = nextPayRow_refer.getDate("cfpaydate");
            BigDecimal nextPayAmount_refer = (BigDecimal)nextPayRow_refer.get("cfpayamount");
            BigDecimal accrualTheory = BondBizHelper.getAccrual_Theory_FixAndFloat((DynamicObject)bondIssue, (String)"buy", (Date)referdate, (Date)lastPaydate_refer, (Date)nextPaydate_refer, (BigDecimal)nextPayAmount_refer);
            CP_Theory = BondBizHelper.getCP_Theory_FixAndFloat((String)"buy", (BigDecimal)totalAmt, (BigDecimal)DP_Theory, (BigDecimal)accrualTheory);
        } else {
            CP_Theory = DP_Theory;
        }
        return CP_Theory;
    }

    protected BigDecimal getStrikeDPByCP(Long bondIssueId, Date referdate, Long priceRuleId, BigDecimal CP_Theory) {
        DynamicObject bondIssue = TmcDataServiceHelper.loadSingle((Object)bondIssueId, (String)"tm_bondissue");
        BigDecimal DP_Theory = BigDecimal.ZERO;
        String biztype = bondIssue.getString("biztype");
        if (BondBizTypeEnum.fixBond.getValue().equals(biztype) || BondBizTypeEnum.floatBond.getValue().equals(biztype)) {
            BigDecimal totalAmt = bondIssue.getBigDecimal("totalissueamt");
            DynamicObjectCollection cashFlowList = CashFlowHelper.queryCashFlow((Long)bondIssue.getLong("id"));
            Date accrueFrom = bondIssue.getDate("accruefrom");
            Pair param_calAccrual = CashFlowHelper.getParam_CalAccrual((DynamicObjectCollection)cashFlowList, (Date)referdate, (Date)accrueFrom);
            DynamicObject nextPayRow_refer = (DynamicObject)param_calAccrual.getSecond();
            Date lastPaydate_refer = (Date)param_calAccrual.getFirst();
            Date nextPaydate_refer = nextPayRow_refer.getDate("cfpaydate");
            BigDecimal nextPayAmount_refer = (BigDecimal)nextPayRow_refer.get("cfpayamount");
            BigDecimal accrual_Theory = BondBizHelper.getAccrual_Theory_FixAndFloat((DynamicObject)bondIssue, (String)"buy", (Date)referdate, (Date)lastPaydate_refer, (Date)nextPaydate_refer, (BigDecimal)nextPayAmount_refer);
            DP_Theory = BondBizHelper.getDPByCP_Theory_FixAndFloat((String)"buy", (BigDecimal)totalAmt, (BigDecimal)CP_Theory, (BigDecimal)accrual_Theory);
        } else {
            DP_Theory = CP_Theory;
        }
        return DP_Theory;
    }
}

