/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.business;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.AmountProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.resource.TeBizResource;

public class BusinessBillSaveOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List list = super.getSelector();
        list.add("billno");
        list.add("execexrate");
        list.add("tradebill");
        list.add("operate");
        list.add("execexrate");
        list.add("bizrecordid");
        list.add("protecttype");
        list.add("bizamt1");
        list.add("restamt1");
        return list;
    }

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        String error = new TeBizResource().getBillNoEmpty();
        HashMap<Long, Boolean> cache = new HashMap<Long, Boolean>();
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            if (EmptyUtil.isEmpty((String)bill.getString("billno"))) {
                this.addErrorMessage(data, error);
            }
            DynamicObject tradebill = bill.getDynamicObject("tradebill");
            DynamicObject productType = tradebill.getDynamicObject("protecttype");
            Long sid = tradebill.getLong("id");
            if (cache.get(sid) != null) {
                if (((Boolean)cache.get(sid)).booleanValue()) {
                    this.addErrorMessage(data, TeBizResource.SaveCheckExistBizDealBill());
                    continue;
                }
            } else {
                QFilter filter = new QFilter("billstatus", "<", (Object)TcBillStatusEnum.AUDIT.getValue()).and("tradebill", "=", (Object)sid).and("id", "!=", (Object)bill.getLong("id"));
                DynamicObjectCollection businessBillCol = QueryServiceHelper.query((String)"tm_businessbill", (String)"id", (QFilter[])filter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)businessBillCol)) {
                    cache.put(sid, Boolean.TRUE);
                    this.addErrorMessage(data, TeBizResource.SaveCheckExistBizDealBill());
                    continue;
                }
                cache.put(sid, Boolean.FALSE);
            }
            this.checkAmountMaxValue(data);
            if (!ProductTypeEnum.STRUCTDEPOSIT.getId().equals(productType.getString("id"))) {
                Long bizRecordId = bill.getLong("bizrecordid");
                QFilter qFilter = new QFilter("id", "=", (Object)bizRecordId);
                boolean recordExists = TmcDataServiceHelper.exists((String)"tm_bizrecord", (QFilter[])qFilter.toArray());
                if (!recordExists) {
                    this.addErrorMessage(data, TeBizResource.checkBizRecord());
                }
            } else if (!TcBillStatusEnum.SURVIVAL.getValue().equals(tradebill.get("billstatus"))) {
                this.addErrorMessage(data, TeBizResource.checkBizRecord());
            }
            DynamicObject protectType = tradebill.getDynamicObject("protecttype");
            if (ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id")) || ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id")) || ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id")) || ProductTypeEnum.FOREXOPTION.getId().equals(protectType.getString("id"))) {
                Long bizRecordId = bill.getLong("bizrecordid");
                DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((Object)bizRecordId, (String)"tm_bizrecord");
                if (bill.getBigDecimal("bizamt1").compareTo(bizRecord.getBigDecimal("restamt")) > 0) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u64cd\u4f5c\u91d1\u989d>\u6e90\u5355\u5269\u4f59\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusinessBillSaveOpValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
                } else {
                    BigDecimal restAmt1;
                    DynamicObject currency = tradebill.getDynamicObject("currency");
                    int amtPrecision = currency != null ? currency.getInt("amtprecision") : 2;
                    BigDecimal bizAmt1 = bill.getBigDecimal("bizamt1").setScale(amtPrecision, 4);
                    BigDecimal amt = bizAmt1.add(restAmt1 = bill.getBigDecimal("restamt1").setScale(amtPrecision, 4));
                    if (amt.compareTo(bizRecord.getBigDecimal("restamt")) > 0) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u64cd\u4f5c\u91d1\u989d+\u5269\u4f59\u91d1\u989d>\u6e90\u5355\u5269\u4f59\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusinessBillSaveOpValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
                    }
                }
            }
            if (!ProductTypeEnum.STRUCTDEPOSIT.getId().equals(productType.getString("id")) && !ProductTypeEnum.FORWRATEAGREE.getId().equals(productType.getString("id"))) continue;
            String op = bill.getString("operate");
            QFilter qFilter = new QFilter("tradebill", "=", tradebill.getPkValue()).and("operate", "=", (Object)op).and("id", "!=", bill.getPkValue());
            if (!QueryServiceHelper.exists((String)"tm_businessbill", (QFilter[])qFilter.toArray())) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4ea4\u6613%1$s\u5df2\u8fdb\u884c%2$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusinessBillSaveOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]), tradebill.getString("number"), BizOperateEnum.getName((String)op)));
        }
    }

    protected void checkAmountMaxValue(ExtendedDataEntity data) {
        DynamicObject bill = data.getDataEntity();
        TeBizResource bizResource = new TeBizResource();
        for (IDataEntityProperty prop : bill.getDataEntityType().getProperties()) {
            if (!(prop instanceof AmountProp) || bill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT) <= 0 && bill.getBigDecimal(prop.getName()).compareTo(Constants.MAX_AMOUNT.negate()) >= 0) continue;
            this.addErrorMessage(data, bizResource.checkAmountMaxValue(prop.getDisplayName().getLocaleValue()));
        }
    }
}

