/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.combreqnote;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.CombReqNoteEnum;

public class CombReqNotePushCombTradeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("producttype");
        selector.add("forwardinfo");
        selector.add("swapsinfo");
        selector.add("optionsinfo");
        selector.add("composeno");
        selector.add("composeaudit");
        selector.add("isalllgenbill");
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDBizException {
        for (ExtendedDataEntity data : entities) {
            Object id = data.getValue("id");
            DynamicObject combreqnote = TmcDataServiceHelper.loadSingle((Object)id, (String)"tm_combreqnote");
            this.validateIsAllGenBill(data, combreqnote);
            this.validateBillStatusAndComposeno(data, combreqnote);
        }
    }

    private void validateBillStatusAndComposeno(ExtendedDataEntity data, DynamicObject bill) {
        boolean composeaudit = bill.getBoolean("composeaudit");
        for (CombReqNoteEnum value : CombReqNoteEnum.values()) {
            DynamicObjectCollection entrise = bill.getDynamicObjectCollection(value.getEntryName());
            for (DynamicObject entry : entrise) {
                long id = entry.getLong(value.getBillIdName());
                if (EmptyUtil.isEmpty((Long)id)) continue;
                DynamicObject trade = QueryServiceHelper.queryOne((String)"tm_trade", (String)"billStatus,billno,composeno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                String tradeBillStatus = trade.getString("billStatus");
                if (composeaudit && TcBillStatusEnum.SAVE.getValue().equals(tradeBillStatus)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u5355%s\u8fd8\u672a\u63d0\u4ea4\uff0c\u8bf7\u5148\u63d0\u4ea4\u4ea4\u6613\u5355\u3002", (String)"CombReqNotePushCombTradeValidator_0", (String)"tmc-tm-business", (Object[])new Object[]{trade.getString("billno")}));
                }
                if (!(composeaudit || TcBillStatusEnum.AUDIT.getValue().equals(tradeBillStatus) || TcBillStatusEnum.SURVIVAL.getValue().equals(tradeBillStatus))) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u5355%s\u8fd8\u672a\u5ba1\u6838\u6216\u672a\u4ea4\u6613\u786e\u8ba4\uff0c\u8bf7\u5148\u5ba1\u6838\u6216\u786e\u8ba4\u4ea4\u6613\u5355\u3002", (String)"CombReqNotePushCombTradeValidator_1", (String)"tmc-tm-business", (Object[])new Object[]{trade.getString("billno")}));
                }
                if (!EmptyUtil.isNotEmpty((CharSequence)trade.getString("composeno"))) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u751f\u6210\u7ec4\u5408\u4ea4\u6613\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"CombReqNotePushCombTradeValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateIsAllGenBill(ExtendedDataEntity data, DynamicObject bill) {
        boolean isAlllGenBill = bill.getBoolean("isalllgenbill");
        if (!isAlllGenBill) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u5b58\u5728\u672a\u4e0b\u63a8\u7684\u4ea4\u6613\u5355\uff0c\u8bf7\u5148\u4e0b\u63a8\u4ea4\u6613\u5355\u3002", (String)"CombReqNotePushCombTradeValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

