/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.combtrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CombTradeSaveOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        List sel = super.getSelector();
        sel.add("billno");
        sel.add("tradebill");
        sel.add("name");
        sel.add("protecttype");
        sel.add("tradedirect");
        sel.add("tradedate");
        sel.add("tradebillentity");
        sel.add("tradeorg");
        sel.add("entryentity");
        sel.add("tradebillno");
        sel.add("reqnoteno");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        List reqnotes = Arrays.stream(dataEntities).filter(t -> EmptyUtil.isNoEmpty((String)t.getDataEntity().getString("reqnoteno"))).map(t -> t.getDataEntity().getString("reqnoteno")).collect(Collectors.toList());
        DynamicObjectCollection reqnotesCol = QueryServiceHelper.query((String)"tm_combreqnote", (String)"id,billno, composeno", (QFilter[])new QFilter[]{new QFilter("billno", "in", reqnotes)});
        HashMap<String, String> combno2Reqnotes = new HashMap<String, String>();
        for (DynamicObject reqnoteDO : reqnotesCol) {
            String key = reqnoteDO.getString("billno");
            combno2Reqnotes.put(key, reqnoteDO.getString("composeno"));
        }
        for (ExtendedDataEntity entity : dataEntities) {
            String reqnoteComposeNo;
            DynamicObject dataEntity = entity.getDataEntity();
            DynamicObjectCollection tradeEntry = dataEntity.getDynamicObjectCollection("entryentity");
            String reqnoteno = dataEntity.getString("reqnoteno");
            String billno = dataEntity.getString("billno");
            if (EmptyUtil.isNotEmpty((CharSequence)reqnoteno) && EmptyUtil.isNotEmpty((CharSequence)(reqnoteComposeNo = (String)combno2Reqnotes.get(reqnoteno))) && !StringUtils.equals((CharSequence)reqnoteComposeNo, (CharSequence)billno)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ec4\u5408\u4ea4\u6613\u5df2\u4e0b\u63a8\uff0c\u4e0d\u80fd\u91cd\u590d\u4e0b\u63a8\u3002", (String)"CombTradeSubmitOpValidator_6", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection currOrgs = entity.getDataEntity().getDynamicObjectCollection("org");
            List<Object> orgIds = new ArrayList(1);
            if (currOrgs != null) {
                orgIds = currOrgs.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
            }
            if (tradeEntry.size() > 0) {
                for (DynamicObject dynamicObject : tradeEntry) {
                    Long billId = dynamicObject.getLong("tradebill");
                    String tradeBillNO = dynamicObject.getString("tradebillno");
                    String tradeBillEntity = dynamicObject.getString("tradebillentity");
                    DynamicObject bill = QueryServiceHelper.queryOne((String)tradeBillEntity, (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
                    if (bill == null || orgIds.contains(bill.getLong("org"))) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4ea4\u6613\u53f7\uff1a{0}\u7684\u7ec4\u7ec7\u4e0d\u662f\u4ea4\u6613\u4e3b\u4f53\u5305\u542b\u7684\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CombTradeSaveOpValidator_1", (String)"tmc-tm-business", (Object[])new Object[]{tradeBillNO}));
                }
                continue;
            }
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6ca1\u6709\u4ea4\u6613\u7ec4\u5408\u4fe1\u606f\uff0c\u8bf7\u9009\u62e9\u4ea4\u6613\u3002", (String)"CombTradeSaveOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

