/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.combtrade;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;

public class CombTradeUnAuditOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        super.getSelector();
        List sel = super.getSelector();
        sel.add("billno");
        sel.add("tradebill");
        sel.add("name");
        sel.add("protecttype");
        sel.add("tradedirect");
        sel.add("tradedate");
        sel.add("tradebillentity");
        sel.add("tradeorg");
        return sel;
    }

    public void validate(ExtendedDataEntity[] DataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : DataEntity) {
            boolean isUnAudit = true;
            DynamicObjectCollection entryentity = entity.getDataEntity().getDynamicObjectCollection("entryentity");
            if (entryentity.size() == 0) continue;
            for (DynamicObject dynamicObject : entryentity) {
                boolean isbuysettle;
                DynamicObject bill;
                Long billId = dynamicObject.getLong("tradebill");
                String tradeBillEntity = dynamicObject.getString("tradebillentity");
                String selectStr = "org,composeno, billstatus,composeaudit";
                if (ProductTypeEnum.FOREXOPTION.getEntity().equals(tradeBillEntity) || ProductTypeEnum.SWAP.getEntity().equals(tradeBillEntity) || ProductTypeEnum.STRUCTDEPOSIT.getEntity().equals(tradeBillEntity)) {
                    selectStr = selectStr + ",isbuysettle";
                }
                if ((bill = QueryServiceHelper.queryOne((String)tradeBillEntity, (String)selectStr, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)})) == null) continue;
                String billstatus = bill.getString("billstatus");
                if (!bill.getBoolean("composeaudit")) continue;
                if ((ProductTypeEnum.FOREXOPTION.getEntity().equals(tradeBillEntity) || ProductTypeEnum.SWAP.getEntity().equals(tradeBillEntity) || ProductTypeEnum.STRUCTDEPOSIT.getEntity().equals(tradeBillEntity)) && (isbuysettle = bill.getBoolean("isbuysettle"))) {
                    isUnAudit = false;
                    break;
                }
                if (TcBillStatusEnum.AUDIT.getValue().equals(billstatus)) continue;
                isUnAudit = false;
                break;
            }
            if (isUnAudit) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u6240\u6709\u7ec4\u5408\u5ba1\u6838\u7684\u4ea4\u6613\u5355\u7684\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u4e14\u6ca1\u6709\u4e70\u5165\u7ed3\u7b97\u3002", (String)"CombTradeUnAuditOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

