/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.forex;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.tm.common.enums.DeliveryWayEnum;

public class ForexSubmitOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("term");
        sic.add("term_far");
        sic.add("adjexpiredate");
        sic.add("adjustsettledate");
        sic.add("isdaterange");
        sic.add("term_end");
        sic.add("settledate_start");
        sic.add("settledate_end");
        sic.add("adjsettledate_start");
        sic.add("adjsettledate_end");
        sic.add("deliveryway");
        sic.add("settlecurrency");
        sic.add("workcalendar");
        sic.add("spotrate");
        sic.add("forwrate");
        sic.add("isovernight");
        sic.add("term");
        sic.add("term_far");
        sic.add("bizdate");
        sic.add("settledate");
        sic.add("exchangerate");
        sic.add("isspecexrate");
        sic.add("isspecrate");
        sic.add("spotrate");
        sic.add("pips");
        sic.add("forwrate");
        sic.add("currencyrate");
        sic.add("sellcurrencyrate");
        sic.add("isspecvol");
        sic.add("volatility");
        return sic;
    }

    public void validate(ExtendedDataEntity[] DataEntity) throws KDBizException {
        String forexFwdDateValidator = ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u533a\u95f4\u3001\u8c03\u6574\u4ea4\u5272\u65e5\u533a\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForexSubmitOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]);
        String ForexFwdTermEndValidator = ResManager.loadKDString((String)"\u957f\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForexSubmitOpValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]);
        String SettleCurrencyIsNull = ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForexSubmitOpValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]);
        String ExRateValidator = ResManager.loadKDString((String)"\u8fd1\u7aef\u6c47\u7387\u3001\u8fdc\u7aef\u6c47\u7387\u9700\u8981\u5927\u4e8e0\u3002", (String)"ForexSubmitOpValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]);
        String ForexFwdDateRangeValidator = ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u533a\u95f4\u53f3\u4fa7\u9700\u5927\u4e8e\u4ea4\u5272\u65e5\u533a\u95f4\u5de6\u4fa7\u3002", (String)"ForexSubmitOpValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]);
        String SpotRateValidator = ResManager.loadKDString((String)"\u6c47\u7387\u9700\u8981\u5927\u4e8e0\u3002", (String)"ForexSubmitOpValidator_5", (String)"tmc-tm-business", (Object[])new Object[0]);
        String settleDateNullValidator = ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForexSubmitOpValidator_6", (String)"tmc-tm-business", (Object[])new Object[0]);
        String settleDateValidator = ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u9700\u5927\u4e8e\u7b49\u4e8e\u4ea4\u6613\u65e5\u3002", (String)"ForexSubmitOpValidator_7", (String)"tmc-tm-business", (Object[])new Object[0]);
        String exchangeRateValidator = ResManager.loadKDString((String)"\u6267\u884c\u6c47\u7387\u9700\u5927\u4e8e0\u3002", (String)"ForexSubmitOpValidator_8", (String)"tmc-tm-business", (Object[])new Object[0]);
        for (ExtendedDataEntity data : DataEntity) {
            BigDecimal forwRate;
            BigDecimal pips;
            BigDecimal spotRate;
            boolean isSpecexRate;
            boolean isSpecvol;
            DynamicObject settleCurrency;
            BigDecimal spotRate2;
            DynamicObject bill = data.getDataEntity();
            String entityName = bill.getDataEntityType().getName();
            if ("tm_forex".equals(entityName) && BigDecimal.ZERO.compareTo(spotRate2 = bill.getBigDecimal("spotrate")) >= 0) {
                this.addErrorMessage(data, SpotRateValidator);
            }
            if ("tm_forex_forward".equals(entityName)) {
                Date bizDate;
                DynamicObject settleCurrency2;
                boolean isDateRange;
                spotRate2 = bill.getBigDecimal("spotrate");
                if (BigDecimal.ZERO.compareTo(spotRate2) >= 0) {
                    this.addErrorMessage(data, SpotRateValidator);
                }
                if (isDateRange = bill.getBoolean("isdaterange")) {
                    Date adjSettledate_end;
                    Date adjSettledate_start;
                    Date settledate_end;
                    Date settledate_start = bill.getDate("settledate_start");
                    if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{settledate_start, settledate_end = bill.getDate("settledate_end"), adjSettledate_start = bill.getDate("adjsettledate_start"), adjSettledate_end = bill.getDate("adjsettledate_end")})) {
                        this.addErrorMessage(data, forexFwdDateValidator);
                    } else if (!settledate_end.after(settledate_start)) {
                        this.addErrorMessage(data, ForexFwdDateRangeValidator);
                    }
                    String termEnd = bill.getString("term_end");
                    if (EmptyUtil.isEmpty((String)termEnd)) {
                        this.addErrorMessage(data, ForexFwdTermEndValidator);
                    }
                }
                String deliveryWay = bill.getString("deliveryway");
                if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && EmptyUtil.isEmpty((DynamicObject)(settleCurrency2 = bill.getDynamicObject("settlecurrency")))) {
                    this.addErrorMessage(data, SettleCurrencyIsNull);
                }
                if (EmptyUtil.isNoEmpty((Object)(bizDate = bill.getDate("bizdate")))) {
                    DynamicObjectCollection wc = bill.getDynamicObjectCollection("workcalendar");
                    Date settleDelayDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)bizDate, (int)2);
                    settleDelayDate = TermUtils.getNextDateByBaseDate4ymd((String)"1d", (Date)settleDelayDate);
                    if (bill.getBoolean("isdaterange")) {
                        Date settleDate_start = bill.getDate("settledate_start");
                        Date settleDate_end = bill.getDate("settledate_end");
                        if (settleDate_start != null && settleDate_start.compareTo(settleDelayDate) < 0 || settleDate_end != null && settleDate_end.compareTo(settleDelayDate) < 0) {
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u5f55\u5165\u4ea4\u5272\u65e5\u533a\u95f4\u3002", (String)"ForexSubmitOpValidator_13", (String)"tmc-tm-business", (Object[])new Object[0]));
                        }
                    } else {
                        Date settleDate = bill.getDate("settledate");
                        if (settleDate != null && settleDate.compareTo(settleDelayDate) < 0) {
                            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u5f55\u5165\u4ea4\u5272\u65e5\u3002", (String)"ForexSubmitOpValidator_14", (String)"tmc-tm-business", (Object[])new Object[0]));
                        }
                    }
                }
            }
            if ("tm_forex_swaps".equals(entityName)) {
                spotRate2 = bill.getBigDecimal("spotrate");
                BigDecimal fwdRate = bill.getBigDecimal("forwrate");
                if (BigDecimal.ZERO.compareTo(spotRate2) >= 0 || BigDecimal.ZERO.compareTo(fwdRate) >= 0) {
                    this.addErrorMessage(data, ExRateValidator);
                }
                if (!bill.getBoolean("isovernight") && EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bill.getString("term"), bill.getString("term_far")})) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8fd1\u7aef\u671f\u9650\u3001\u8fdc\u7aef\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForexSubmitOpValidator_11", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
            }
            if (!"tm_forex_options".equals(bill.getDataEntityType().getName())) continue;
            String deliveryWay = bill.getString("deliveryway");
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && EmptyUtil.isEmpty((DynamicObject)(settleCurrency = bill.getDynamicObject("settlecurrency")))) {
                this.addErrorMessage(data, SettleCurrencyIsNull);
            }
            Date bizdate = bill.getDate("bizdate");
            Date settledate = bill.getDate("settledate");
            if (EmptyUtil.isEmpty((Object)settledate)) {
                this.addErrorMessage(data, settleDateNullValidator);
            } else if (settledate.before(bizdate)) {
                this.addErrorMessage(data, settleDateValidator);
            }
            BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
            if (BigDecimal.ZERO.compareTo(exchangeRate) >= 0) {
                this.addErrorMessage(data, exchangeRateValidator);
            }
            if ((isSpecvol = bill.getBoolean("isspecvol")) && EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("volatility"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6ce2\u52a8\u7387(%)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForexSubmitOpValidator_12", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            if (!(isSpecexRate = bill.getBoolean("isspecexrate")) || !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{spotRate = bill.getBigDecimal("spotrate"), pips = bill.getBigDecimal("pips"), forwRate = bill.getBigDecimal("forwrate")})) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5373\u671f\u6c47\u7387\u3001\u8fdc\u671f\u70b9\uff08BP\uff09\u3001\u8fdc\u671f\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForexSubmitOpValidator_9", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

