/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.optioncom;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.resource.TeBizResource;

public class OptionCombSubmitOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("entrys");
        sic.add("assettype");
        sic.add("asset");
        sic.add("billno");
        return sic;
    }

    public void validate(ExtendedDataEntity[] DataEntity) throws KDBizException {
        ArrayList<Long> allTradLists = new ArrayList<Long>(10);
        for (ExtendedDataEntity data : DataEntity) {
            DynamicObjectCollection entrys;
            String composeno;
            DynamicObject combreqnote;
            String reqnoteno = data.getDataEntity().getString("reqno");
            String billno = data.getDataEntity().getString("billno");
            if (EmptyUtil.isNotEmpty((CharSequence)reqnoteno) && (combreqnote = QueryServiceHelper.queryOne((String)"tm_combreqnote", (String)"composeno", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)reqnoteno)})) != null && EmptyUtil.isNotEmpty((CharSequence)(composeno = combreqnote.getString("composeno"))) && !StringUtils.equals((CharSequence)composeno, (CharSequence)billno)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ec4\u5408\u4ea4\u6613\u5df2\u4e0b\u63a8\uff0c\u4e0d\u80fd\u91cd\u590d\u4e0b\u63a8\u3002", (String)"CombTradeSubmitOpValidator_6", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)(entrys = data.getDataEntity().getDynamicObjectCollection("entrys"))) || entrys.size() < 1) {
                this.addErrorMessage(data, TeBizResource.selectMoreOneTrade());
                continue;
            }
            String assetType = data.getDataEntity().getString("assettype");
            String asset = data.getDataEntity().getString("asset");
            ArrayList<Long> tradeList = new ArrayList<Long>(10);
            for (DynamicObject entry : entrys) {
                DynamicObject tradeNo = entry.getDynamicObject("tradeno");
                if (EmptyUtil.isEmpty((DynamicObject)tradeNo)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u53f7\uff1a{0}\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CombTradeSubmitOpValidator_5", (String)"tmc-tm-business", (Object[])new Object[]{entry.getString("tradenum")}));
                    continue;
                }
                tradeList.add(tradeNo.getLong("id"));
            }
            if (tradeList.size() == 0) continue;
            DynamicObjectCollection tradeBills = QueryServiceHelper.query((String)assetType.replace("_l", ""), (String)"id,pair,billno,composeno,billstatus,composeaudit,adjexpiredate", (QFilter[])new QFilter[]{new QFilter("id", "in", tradeList)});
            Date date = ((DynamicObject)tradeBills.get(0)).getDate("adjexpiredate");
            HashSet<String> dupTradeNoSet = new HashSet<String>(5);
            for (DynamicObject tradeBill : tradeBills) {
                boolean validStatus;
                Long id = tradeBill.getLong("id");
                if (allTradLists.contains(id)) {
                    dupTradeNoSet.add(tradeBill.getString("billno"));
                } else {
                    allTradLists.add(id);
                }
                String composeno2 = tradeBill.getString("composeno");
                String billstatus = tradeBill.getString("billstatus");
                Boolean composeaudit = tradeBill.getBoolean("composeaudit");
                String pair = tradeBill.getString("pair");
                boolean bl = validStatus = "C,D".contains(billstatus) || "B".equals(billstatus) && Boolean.TRUE.equals(composeaudit);
                if (!validStatus || !EmptyUtil.isEmpty((String)composeno2)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u53f7\uff1a{0}\u4e0d\u6ee1\u8db3\u6784\u5efa\u7ec4\u5408\u7684\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CombTradeSubmitOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[]{tradeBill.getString("billno")}));
                    continue;
                }
                switch (assetType) {
                    case "tm_forex_options_l": {
                        if (asset.equals(pair) && date.equals(tradeBill.getDate("adjexpiredate"))) break;
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u53f7\uff1a{0}\u4e0d\u6ee1\u8db3\u6784\u5efa\u7ec4\u5408\u7684\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CombTradeSubmitOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[]{tradeBill.getString("billno")}));
                    }
                }
            }
            if (dupTradeNoSet.size() <= 0) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u4ea4\u6613\u4e2d\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CombTradeSubmitOpValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

