/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.reqlimit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReqLimitSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("valistdate");
        selector.add("valienddate");
        selector.add("setstdate");
        selector.add("setenddate");
        selector.add("entryentity");
        selector.add("entryentity.currency");
        selector.add("entryentity.limitamt");
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDBizException {
        for (ExtendedDataEntity data : entities) {
            DynamicObject entity = data.getDataEntity();
            this.valideDate(data);
            DynamicObjectCollection entryentities = entity.getDynamicObjectCollection("entryentity");
            if (entryentities.size() == 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u989d\u5ea6\u4fe1\u606f\u5206\u5f55\u3002", (String)"ReqLimitSubmitValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                continue;
            }
            boolean hasEmpty = false;
            boolean hasRepeatCurr = false;
            ArrayList<Long> currencyIds = new ArrayList<Long>();
            for (DynamicObject entryentity : entryentities) {
                DynamicObject currency = entryentity.getDynamicObject("currency");
                BigDecimal limitamt = entryentity.getBigDecimal("limitamt");
                if (currency != null) {
                    long id = currency.getLong("id");
                    if (currencyIds.contains(id)) {
                        hasRepeatCurr = true;
                    } else {
                        currencyIds.add(id);
                    }
                } else {
                    hasEmpty = true;
                }
                if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{limitamt})) continue;
                hasEmpty = true;
            }
            if (hasEmpty) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u989d\u5ea6\u4fe1\u606f\u5206\u5f55\u7684\u989d\u5ea6\u5e01\u79cd\u548c\u7533\u8bf7\u989d\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReqLimitSubmitValidator_2", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            if (!hasRepeatCurr) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u989d\u5ea6\u4fe1\u606f\u5206\u5f55\u7684\u989d\u5ea6\u5e01\u79cd\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ReqLimitSubmitValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private void valideDate(ExtendedDataEntity data) {
        DynamicObject entity = data.getDataEntity();
        Date valienddate = entity.getDate("valienddate");
        Date valistdate = entity.getDate("valistdate");
        Date setstdate = entity.getDate("setstdate");
        Date setenddate = entity.getDate("setenddate");
        if (!EmptyUtil.isEmpty((Object)valienddate) && EmptyUtil.isEmpty((Object)valistdate)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u989d\u5ea6\u5230\u671f\u65e5\u6709\u503c\uff0c\u989d\u5ea6\u751f\u6548\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReqLimitSubmitValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        if (!EmptyUtil.isEmpty((Object)setenddate) && EmptyUtil.isEmpty((Object)setstdate)) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ea4\u6613\u5230\u671f\u65e5\u6709\u503c\uff0c\u4ea4\u6613\u5f00\u59cb\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReqLimitSubmitValidator_4", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

