/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.reqlimit;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReqLimitUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entryentity");
        selector.add("useamt");
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDBizException {
        for (ExtendedDataEntity data : entities) {
            DynamicObject entity = data.getDataEntity();
            DynamicObjectCollection entryentities = entity.getDynamicObjectCollection("entryentity");
            BigDecimal useamt = entryentities.stream().map(e -> e.getBigDecimal("useamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (!EmptyUtil.isNoEmpty((BigDecimal)useamt) || useamt.compareTo(BigDecimal.ZERO) <= 0) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5355\u5df2\u88ab\u4ea4\u6613\u7533\u8bf7\u5355\u4f7f\u7528\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"ReqLimitUnAuditValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }
}

