/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.requestnote;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReqNoteGenForexValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("reqnoteno");
        selector.add("source");
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDBizException {
        block0: for (ExtendedDataEntity entity : entities) {
            String entityName = entity.getDataEntity().getDataEntityType().getName();
            String reqNoteNo = (String)entity.getValue("reqnoteno");
            if (EmptyUtil.isEmpty((String)reqNoteNo) || QueryServiceHelper.exists((String)entityName, (Object)entity.getValue("id"))) continue;
            Long sourcebillid = (Long)entity.getValue("sourcebillid");
            String producttype = (String)entity.getValue("source");
            QFilter reqNoteFilter = new QFilter("billno", "=", (Object)reqNoteNo);
            String entryIdProp = this.getEntryName(entityName) + ".id";
            reqNoteFilter.and(new QFilter(entryIdProp, "=", (Object)sourcebillid));
            DynamicObject reqNoteInfo = producttype.contains("combreqnote_") ? TmcDataServiceHelper.loadSingle((String)"tm_combreqnote", (String)("billstatus,billno," + this.getIsPushedColumn(entityName)), (QFilter[])new QFilter[]{reqNoteFilter}) : TmcDataServiceHelper.loadSingle((String)"tm_reqnote", (String)("billstatus,billno," + this.getIsPushedColumn(entityName)), (QFilter[])new QFilter[]{reqNoteFilter});
            if (reqNoteInfo != null) {
                String billStatus = reqNoteInfo.getString("billstatus");
                if (!TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    String billNo = reqNoteInfo.getString("billno");
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"%s\u7533\u8bf7\u5355\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001,\u8bf7\u91cd\u65b0\u4e0b\u63a8\u3002", (String)"ReqNoteGenForexValidator_2", (String)"tmc-tm-business", (Object[])new Object[]{billNo}));
                    continue;
                }
                QFilter qFilter = new QFilter("sourcebillid", "=", (Object)sourcebillid);
                boolean exists = TmcDataServiceHelper.exists((String)entityName, (QFilter[])qFilter.toArray());
                DynamicObjectCollection entryCol = reqNoteInfo.getDynamicObjectCollection(this.getEntryName(entityName));
                for (DynamicObject entry : entryCol) {
                    if (!exists && (((Long)entity.getValue("sourcebillid")).longValue() != entry.getLong("id") || !entry.getBoolean(this.getIsPushedColumn(entityName)))) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6b64\u6761\u4ea4\u6613\u5355\u5bf9\u5e94\u7684\u7533\u8bf7\u5355\u5df2\u4e0b\u63a8\u5e76\u4fdd\u5b58\u8fc7\u4ea4\u6613\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u4ea4\u6613\u5355\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReqNoteGenForexValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                    continue block0;
                }
                continue;
            }
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u4e0b\u63a8\u3002", (String)"ReqNoteGenForexValidator_3", (String)"tmc-tm-business", (Object[])new Object[0])});
        }
    }

    private String getIsPushedColumn(String entityType) {
        if ("tm_forex_forward".equals(entityType)) {
            return "foisbizbill";
        }
        if ("tm_forex".equals(entityType)) {
            return "spisbizbill";
        }
        if ("tm_forex_swaps".equals(entityType)) {
            return "swisbizbill";
        }
        if ("tm_forex_options".equals(entityType)) {
            return "opisbizbill";
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"ReqNoteGenForexValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
    }

    private String getEntryName(String entityType) {
        if ("tm_forex_forward".equals(entityType)) {
            return "forwardinfo";
        }
        if ("tm_forex".equals(entityType)) {
            return "spotinfo";
        }
        if ("tm_forex_swaps".equals(entityType)) {
            return "swapsinfo";
        }
        if ("tm_forex_options".equals(entityType)) {
            return "optionsinfo";
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"ReqNoteGenForexValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
    }
}

