/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.validate.requestnote;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.CombReqNoteEnum;
import kd.tmc.tm.common.helper.ReqNoteHelper;

public class ReqNoteLimitReturnValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("spotinfo");
        selector.add(StringUtils.join((Object[])new String[]{"spotinfo", ".", "spotcurrencytypein"}));
        selector.add(StringUtils.join((Object[])new String[]{"spotinfo", ".", "spotcurrencytypeout"}));
        selector.add(StringUtils.join((Object[])new String[]{"spotinfo", ".", "spotamountin"}));
        selector.add(StringUtils.join((Object[])new String[]{"spotinfo", ".", "spotamountout"}));
        selector.add(StringUtils.join((Object[])new String[]{"spotinfo", ".", "spbizdate"}));
        selector.add("swapsinfo");
        selector.add(StringUtils.join((Object[])new String[]{"swapsinfo", ".", "currin"}));
        selector.add(StringUtils.join((Object[])new String[]{"swapsinfo", ".", "currout"}));
        selector.add(StringUtils.join((Object[])new String[]{"swapsinfo", ".", "amtin"}));
        selector.add(StringUtils.join((Object[])new String[]{"swapsinfo", ".", "amtout"}));
        selector.add(StringUtils.join((Object[])new String[]{"swapsinfo", ".", "swbizdate"}));
        selector.add("forwardinfo");
        selector.add(StringUtils.join((Object[])new String[]{"forwardinfo", ".", "currencytypein"}));
        selector.add(StringUtils.join((Object[])new String[]{"forwardinfo", ".", "currencytypeout"}));
        selector.add(StringUtils.join((Object[])new String[]{"forwardinfo", ".", "amountin"}));
        selector.add(StringUtils.join((Object[])new String[]{"forwardinfo", ".", "amountout"}));
        selector.add(StringUtils.join((Object[])new String[]{"forwardinfo", ".", "fobizdate"}));
        selector.add("producttype");
        selector.add("limtno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] entities) throws KDException {
        HashMap<Long, List> datas = new HashMap<Long, List>(entities.length);
        for (ExtendedDataEntity data : entities) {
            DynamicObject dataEntity = data.getDataEntity();
            DynamicObject limit = dataEntity.getDynamicObject("limtno");
            if (EmptyUtil.isEmpty((DynamicObject)limit)) continue;
            long limitId = limit.getLong("id");
            if (datas.containsKey(limitId)) {
                List list = (List)datas.get(limitId);
                list.add(data);
                datas.put(limitId, list);
                continue;
            }
            ArrayList<ExtendedDataEntity> reqNoteBills = new ArrayList<ExtendedDataEntity>();
            reqNoteBills.add(data);
            datas.put(limitId, reqNoteBills);
        }
        for (Map.Entry entry : datas.entrySet()) {
            Long limitId = (Long)entry.getKey();
            List reqNoteList = (List)entry.getValue();
            DynamicObject limitDb = TmcDataServiceHelper.loadSingle((Object)limitId, (String)"tm_reqlimit");
            if (EmptyUtil.isEmpty((DynamicObject)limitDb)) continue;
            DynamicObjectCollection limitEntries = limitDb.getDynamicObjectCollection("entryentity");
            HashMap<Long, DynamicObject> limitCurrAmtMap = new HashMap<Long, DynamicObject>();
            for (DynamicObject limitEntry : limitEntries) {
                DynamicObject curr = limitEntry.getDynamicObject("currency");
                Long currId = (Long)curr.getPkValue();
                limitCurrAmtMap.put(currId, limitEntry);
            }
            this.validateLimitAmt(limitDb, limitCurrAmtMap, reqNoteList);
        }
    }

    private void validateLimitAmt(DynamicObject limit, Map<Long, DynamicObject> limitCurrAmtMap, List<ExtendedDataEntity> reqNoteList) {
        HashMap<Long, BigDecimal> reqnoteCurrencyAmtMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, String> reqnoteCurrencyMap = new HashMap<Long, String>();
        for (ExtendedDataEntity extendedDataEntity : reqNoteList) {
            String entryName;
            DynamicObjectCollection reqNoteEntries;
            DynamicObject entity = extendedDataEntity.getDataEntity();
            DynamicObject product = entity.getDynamicObject("producttype");
            String productType = product.getString("number");
            CombReqNoteEnum combReqNoteEnum = CombReqNoteEnum.getByProductType((String)productType);
            if (combReqNoteEnum == null || EmptyUtil.isEmpty((DynamicObjectCollection)(reqNoteEntries = entity.getDynamicObjectCollection(entryName = combReqNoteEnum.getEntryName())))) continue;
            ReqNoteHelper.sumReqNoteCurrAndAmt((DynamicObjectCollection)reqNoteEntries, (CombReqNoteEnum)combReqNoteEnum, reqnoteCurrencyAmtMap, reqnoteCurrencyMap);
        }
        this.validateLimitCurrencyAmt(limit, limitCurrAmtMap, reqnoteCurrencyAmtMap, reqnoteCurrencyMap);
    }

    private void validateLimitCurrencyAmt(DynamicObject limit, Map<Long, DynamicObject> limitCurrencyMap, Map<Long, BigDecimal> reqnoteCurrencyAmtMap, Map<Long, String> reqnoteCurrencyMap) {
        boolean isContainCurr = true;
        ArrayList<String> currs = new ArrayList<String>();
        for (Map.Entry<Long, BigDecimal> entry : reqnoteCurrencyAmtMap.entrySet()) {
            Long currencyId = entry.getKey();
            BigDecimal amt = entry.getValue();
            if (EmptyUtil.isEmpty((BigDecimal)amt)) continue;
            if (!limitCurrencyMap.containsKey(currencyId)) {
                isContainCurr = false;
                currs.add(reqnoteCurrencyMap.get(currencyId));
                continue;
            }
            DynamicObject currEntry = limitCurrencyMap.get(currencyId);
            BigDecimal useamt = currEntry.getBigDecimal("useamt");
            DynamicObject entryCurrency = currEntry.getDynamicObject("currency");
            if (useamt.compareTo(amt) >= 0) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5355%1$s\u7684%2$s\u5bf9\u5e94\u7684\u4f7f\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u65e0\u6cd5\u8fd4\u8fd8\u989d\u5ea6\u3002", (String)"ReqNoteLimitReturnValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]), limit.getString("billno"), entryCurrency.getString("number")));
        }
        if (!isContainCurr) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7533\u8bf7\u5355\u7684%1$s\u4ea4\u6613\u5e01\u79cd\u4e0e\u9009\u5b9a\u7684\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5355%2$s\u7684\u989d\u5ea6\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u8fd4\u8fd8\u989d\u5ea6\u3002", (String)"ReqNoteLimitReturnValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]), String.join((CharSequence)",", currs), limit.getString("billno")));
        }
    }
}

